/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ImportDialog;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.types.Contact;
import de.inahware.dav.models.types.ContactType;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.query.Select;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.commons.csv.CSVFormat;

public class ImportCustomersDialog
extends ImportDialog<Customer> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ImportCustomersDialog(ClientContext ctx, Path csv, CSVFormat csv_format) throws Exception {
        super(ctx, Customer.MODEL, csv, csv_format);
        this.addPrimaryColumnType(this.BUNDLE.getString("Customer.ID"), field -> {
            long id = Long.parseLong(field);
            Customer obj = ctx.query(new Select<Customer>(Customer.MODEL, Customer.COL_ID.with(id)));
            if (obj != null) {
                this.doUpdate(new Customer(obj), obj);
                return obj;
            }
            obj = new Customer();
            obj.setId(id);
            this.doInsert(obj);
            return obj;
        });
        this.addColumnType(this.BUNDLE.getString("Customer.SALUTATION"), (obj, value) -> obj.setSalutation(Salutation.valueOf(value)));
        this.addColumnType(this.BUNDLE.getString("Customer.PREFIX"), (obj, value) -> obj.setPrefix((String)value));
        this.addColumnType(this.BUNDLE.getString("Customer.FIRST_NAME"), (obj, value) -> obj.setFirstName((String)value));
        this.addColumnType(this.BUNDLE.getString("Customer.LAST_NAME"), (obj, value) -> obj.setLastName((String)value));
        this.addColumnType(this.BUNDLE.getString("Customer.COMPANY"), (obj, value) -> obj.setCompany((String)value));
        for (ContactType type : ContactType.values()) {
            this.addColumnType(type.getLocalizedString(this.BUNDLE), (obj, value) -> {
                ArrayList<Contact> contacts = obj.getContactList();
                contacts.add(new Contact(type, (String)value));
                obj.setContactList(contacts);
            });
        }
    }

    @Override
    protected Customer initDefault() throws Exception {
        Customer obj = new Customer();
        this.doInsert(obj);
        return obj;
    }
}

