/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.edvj.data.DataField;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.gui.FormattedTableCellRenderer;
import de.inahware.edvj.query.InsertAll;
import de.inahware.edvj.query.QueryList;
import de.inahware.edvj.query.Update;
import de.inahware.edvj.query.filter.And;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ImportDialog<T extends DataObject>
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private List<T> import_insert;
    private List<Pair<T, T>> import_update;
    private JSplitPane splitPane;
    private JPanel panel_left;
    private JScrollPane scrollPane;
    private ETable<CSVRecord> table;
    private JPanel panel_right;
    private JLabel lblColumns;
    private JScrollPane scrollPane_1;
    private ETable<ColumnEntry> tblColumns;
    private JComboBox<ColumnType> cmbColumnTypes;
    private JPanel panel_bottom;
    private JButton btnCancel;
    private JButton btnImport;

    public ImportDialog(ClientContext ctx, DataModel<T> model, Path csv, CSVFormat csv_format) throws Exception {
        this.initialize();
        this.setTitle(this.BUNDLE.getString(model.getName()) + " - " + this.BUNDLE.getString("ImportDialog.title"));
        this.tblColumns.addColumn(this.BUNDLE.getString("ImportDialog.columns.title"), entry -> entry.title);
        this.tblColumns.addColumn(this.BUNDLE.getString("ImportDialog.columns.type"), ColumnType.class, entry -> entry.type, (entry, value) -> {
            entry.type = (ColumnType)value;
        });
        this.tblColumns.setDefaultRenderer(ColumnType.class, new FormattedTableCellRenderer(type -> type == null ? "-" : ((ColumnType)type).name));
        this.cmbColumnTypes = new JComboBox();
        this.cmbColumnTypes.setRenderer(new FormattedListCellRenderer(type -> type == null ? "-" : ((ColumnType)type).name));
        this.cmbColumnTypes.addItem(null);
        this.tblColumns.setDefaultEditor(ColumnType.class, new DefaultCellEditor(this.cmbColumnTypes));
        try (CSVParser parser = new CSVParser(Files.newBufferedReader(csv), csv_format);){
            for (String string : parser.getHeaderNames()) {
                this.table.addColumn(string, record -> record.get(string));
                ((ETableModel)this.tblColumns.getModel()).addRow(new ColumnEntry(string, null));
            }
            for (CSVRecord cSVRecord : parser) {
                ((ETableModel)this.table.getModel()).addRow(cSVRecord);
            }
        }
        this.btnImport.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            EUtils.blocking((Component)this, blocking -> {
                HashSet<ColumnType> set = new HashSet<ColumnType>();
                ColumnEntry entry_init = null;
                for (ColumnEntry next : this.tblColumns.getData()) {
                    if (next == null) continue;
                    if (set.contains(next.type)) {
                        throw new RuntimeException("column " + next.type.name + " selected twice");
                    }
                    set.add(next.type);
                    if (next.type.fn_init == null) continue;
                    if (entry_init != null) {
                        throw new RuntimeException("more than one primary column selected");
                    }
                    entry_init = next;
                }
                this.import_insert = new ArrayList<T>();
                this.import_update = new ArrayList<Pair<T, T>>();
                for (CSVRecord record : this.table.getData()) {
                    Object field;
                    Object obj = entry_init == null ? this.initDefault() : (((String)(field = record.get(entry_init.title))).isEmpty() ? this.initDefault() : (DataObject)entry_init.type.fn_init.apply((String)field));
                    field = this.tblColumns.getData().iterator();
                    while (field.hasNext()) {
                        ColumnEntry next = (ColumnEntry)field.next();
                        if (next.type.fn_update == null) continue;
                        String field2 = record.get(next.title);
                        next.type.fn_update.accept(obj, field2);
                    }
                }
                ArrayList updates = new ArrayList();
                for (Pair<T, T> pair : this.import_update) {
                    DataObject obj;
                    DataObject old = (DataObject)pair.getLeft();
                    List<DataField<?>> diff = old.diff(obj = (DataObject)pair.getRight());
                    if (diff.isEmpty()) continue;
                    updates.add(new Update(model, diff, new And(old.getPrimaryFields())));
                }
                ctx.query(new InsertAll<T>(model, this.import_insert));
                ctx.query(new QueryList(updates));
            });
            this.close();
        }));
        this.btnCancel.addActionListener(ev -> this.close());
    }

    protected void addPrimaryColumnType(String name, FailableFunction<String, T, Exception> fn) {
        ColumnType ct = new ColumnType(name, fn);
        this.cmbColumnTypes.addItem(ct);
        for (ColumnEntry entry : this.tblColumns.getData()) {
            if (!entry.title.equals(name)) continue;
            entry.type = ct;
        }
        ((AbstractTableModel)this.tblColumns.getModel()).fireTableDataChanged();
    }

    protected void addColumnType(String name, FailableBiConsumer<T, String, Exception> fn) {
        ColumnType ct = new ColumnType(name, fn);
        this.cmbColumnTypes.addItem(ct);
        for (ColumnEntry entry : this.tblColumns.getData()) {
            if (!entry.title.equals(name)) continue;
            entry.type = ct;
        }
        ((AbstractTableModel)this.tblColumns.getModel()).fireTableDataChanged();
    }

    protected T initDefault() throws Exception {
        throw new RuntimeException("no primary column selected");
    }

    protected void doInsert(T obj) {
        this.import_insert.add(obj);
    }

    protected void doUpdate(T init, T obj) {
        this.import_update.add(new ImmutablePair<T, T>(init, obj));
    }

    private void initialize() {
        this.setSize(800, 450);
        this.splitPane = new JSplitPane();
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setDividerLocation(500);
        this.panel_left = new JPanel();
        this.splitPane.setLeftComponent(this.panel_left);
        this.panel_left.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.scrollPane = new JScrollPane();
        this.panel_left.add((Component)this.scrollPane, "cell 0 0,grow");
        this.table = new ETable();
        this.table.setFillsViewportHeight(true);
        this.scrollPane.setViewportView(this.table);
        this.panel_right = new JPanel();
        this.splitPane.setRightComponent(this.panel_right);
        this.panel_right.setLayout(new MigLayout("", "[grow]", "[][grow]"));
        this.lblColumns = new JLabel(this.BUNDLE.getString("ImportDialog.label.columns"));
        this.panel_right.add((Component)this.lblColumns, "cell 0 0");
        this.scrollPane_1 = new JScrollPane();
        this.panel_right.add((Component)this.scrollPane_1, "cell 0 1,grow");
        this.tblColumns = new ETable();
        this.scrollPane_1.setViewportView(this.tblColumns);
        this.tblColumns.setFillsViewportHeight(true);
        this.panel_bottom = new JPanel();
        FlowLayout fl_panel_bottom = (FlowLayout)this.panel_bottom.getLayout();
        fl_panel_bottom.setAlignment(2);
        this.add((Component)this.panel_bottom, "South");
        this.btnImport = new JButton(this.BUNDLE.getString("ImportDialog.button.export"));
        this.panel_bottom.add(this.btnImport);
        this.btnCancel = new JButton(this.BUNDLE.getString("edvj.generic.button.close"));
        this.panel_bottom.add(this.btnCancel);
    }

    private class ColumnType {
        public String name;
        public FailableFunction<String, T, Exception> fn_init;
        public FailableBiConsumer<T, String, Exception> fn_update;

        public ColumnType(String name, FailableFunction<String, T, Exception> fn_init) {
            this.name = name;
            this.fn_init = fn_init;
            this.fn_update = null;
        }

        public ColumnType(String name, FailableBiConsumer<T, String, Exception> fn_update) {
            this.name = name;
            this.fn_init = null;
            this.fn_update = fn_update;
        }
    }

    private class ColumnEntry {
        public String title;
        public ColumnType type;

        public ColumnEntry(String title, ColumnType type) {
            this.title = title;
            this.type = type;
        }
    }
}

