/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ImportDialog;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.Contact;
import de.inahware.dav.models.types.ContactType;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.query.Select;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.commons.csv.CSVFormat;

public class ImportVendorsDialog
extends ImportDialog<Vendor> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ImportVendorsDialog(ClientContext ctx, Path csv, CSVFormat csv_format) throws Exception {
        super(ctx, Vendor.MODEL, csv, csv_format);
        this.addPrimaryColumnType(this.BUNDLE.getString("Vendor.ID"), field -> {
            long id = Long.parseLong(field);
            Vendor obj = ctx.query(new Select<Vendor>(Vendor.MODEL, Vendor.COL_ID.with(id)));
            if (obj != null) {
                this.doUpdate(new Vendor(obj), obj);
                return obj;
            }
            obj = new Vendor();
            obj.setId(id);
            this.doInsert(obj);
            return obj;
        });
        this.addColumnType(this.BUNDLE.getString("Vendor.SALUTATION"), (obj, value) -> obj.setSalutation(Salutation.valueOf(value)));
        this.addColumnType(this.BUNDLE.getString("Vendor.PREFIX"), (obj, value) -> obj.setPrefix((String)value));
        this.addColumnType(this.BUNDLE.getString("Vendor.FIRST_NAME"), (obj, value) -> obj.setFirstName((String)value));
        this.addColumnType(this.BUNDLE.getString("Vendor.LAST_NAME"), (obj, value) -> obj.setLastName((String)value));
        this.addColumnType(this.BUNDLE.getString("Vendor.COMPANY"), (obj, value) -> obj.setCompany((String)value));
        for (ContactType type : ContactType.values()) {
            this.addColumnType(type.getLocalizedString(this.BUNDLE), (obj, value) -> {
                ArrayList<Contact> contacts = obj.getContactList();
                contacts.add(new Contact(type, (String)value));
                obj.setContactList(contacts);
            });
        }
    }

    @Override
    protected Vendor initDefault() throws Exception {
        Vendor obj = new Vendor();
        this.doInsert(obj);
        return obj;
    }
}

