/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.User;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.InputDialog;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class LoginDialog
extends InputDialog<User> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private JLabel lblUsername;
    private JLabel lblPassword;
    private JTextField txtUsername;
    private JPasswordField pwdPassword;

    public LoginDialog(ClientContext ctx) {
        this.ctx = ctx;
        this.setTitle(this.BUNDLE.getString("LoginDialog.title"));
        this.setResizable(false);
        this.setPacking(true);
        this.initialize();
    }

    @Override
    protected User parseObject() throws Exception {
        this.pwdPassword.selectAll();
        this.pwdPassword.requestFocusInWindow();
        return EUtils.blocking((Component)this, blocking -> this.ctx.login(this.txtUsername.getText(), this.pwdPassword.getPassword()));
    }

    private void initialize() {
        this.rootPanel.setLayout(new MigLayout("", "[][200px,grow]", "[][]"));
        this.lblUsername = new JLabel(this.BUNDLE.getString("generic.label.username") + ":");
        this.rootPanel.add((Component)this.lblUsername, "cell 0 0,alignx trailing");
        this.txtUsername = new JTextField();
        this.rootPanel.add((Component)this.txtUsername, "cell 1 0,growx");
        this.txtUsername.setColumns(10);
        this.lblPassword = new JLabel(this.BUNDLE.getString("generic.label.password") + ":");
        this.rootPanel.add((Component)this.lblPassword, "cell 0 1,alignx trailing");
        this.pwdPassword = new JPasswordField();
        this.rootPanel.add((Component)this.pwdPassword, "cell 1 1,growx");
    }
}

