/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditSettingsDialog;
import de.inahware.dav.client.gui.ExportArticlesDialog;
import de.inahware.dav.client.gui.ExportCustomersDialog;
import de.inahware.dav.client.gui.ExportDocumentsDialog;
import de.inahware.dav.client.gui.ExportReportDialog;
import de.inahware.dav.client.gui.ExportVendorsDialog;
import de.inahware.dav.client.gui.ImportArticlesDialog;
import de.inahware.dav.client.gui.ImportCustomersDialog;
import de.inahware.dav.client.gui.ImportVendorsDialog;
import de.inahware.dav.client.gui.ShowArticlesDialog;
import de.inahware.dav.client.gui.ShowBankStatementsDialog;
import de.inahware.dav.client.gui.ShowCustomersDialog;
import de.inahware.dav.client.gui.ShowDiscountsDialog;
import de.inahware.dav.client.gui.ShowDocumentsDialog;
import de.inahware.dav.client.gui.ShowNoticesDialog;
import de.inahware.dav.client.gui.ShowOrdersDialog;
import de.inahware.dav.client.gui.ShowPendingNoticesDialog;
import de.inahware.dav.client.gui.ShowRecordCategoriesDialog;
import de.inahware.dav.client.gui.ShowRecordsDialog;
import de.inahware.dav.client.gui.ShowRolesDialog;
import de.inahware.dav.client.gui.ShowTasksDialog;
import de.inahware.dav.client.gui.ShowTextsDialog;
import de.inahware.dav.client.gui.ShowUsersDialog;
import de.inahware.dav.client.gui.ShowVendorsDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.BankStatement;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.PendingNotice;
import de.inahware.dav.models.Record;
import de.inahware.dav.models.RecordCategory;
import de.inahware.dav.models.Role;
import de.inahware.dav.models.Setting;
import de.inahware.dav.models.Task;
import de.inahware.dav.models.Text;
import de.inahware.dav.models.User;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.requests.GetSettings;
import de.inahware.edvj.gui.EFileChooser;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.MainMenuItem;
import de.inahware.edvj.query.filter.And;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.file.Path;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;

public class MainRoot
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private MainMenuItem rootItem;
    private JPanel panel_items;

    public MainRoot(ClientContext ctx) {
        this.ctx = ctx;
        this.setTitle("Start");
        this.initialize();
        this.rootItem = new MainMenuItem();
        MainMenuItem g_persons = this.rootItem.addGroup(this.BUNDLE.getString("MainRoot.items.persons"));
        MainMenuItem g_customers2 = g_persons.addGroup(this.BUNDLE.getString("Customers"), () -> ctx.getPermissions().contains(Customer.MODEL.getName() + ".select"));
        g_customers2.add(this.BUNDLE.getString("MainRoot.items.generic.show"), () -> new ShowCustomersDialog(false, ctx).openPage(this));
        g_customers2.addSeperator();
        g_customers2.add(this.BUNDLE.getString("MainRoot.items.generic.import"), () -> ctx.getPermissions().contains(Customer.MODEL.getName() + ".insert"), () -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("Customers") + " - " + this.BUNDLE.getString("MainRoot.items.generic.import"));
            dialog.addDefaultFilter("CSV file", "csv");
            Path path = dialog.open(this);
            if (path == null) {
                return;
            }
            CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setSkipHeaderRecord(true).build();
            new ImportCustomersDialog(ctx, path, format).openPage(this);
        });
        g_customers2.add(this.BUNDLE.getString("MainRoot.items.generic.export"), () -> new ExportCustomersDialog(ctx).openPage(this));
        MainMenuItem g_vendors = g_persons.addGroup(this.BUNDLE.getString("Vendors"), () -> ctx.getPermissions().contains(Vendor.MODEL.getName() + ".select"));
        g_vendors.add(this.BUNDLE.getString("MainRoot.items.generic.show"), () -> new ShowVendorsDialog(false, ctx).openPage(this));
        g_vendors.addSeperator();
        g_vendors.add(this.BUNDLE.getString("MainRoot.items.generic.import"), () -> ctx.getPermissions().contains(Vendor.MODEL.getName() + ".insert"), () -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("Vendors") + " - " + this.BUNDLE.getString("MainRoot.items.generic.import"));
            dialog.addDefaultFilter("CSV file", "csv");
            Path path = dialog.open(this);
            if (path == null) {
                return;
            }
            CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setSkipHeaderRecord(true).build();
            new ImportVendorsDialog(ctx, path, format).openPage(this);
        });
        g_vendors.add(this.BUNDLE.getString("MainRoot.items.generic.export"), () -> new ExportVendorsDialog(ctx).openPage(this));
        MainMenuItem g_articles = this.rootItem.addGroup(this.BUNDLE.getString("MainRoot.items.articles"));
        MainMenuItem g_articles2 = g_articles.addGroup(this.BUNDLE.getString("Articles"), () -> ctx.getPermissions().contains(Article.MODEL.getName() + ".select"));
        g_articles2.add(this.BUNDLE.getString("MainRoot.items.generic.show"), () -> new ShowArticlesDialog(false, ctx).openPage(this));
        g_articles2.addSeperator();
        g_articles2.add(this.BUNDLE.getString("MainRoot.items.generic.import"), () -> ctx.getPermissions().contains(Article.MODEL.getName() + ".insert"), () -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("Articles") + " - " + this.BUNDLE.getString("MainRoot.items.generic.import"));
            dialog.addDefaultFilter("CSV file", "csv");
            Path path = dialog.open(this);
            if (path == null) {
                return;
            }
            CSVFormat format = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setSkipHeaderRecord(true).build();
            new ImportArticlesDialog(this, ctx, path, format).openPage(this);
        });
        g_articles2.add(this.BUNDLE.getString("MainRoot.items.generic.export"), () -> new ExportArticlesDialog(this, ctx).openPage(this));
        g_articles.add(this.BUNDLE.getString("Discounts"), () -> ctx.getPermissions().contains(Article.MODEL.getName() + ".select"), () -> new ShowDiscountsDialog(this, ctx).openPage(this));
        MainMenuItem g_orders = this.rootItem.addGroup(this.BUNDLE.getString("MainRoot.items.orders"), () -> ctx.getPermissions().contains(Record.MODEL.getName() + ".select"));
        g_orders.add(this.BUNDLE.getString("Orders"), () -> ctx.getPermissions().contains(Order.MODEL.getName() + ".select"), () -> new ShowOrdersDialog(ctx).openPage(this));
        MainMenuItem g_documents2 = g_orders.addGroup(this.BUNDLE.getString("Documents"), () -> ctx.getPermissions().contains(Document.MODEL.getName() + ".select"));
        g_documents2.add(this.BUNDLE.getString("MainRoot.items.generic.show"), () -> new ShowDocumentsDialog(ctx).openPage(this));
        g_documents2.addSeperator();
        g_documents2.add(this.BUNDLE.getString("MainRoot.items.orders.documents.export_invoices_completed"), () -> new ExportDocumentsDialog(ctx, "completed invoices", new And(Document.COL_TYPE.with(DocumentType.INVOICE), Document.COL_STATE.with(OrderState.COMPLETED))).openInnerModal(this));
        g_documents2.add(this.BUNDLE.getString("MainRoot.items.orders.documents.export_invoices_ongoing"), () -> new ExportDocumentsDialog(ctx, "ongoing invoices", new And(Document.COL_TYPE.with(DocumentType.INVOICE), Document.COL_STATE.with(OrderState.ONGOING))).openInnerModal(this));
        MainMenuItem g_notices = g_orders.addGroup(this.BUNDLE.getString("Notices"));
        g_notices.add(this.BUNDLE.getString("Notices"), () -> ctx.getPermissions().contains(Notice.MODEL.getName() + ".select"), () -> new ShowNoticesDialog(ctx).openPage(this));
        g_notices.add(this.BUNDLE.getString("PendingNotices"), () -> ctx.getPermissions().contains(PendingNotice.MODEL.getName() + ".select"), () -> new ShowPendingNoticesDialog(ctx).openPage(this));
        g_orders.add(this.BUNDLE.getString("Tasks"), () -> ctx.getPermissions().contains(Task.MODEL.getName() + ".select"), () -> new ShowTasksDialog(ctx).openPage(this));
        MainMenuItem g_records = this.rootItem.addGroup(this.BUNDLE.getString("MainRoot.items.records"), () -> ctx.getPermissions().contains(Record.MODEL.getName() + ".select"));
        g_records.add(this.BUNDLE.getString("BankStatements"), () -> ctx.getPermissions().contains(BankStatement.MODEL.getName() + ".select"), () -> new ShowBankStatementsDialog(ctx).openPage(this));
        g_records.add(this.BUNDLE.getString("Records"), () -> ctx.getPermissions().contains(Record.MODEL.getName() + ".select"), () -> new ShowRecordsDialog(this, ctx).openPage(this));
        g_records.add(this.BUNDLE.getString("RecordCategories"), () -> ctx.getPermissions().contains(RecordCategory.MODEL.getName() + ".select"), () -> new ShowRecordCategoriesDialog(ctx).openInnerModal(this));
        g_records.add(this.BUNDLE.getString("Report"), () -> ctx.getPermissions().contains(Record.MODEL.getName() + ".select"), () -> new ExportReportDialog(this, ctx).openInnerModal(this));
        MainMenuItem g_admin = this.rootItem.addGroup(this.BUNDLE.getString("MainRoot.items.admin"));
        g_admin.add(this.BUNDLE.getString("Settings"), () -> ctx.getPermissions().contains(Setting.MODEL.getName() + ".update"), () -> {
            Properties settings = EUtils.blocking((Component)this, blocking -> ctx.query(new GetSettings()));
            new EditSettingsDialog(ctx, settings).openPage(this);
        });
        g_admin.add(this.BUNDLE.getString("Users"), () -> ctx.getPermissions().contains(User.MODEL.getName() + ".update"), () -> new ShowUsersDialog(this, ctx).openPage(this));
        g_admin.add(this.BUNDLE.getString("Roles"), () -> ctx.getPermissions().contains(Role.MODEL.getName() + ".update"), () -> new ShowRolesDialog(ctx).openPage(this));
        g_admin.add(this.BUNDLE.getString("Texts"), () -> ctx.getPermissions().contains(Text.MODEL.getName() + ".update"), () -> new ShowTextsDialog(ctx).openPage(this));
        this.refresh();
    }

    public void refresh() {
        MainMenuItem filtered;
        this.panel_items.removeAll();
        User login = this.ctx.getLogin();
        if (login != null && (filtered = this.rootItem.filtered()) != null) {
            filtered.renderIntoPanel(this.panel_items);
        }
        this.revalidate();
        this.repaint();
    }

    private void initialize() {
        this.setLayout(new MigLayout("", "[grow][][grow]", "[grow]"));
        this.panel_items = new JPanel();
        FlowLayout fl_panel_items = (FlowLayout)this.panel_items.getLayout();
        fl_panel_items.setAlignOnBaseline(true);
        fl_panel_items.setVgap(15);
        fl_panel_items.setHgap(15);
        this.add((Component)this.panel_items, "cell 1 0,grow");
    }
}

