/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.VersionException;
import de.inahware.dav.client.gui.LoginDialog;
import de.inahware.dav.client.gui.MainRoot;
import de.inahware.dav.models.User;
import de.inahware.dav.requests.GetSettings;
import de.inahware.edvj.VersionInfo;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ENavigatorPane;
import de.inahware.edvj.gui.EUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import net.miginfocom.swing.MigLayout;

public class MainWindow
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private String base_title;
    private List<MainRoot> roots;
    private JMenuBar menuBar;
    private JMenu mnuFile;
    private JMenuItem mnuFileExit;
    private JMenu mnuHelp;
    private JMenuItem mnuHelpHelp;
    private JMenuItem mnuHelpInfo;
    private JPanel panel_top;
    private JPanel panel_top_connecting;
    private JLabel lblConnecting;
    private JPanel panel_top_error;
    private JLabel lblError;
    private JPanel panel_top_error_version;
    private JLabel lblErrorVersion;
    private JPanel panel_top_connected;
    private JButton btnLogin;
    private JPanel panel_top_logged_in;
    private JLabel lblPath;
    private JLabel lblLogin;
    private JButton btnLogout;
    private JTabbedPane tabbedPane;

    public MainWindow(ClientContext ctx) {
        this.ctx = ctx;
        this.base_title = ctx.getVersion().getTitle();
        this.roots = new ArrayList<MainRoot>();
        this.setTitle(this.base_title);
        this.setWindowSize(1280, 720);
        this.setWindowMinSize(800, 600);
        this.setMaximized(true);
        this.initialize();
        this.menuBar = new JMenuBar();
        this.setMenuBar(this.menuBar);
        this.mnuFile = new JMenu(this.BUNDLE.getString("generic.menu.file"));
        this.menuBar.add(this.mnuFile);
        this.mnuFileExit = new JMenuItem(this.BUNDLE.getString("generic.menu.file.exit"));
        this.mnuFileExit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.mnuFile.add(this.mnuFileExit);
        this.mnuHelp = new JMenu(this.BUNDLE.getString("MainWindow.menu.help"));
        this.menuBar.add(this.mnuHelp);
        this.mnuHelpHelp = new JMenuItem(this.BUNDLE.getString("MainWindow.menu.help.help"));
        this.mnuHelpHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuHelp.add(this.mnuHelpHelp);
        this.mnuHelp.addSeparator();
        this.mnuHelpInfo = new JMenuItem(this.BUNDLE.getString("MainWindow.menu.help.info"));
        this.mnuHelp.add(this.mnuHelpInfo);
        this.addOpenListener(() -> this.tryConnect());
        this.addClosedListener(() -> this.exit());
        this.mnuFileExit.addActionListener(e -> this.exit());
        this.mnuHelpHelp.addActionListener(e -> {});
        this.mnuHelpInfo.addActionListener(e -> {
            VersionInfo version = ctx.getVersion();
            JOptionPane.showMessageDialog(this, version.getTitle() + " v" + version.getVersion(), "Info", 1);
        });
        this.btnLogin.addActionListener(e -> {
            new LoginDialog(ctx).inputDialog(this);
            this.refresh();
        });
        this.btnLogout.addActionListener(e -> {
            EUtils.blockingCatchWithDialog(this, blocking -> ctx.logout());
            this.resetTabs();
            this.refresh();
        });
        this.tabbedPane.addChangeListener((ChangeEvent ev) -> {
            if (this.tabbedPane.getTabCount() == 0) {
                return;
            }
            if (this.tabbedPane.getSelectedIndex() == this.tabbedPane.getTabCount() - 1) {
                this.newTab();
            }
            this.updatePath();
        });
        this.resetTabs();
        this.refresh();
    }

    private void tryConnect() {
        CardLayout card = (CardLayout)this.panel_top.getLayout();
        card.show(this.panel_top, "connecting");
        new Thread(() -> {
            try {
                this.ctx.getClient().connect();
                Properties settings = this.ctx.query(new GetSettings());
                SwingUtilities.invokeLater(() -> {
                    this.setTitle(this.base_title + " - " + settings.getProperty("company.name"));
                    this.refresh();
                });
            }
            catch (VersionException ex) {
                ex.printStackTrace();
                SwingUtilities.invokeLater(() -> card.show(this.panel_top, "error_version"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                SwingUtilities.invokeLater(() -> this.scheduleReconnect());
            }
        }).start();
    }

    private void scheduleReconnect() {
        CardLayout card = (CardLayout)this.panel_top.getLayout();
        card.show(this.panel_top, "error");
        Timer timer = new Timer(10000, e -> this.tryConnect());
        timer.setRepeats(false);
        timer.start();
    }

    private void exit() {
        EUtils.catchSilently(() -> this.ctx.logout());
        this.ctx.getClient().shutdown();
        System.exit(0);
    }

    public void refresh() {
        CardLayout card = (CardLayout)this.panel_top.getLayout();
        User login = this.ctx.getLogin();
        if (login == null) {
            card.show(this.panel_top, "connected");
        } else {
            card.show(this.panel_top, "logged_in");
            this.lblLogin.setText("<html>" + this.BUNDLE.getString("MainWindow.label.loggedInAs") + " <b>" + login.getName() + " (" + login.getUsername() + ")</b></html>");
            if (this.tabbedPane.getTabCount() - 1 == 0) {
                this.newTab();
            }
            this.btnLogout.setEnabled(!this.ctx.isSingleUser());
        }
        for (MainRoot root : this.roots) {
            root.refresh();
        }
    }

    private void resetTabs() {
        for (MainRoot r : this.roots) {
            r.close(false);
        }
        this.roots.clear();
        this.tabbedPane.removeAll();
        this.tabbedPane.add("+", new JPanel());
    }

    private void newTab() {
        ENavigatorPane navPane = new ENavigatorPane();
        MainRoot root = new MainRoot(this.ctx);
        root.openPage(navPane);
        this.roots.add(root);
        int idx = this.tabbedPane.getTabCount() - 1;
        this.tabbedPane.setSelectedIndex(-1);
        this.tabbedPane.insertTab(root.getTitle(), null, navPane, null, idx);
        this.tabbedPane.setSelectedIndex(idx);
        JPanel panel = new JPanel(new FlowLayout());
        JLabel lblTitle = new JLabel(root.getTitle());
        panel.add(lblTitle);
        JButton btnClose = new JButton("X");
        btnClose.addActionListener(ev -> {
            this.roots.remove(root);
            root.close(false);
            int selfIdx = this.tabbedPane.indexOfComponent(navPane);
            if (selfIdx == this.tabbedPane.getSelectedIndex() && selfIdx == this.tabbedPane.getTabCount() - 2) {
                this.tabbedPane.setSelectedIndex(selfIdx - 1);
            }
            this.tabbedPane.removeTabAt(selfIdx);
        });
        panel.add(btnClose);
        this.tabbedPane.setTabComponentAt(idx, panel);
        navPane.addChangeListener(() -> {
            int idx2 = this.tabbedPane.indexOfComponent(navPane);
            this.tabbedPane.setTitleAt(idx2, navPane.getTitle());
            lblTitle.setText(navPane.getTitle());
            this.updatePath();
        });
    }

    private void updatePath() {
        if (this.tabbedPane.getSelectedIndex() == this.tabbedPane.getTabCount() - 1) {
            this.lblPath.setText("");
            return;
        }
        ENavigatorPane selected = (ENavigatorPane)this.tabbedPane.getSelectedComponent();
        if (selected == null) {
            return;
        }
        this.lblPath.setText(selected.getPath().stream().map(p -> p.getTitle()).collect(Collectors.joining(" > ")));
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.panel_top = new JPanel();
        this.add((Component)this.panel_top, "North");
        this.panel_top.setBackground(new Color(211, 211, 211));
        this.panel_top.setLayout(new CardLayout(0, 0));
        this.panel_top_connecting = new JPanel();
        this.panel_top_connecting.setBackground(new Color(211, 211, 211));
        this.panel_top.add((Component)this.panel_top_connecting, "connecting");
        this.panel_top_connecting.setLayout(new BorderLayout(0, 0));
        this.lblConnecting = new JLabel(this.BUNDLE.getString("MainWindow.label.connecting"));
        this.lblConnecting.setHorizontalAlignment(0);
        this.panel_top_connecting.add(this.lblConnecting);
        this.panel_top_error = new JPanel();
        this.panel_top_error.setBackground(new Color(211, 211, 211));
        this.panel_top.add((Component)this.panel_top_error, "error");
        this.panel_top_error.setLayout(new BorderLayout(0, 0));
        this.lblError = new JLabel(this.BUNDLE.getString("MainWindow.label.error"));
        this.lblError.setHorizontalAlignment(0);
        this.panel_top_error.add(this.lblError);
        this.panel_top_error_version = new JPanel();
        this.panel_top_error_version.setBackground(new Color(211, 211, 211));
        this.panel_top.add((Component)this.panel_top_error_version, "error_version");
        this.panel_top_error_version.setLayout(new BorderLayout(0, 0));
        this.lblErrorVersion = new JLabel(this.BUNDLE.getString("MainWindow.label.error_version"));
        this.lblErrorVersion.setHorizontalAlignment(0);
        this.panel_top_error_version.add((Component)this.lblErrorVersion, "Center");
        this.panel_top_connected = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)this.panel_top_connected.getLayout();
        flowLayout_1.setAlignment(2);
        this.panel_top_connected.setBackground(new Color(211, 211, 211));
        this.panel_top.add((Component)this.panel_top_connected, "connected");
        this.btnLogin = new JButton(this.BUNDLE.getString("MainWindow.button.login"));
        this.panel_top_connected.add(this.btnLogin);
        this.panel_top_logged_in = new JPanel();
        this.panel_top_logged_in.setBackground(new Color(211, 211, 211));
        this.panel_top.add((Component)this.panel_top_logged_in, "logged_in");
        this.panel_top_logged_in.setLayout(new MigLayout("", "[][grow][][]", "[25px]"));
        this.lblPath = new JLabel("Path");
        this.lblPath.setFont(new Font("Dialog", 1, 12));
        this.panel_top_logged_in.add((Component)this.lblPath, "cell 0 0");
        this.lblLogin = new JLabel("Login");
        this.panel_top_logged_in.add((Component)this.lblLogin, "cell 2 0,aligny center");
        this.btnLogout = new JButton(this.BUNDLE.getString("MainWindow.button.logout"));
        this.panel_top_logged_in.add((Component)this.btnLogout, "cell 3 0,aligny center");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setFocusable(false);
        this.add(this.tabbedPane);
    }
}

