/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.gui.LoadingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Thread thread;

    public void load(PDDocument doc) {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (doc == null) {
            this.removeAll();
            this.setLayout(new BorderLayout());
        } else {
            this.removeAll();
            this.setLayout(new MigLayout("", "[grow][][grow]", "15" + "[]15".repeat(doc.getNumberOfPages())));
            ArrayList<PagePanel> pages = new ArrayList<PagePanel>();
            for (int i = 0; i < doc.getNumberOfPages(); ++i) {
                PagePanel pp = new PagePanel(doc, i, 100.0f);
                this.add((Component)pp, "cell 1 " + i);
                pages.add(pp);
            }
            this.revalidate();
            this.thread = new Thread(() -> {
                PDFRenderer renderer = new PDFRenderer(doc);
                for (PagePanel pp : pages) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    pp.render(renderer);
                }
            });
            this.thread.start();
        }
    }

    private static class PagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int pageIdx;
        private float dpi;
        private BufferedImage img;

        public PagePanel(PDDocument doc, int pageIdx, float dpi) {
            this.pageIdx = pageIdx;
            this.dpi = dpi;
            this.img = null;
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            this.setLayout(new BorderLayout());
            this.add((Component)new LoadingPanel(), "Center");
            PDPage page = doc.getPage(pageIdx);
            int width = (int)(dpi * page.getMediaBox().getWidth() / 72.0f);
            int height = (int)(dpi * page.getMediaBox().getHeight() / 72.0f);
            this.setPreferredSize(new Dimension(width, height));
        }

        public void render(PDFRenderer renderer) {
            try {
                this.img = renderer.renderImageWithDPI(this.pageIdx, this.dpi);
                SwingUtilities.invokeLater(() -> {
                    this.removeAll();
                    this.repaint();
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.img != null) {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

