/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.PDFView;
import de.inahware.edvj.gui.EFileChooser;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.print.PrinterJob;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class PrintDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private boolean printed = false;
    private JScrollPane scrollPane;
    private PDFView panel_document;
    private JPanel panel;
    private JButton btnSaveAsPDF;
    private JButton btnPrint;
    private JButton btnClose;

    public PrintDialog(String name, PDDocument doc) {
        this(name, doc, false);
    }

    public PrintDialog(String name, PDDocument doc, boolean askPrinted) {
        this.initialize();
        this.panel_document.load(doc);
        this.btnSaveAsPDF.addActionListener(e -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("PrintDialog.button.saveAsPDF"));
            dialog.resetChoosableFileFilters();
            dialog.addChoosableFileFilter(new FileNameExtensionFilter("PDF document", "pdf"));
            dialog.setSelectedFile(Path.of(name, new String[0]).toFile());
            int answer = dialog.showSaveDialog(this);
            if (answer != 0) {
                return;
            }
            EUtils.catchWithDialog(this, () -> {
                int answer2;
                EUtils.blocking((Component)this, blocking -> doc.save(dialog.getSelectedFile()));
                if (askPrinted && (answer2 = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("PrintDialog.messages.mark_as_printed"), this.getTitle(), 0)) == 0) {
                    this.printed = true;
                }
            });
        });
        this.btnPrint.addActionListener(e -> EUtils.catchWithDialog(this, () -> {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable(new PDFPageable(doc));
            if (!job.printDialog()) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> {
                job.print();
                if (askPrinted) {
                    this.printed = true;
                }
            });
        }));
        this.btnClose.addActionListener(e -> this.close());
    }

    public boolean isPrinted() {
        return this.printed;
    }

    private void initialize() {
        this.setTitle(this.BUNDLE.getString("PrintDialog.title"));
        this.setSize(1280, 720);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.add((Component)this.scrollPane, "Center");
        this.panel_document = new PDFView();
        this.scrollPane.setViewportView(this.panel_document);
        this.panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel.getLayout();
        flowLayout.setAlignment(2);
        this.add((Component)this.panel, "South");
        this.btnSaveAsPDF = new JButton(this.BUNDLE.getString("PrintDialog.button.saveAsPDF"));
        this.panel.add(this.btnSaveAsPDF);
        this.btnPrint = new JButton(this.BUNDLE.getString("generic.button.print"));
        this.panel.add(this.btnPrint);
        this.btnClose = new JButton(this.BUNDLE.getString("generic.button.close"));
        this.panel.add(this.btnClose);
    }
}

