/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditArticleVendorDialog;
import de.inahware.dav.client.gui.ShowArticlesDialog;
import de.inahware.dav.client.gui.ShowVendorsDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleVendor;
import de.inahware.dav.models.ArticleVendorView;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.filter.And;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowArticleVendorsDialog
extends DataTableDialog<ArticleVendorView> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowArticleVendorsDialog(ClientContext ctx, Article article) {
        this(ctx, article, null);
    }

    public ShowArticleVendorsDialog(ClientContext ctx, Vendor vendor) {
        this(ctx, null, vendor);
    }

    private ShowArticleVendorsDialog(ClientContext ctx, Article article, Vendor vendor) {
        super(ArticleVendorView.MODEL, ctx.getClient());
        if (article != null) {
            this.setTitle(this.BUNDLE.getString("Article") + " #" + article.getNumber() + " - " + this.BUNDLE.getString("Vendors"));
            this.addSearchColumnString(ArticleVendorView.COL_VENDOR_NUMBER);
            this.addSearchColumnString(ArticleVendorView.COL_VENDOR_COMPANY);
            for (Salutation s2 : Salutation.values()) {
                this.addSearchKeyword(s2.getLocalizedString(this.BUNDLE), ArticleVendorView.COL_VENDOR_SALUTATION.with(s2));
            }
            this.addSearchColumnString(ArticleVendorView.COL_VENDOR_PREFIX);
            this.addSearchColumnString(ArticleVendorView.COL_VENDOR_FIRST_NAME);
            this.addSearchColumnString(ArticleVendorView.COL_VENDOR_LAST_NAME);
            this.addColumn(ArticleVendorView.COL_VENDOR_NUMBER);
            this.addColumn(ArticleVendorView.COL_VENDOR_COMPANY);
            this.addColumn(ArticleVendorView.COL_VENDOR_SALUTATION, (U s) -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
            this.addColumn(ArticleVendorView.COL_VENDOR_PREFIX);
            this.addColumn(ArticleVendorView.COL_VENDOR_FIRST_NAME);
            this.addColumn(ArticleVendorView.COL_VENDOR_LAST_NAME);
            this.setFilter(ArticleVendorView.COL_ARTICLE_ID.with(article.getId()));
        } else {
            this.setTitle(this.BUNDLE.getString("Vendor") + " #" + vendor.getId() + " - " + this.BUNDLE.getString("Articles"));
            this.addSearchColumnString(ArticleVendorView.COL_ARTICLE_NUMBER);
            this.addSearchColumnString(ArticleVendorView.COL_ARTICLE_TITLE);
            this.addColumn(ArticleVendorView.COL_ARTICLE_NUMBER);
            this.addColumn(ArticleVendorView.COL_ARTICLE_TITLE);
            this.setFilter(ArticleVendorView.COL_VENDOR_ID.with(vendor.getId()));
        }
        this.addColumn(ArticleVendorView.COL_VENDORS_ARTICLE_NUMBER);
        this.addColumn(ArticleVendorView.COL_PRICES.getLocalizedString(ArticleVendorView.MODEL, this.BUNDLE), BigDecimal.class, (T e) -> e.getPriceList().get((int)0).price);
        this.addDoubleClickAction(obj -> {
            ArticleVendor av = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<ArticleVendor>(ArticleVendor.MODEL, new And(ArticleVendor.COL_ARTICLE_ID.with(obj.getArticleId()), ArticleVendor.COL_VENDOR_ID.with(obj.getVendorId())))));
            new EditArticleVendorDialog(ctx, av).openInnerModal(this, () -> this.refresh());
        });
        if (ctx.getPermissions().contains(ArticleVendor.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.add"), obj -> {
                if (article == null) {
                    new ShowArticlesDialog(true, ctx).inputPage(this, (Article article2) -> {
                        if (article2 == null) {
                            return;
                        }
                        ArticleVendor av = new ArticleVendor(article2.getId(), vendor.getId());
                        new EditArticleVendorDialog(ctx, null, av).openInnerModal(this, () -> this.refresh());
                    });
                } else if (vendor == null) {
                    new ShowVendorsDialog(true, ctx).inputPage(this, vendor2 -> {
                        if (vendor2 == null) {
                            return;
                        }
                        ArticleVendor av = new ArticleVendor(article.getId(), vendor2.getId());
                        new EditArticleVendorDialog(ctx, null, av).openInnerModal(this, () -> this.refresh());
                    });
                }
            });
        }
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> {
            ArticleVendor av = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<ArticleVendor>(ArticleVendor.MODEL, new And(ArticleVendor.COL_ARTICLE_ID.with(obj.getArticleId()), ArticleVendor.COL_VENDOR_ID.with(obj.getVendorId())))));
            new EditArticleVendorDialog(ctx, av).openPage(this, () -> this.refresh());
        });
        if (ctx.getPermissions().contains(ArticleVendor.MODEL.getName() + ".delete")) {
            this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowArticleVendorsDialog.messages.delete_confirm.text1") + "\n\n    " + this.BUNDLE.getString("Article") + " #" + obj.getArticleNumber() + " - " + this.BUNDLE.getString("Vendor") + " #" + obj.getVendorId() + "\n\n" + this.BUNDLE.getString("ShowArticleVendorsDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blockingCatchWithDialog(this, blocking -> ctx.query(new Delete<ArticleVendor>(ArticleVendor.MODEL, new And(obj.getPrimaryFields()))));
                this.refresh();
            });
        }
        this.addCloseButton();
    }
}

