/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.ChooseArticleGroupDialog;
import de.inahware.dav.client.gui.EditArticleDialog;
import de.inahware.dav.models.Article;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.edvj.gui.DataTablePanel;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETextField;
import de.inahware.edvj.gui.ETree;
import de.inahware.edvj.gui.ETreeCellRenderer;
import de.inahware.edvj.gui.ETreeModel;
import de.inahware.edvj.gui.ETreeNode;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Insert;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.query.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.function.FailableConsumer;

public class ShowArticlesDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext ctx;
    private Article returned;
    private ETreeNode<ArticleGroup> selected;
    private HashMap<Long, ETreeNode<ArticleGroup>> groups;
    private JSplitPane splitPane;
    private ETree<ArticleGroup> tree;
    private JPanel panel;
    private JPanel panel_1;
    private JPanel panel_2;
    private JLabel lblArticleGroup;
    private ETextField txtArticleGroup;
    private JSeparator separator;
    private DataTablePanel<Article> tablePanel;

    public ShowArticlesDialog(ClientContext ctx) throws Exception {
        this(false, ctx);
    }

    public ShowArticlesDialog(boolean do_select, ClientContext ctx) throws Exception {
        this.ctx = ctx;
        this.selected = null;
        this.returned = null;
        this.setTitle(this.BUNDLE.getString("Articles"));
        this.setWindowSize(800, 450);
        this.initialize();
        this.refreshGroups();
        ETreeCellRenderer<ArticleGroup> renderer = this.tree.setFormatter(node -> {
            String title;
            String string = title = node.getValue() != null ? ((ArticleGroup)node.getValue()).getTitle() : this.BUNDLE.getString("ArticleGroup.root");
            if (node == this.selected) {
                return "<html><b>" + title + "</b></html>";
            }
            return title;
        });
        renderer.setLeafIcon(renderer.getClosedIcon());
        this.tree.addDoubleClickAction(node -> this.select((ETreeNode<ArticleGroup>)node));
        if (ctx.getPermissions().contains(ArticleGroup.MODEL.getName() + ".insert")) {
            this.tree.addPopupMenuItem(this.BUNDLE.getString("ShowArticlesDialog.menu.addArticleGroup"), node -> node != null, node -> {
                ArticleGroup group = (ArticleGroup)node.getValue();
                String input = JOptionPane.showInputDialog(this.BUNDLE.getString("ShowArticlesDialog.messages.input_name"));
                if (input == null) {
                    return;
                }
                ArticleGroup g = new ArticleGroup();
                g.setParentId(group == null ? null : group.getId());
                g.setTitle(input);
                ArticleGroup g2 = EUtils.blocking((Component)this, blocking -> ctx.query(new Insert<ArticleGroup>(ArticleGroup.MODEL, g)));
                this.refreshGroups();
                this.tree.expandPath(new TreePath(this.groups.get(g2.getId()).getPath()).getParentPath());
            });
        }
        if (ctx.getPermissions().contains(ArticleGroup.MODEL.getName() + ".update")) {
            this.tree.addPopupMenuItem(this.BUNDLE.getString("ShowArticlesDialog.menu.renameArticleGroup"), node -> node != null && node.getValue() != null, node -> {
                ArticleGroup group = (ArticleGroup)node.getValue();
                String input = JOptionPane.showInputDialog(this, this.BUNDLE.getString("ShowArticlesDialog.messages.input_new_name"), group.getTitle());
                if (input == null) {
                    return;
                }
                EUtils.blocking((Component)this, blocking -> ctx.query(new Update<ArticleGroup>(ArticleGroup.MODEL, List.of(ArticleGroup.COL_TITLE.with(input)), group.getPrimaryFilter())));
                this.refreshGroups();
            });
        }
        if (ctx.getPermissions().contains(ArticleGroup.MODEL.getName() + ".delete")) {
            this.tree.addPopupMenuItem(this.BUNDLE.getString("ShowArticlesDialog.menu.deleteArticleGroup"), node -> node != null && node.getValue() != null, node -> {
                if (node.getChildCount() > 0) {
                    throw new RuntimeException(this.BUNDLE.getString("ShowArticlesDialog.messages.group_not_empty"));
                }
                if (ctx.query(new Select<Article>(Article.MODEL, Article.COL_ARTICLE_GROUP_ID.with(((ArticleGroup)node.getValue()).getId()))) != null) {
                    throw new RuntimeException(this.BUNDLE.getString("ShowArticlesDialog.messages.group_not_empty"));
                }
                ctx.query(new Delete<ArticleGroup>(ArticleGroup.MODEL, ((ArticleGroup)node.getValue()).getPrimaryFilter()));
                this.refreshGroups();
            });
        }
        this.tablePanel.addSearchColumnString(Article.COL_NUMBER);
        this.tablePanel.addSearchColumnString(Article.COL_TITLE);
        this.tablePanel.addSearchColumnString(Article.COL_UNIT);
        this.tablePanel.addSearchColumnString(Article.COL_DESCRIPTION);
        this.tablePanel.addColumn(Article.COL_NUMBER);
        this.tablePanel.addColumn(Article.COL_TITLE);
        this.tablePanel.addColumn(Article.COL_PRICES.getLocalizedString(Article.MODEL, this.BUNDLE), BigDecimal.class, e -> e.getPriceList().get((int)0).price);
        this.tablePanel.addColumn(Article.COL_UNIT);
        this.tablePanel.addColumn(Article.COL_DESCRIPTION);
        this.tablePanel.getTable().setAutoCreateRowSorter(true);
        if (do_select) {
            this.tablePanel.addDoubleClickAction(obj -> {
                if (obj != null) {
                    this.returned = obj;
                    this.close();
                }
            });
            this.tablePanel.addButton(this.BUNDLE.getString("generic.button.select"), obj -> obj != null, obj -> {
                this.returned = obj;
                this.close();
            });
            this.tablePanel.addButton(this.BUNDLE.getString("generic.button.cancel"), obj -> this.close());
        } else {
            this.tablePanel.addDoubleClickAction(obj -> new EditArticleDialog(ctx, (Article)obj).openInnerModal(this, () -> this.tablePanel.refresh()));
            if (ctx.getPermissions().contains(Article.MODEL.getName() + ".insert")) {
                this.tablePanel.addButton(this.BUNDLE.getString("generic.button.new"), _obj -> this.selected != null, _obj -> {
                    if (this.selected.getValue() == null) {
                        throw new RuntimeException(this.BUNDLE.getString("ShowArticlesDialog.messages.no_group_selected"));
                    }
                    Article obj = new Article();
                    obj.setArticleGroupId(this.selected.getValue().getId());
                    new EditArticleDialog(ctx, null, obj).openInnerModal(this, () -> this.tablePanel.refresh());
                });
            }
            this.tablePanel.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditArticleDialog(ctx, (Article)obj).openInnerModal(this, () -> this.tablePanel.refresh()));
            if (ctx.getPermissions().contains(Article.MODEL.getName() + ".update")) {
                this.tablePanel.addButton(this.BUNDLE.getString("generic.button.move"), obj -> obj != null, obj -> new ChooseArticleGroupDialog(ctx).inputInnerModal(this, (T group) -> {
                    if (group == null) {
                        return;
                    }
                    if (group.getParentId() == null) {
                        throw new RuntimeException("cannot move into root");
                    }
                    ctx.query(new Update<Article>(Article.MODEL, List.of(Article.COL_ARTICLE_GROUP_ID.with(group.getId())), obj.getPrimaryFilter()));
                    this.tablePanel.refresh();
                }));
            }
            if (ctx.getPermissions().contains(Article.MODEL.getName() + ".delete")) {
                this.tablePanel.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                    int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowArticlesDialog.messages.delete_confirm.text1") + "\n\n    " + obj.getDisplayName() + "\n\n" + this.BUNDLE.getString("ShowArticlesDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                    if (answer != 0) {
                        return;
                    }
                    EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Article>(Article.MODEL, obj.getPrimaryFilter())));
                    this.tablePanel.refresh();
                });
            }
            this.tablePanel.addButton(this.BUNDLE.getString("generic.button.close"), obj -> this.close());
        }
    }

    public Article getReturnedObject() {
        return this.returned;
    }

    public void inputPage(EFrame parent, FailableConsumer<Article, Exception> action) {
        this.openPage(parent, () -> action.accept(this.returned));
    }

    public void inputInnerModal(EFrame parent, FailableConsumer<Article, Exception> action) {
        this.openInnerModal(parent, () -> action.accept(this.returned));
    }

    private void refreshGroups() throws Exception {
        List res = EUtils.blocking((Component)this, blocking -> (List)((Object)this.ctx.query(new SelectAll<ArticleGroup>(ArticleGroup.MODEL))));
        Set<Long> expanded = this.getExpanded();
        Long selected_before = this.selected != null && this.selected.getValue() != null ? this.selected.getValue().getId() : null;
        ETreeNode<Object> root = new ETreeNode<Object>(false, null);
        this.groups = new HashMap();
        this.groups.put(null, root);
        for (ArticleGroup articleGroup : res) {
            this.groups.put(articleGroup.getId(), new ETreeNode<ArticleGroup>(false, articleGroup));
        }
        for (ETreeNode eTreeNode : this.groups.values()) {
            ArticleGroup g = (ArticleGroup)eTreeNode.getValue();
            if (g == null) continue;
            this.groups.get(g.getParentId()).addChild(eTreeNode);
        }
        for (ETreeNode eTreeNode : this.groups.values()) {
            if (eTreeNode.getChildCount() != 0) continue;
            eTreeNode.setLeaf(true);
        }
        this.tree.setModel(new ETreeModel<Object>(root));
        if (expanded == null) {
            for (ETreeNode eTreeNode : this.groups.values()) {
                this.tree.expandPath(new TreePath(eTreeNode.getPath()));
            }
        } else {
            for (Long l : expanded) {
                this.tree.expandPath(new TreePath(this.groups.get(l).getPath()));
            }
        }
        if (selected_before != null && this.groups.containsKey(selected_before)) {
            this.select(this.groups.get(selected_before));
        } else {
            this.select(root);
        }
    }

    private Set<Long> getExpanded() {
        if (this.tree.getModel() == null) {
            return null;
        }
        HashSet<Long> res = new HashSet<Long>();
        this.getExpanded(new TreePath(this.tree.getRoot().getPath()), res);
        return res;
    }

    private void getExpanded(TreePath parent, HashSet<Long> expanded) {
        Enumeration<TreePath> childs = this.tree.getExpandedDescendants(parent);
        if (childs == null) {
            return;
        }
        while (childs.hasMoreElements()) {
            TreePath path = childs.nextElement();
            ETreeNode node = (ETreeNode)path.getLastPathComponent();
            expanded.add(node.getValue() == null ? null : ((ArticleGroup)node.getValue()).getId());
            this.getExpanded(path, expanded);
        }
    }

    private void select(ETreeNode<ArticleGroup> node) throws Exception {
        ETreeNode<ArticleGroup> node_old = this.selected;
        this.selected = node;
        if (node_old != null) {
            node_old.refresh();
        }
        this.selected.refresh();
        if (this.selected.getValue() == null) {
            this.txtArticleGroup.setText(this.BUNDLE.getString("ArticleGroup.root") + " / *");
            this.tablePanel.setFilter(null);
        } else {
            this.txtArticleGroup.setText(this.getFullTitle(node.getValue()));
            this.tablePanel.setFilter(Article.COL_ARTICLE_GROUP_ID.with(node.getValue().getId()));
        }
        this.tablePanel.refresh();
    }

    private String getFullTitle(ArticleGroup group) {
        Object title = group.getTitle();
        while (group.getParentId() != null) {
            group = this.groups.get(group.getParentId()).getValue();
            title = group.getTitle() + " / " + (String)title;
        }
        return title;
    }

    private void initialize() {
        this.splitPane = new JSplitPane();
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setDividerLocation(150);
        this.add((Component)this.splitPane, "Center");
        this.tree = new ETree();
        this.tree.setToggleClickCount(0);
        this.tree.setModel(null);
        this.splitPane.setLeftComponent(this.tree);
        this.panel = new JPanel();
        this.splitPane.setRightComponent(this.panel);
        this.panel.setLayout(new BorderLayout(0, 0));
        this.panel_1 = new JPanel();
        this.panel.add((Component)this.panel_1, "North");
        this.panel_1.setLayout(new BorderLayout(0, 0));
        this.panel_2 = new JPanel();
        this.panel_1.add((Component)this.panel_2, "North");
        this.panel_2.setLayout(new MigLayout("", "[][grow]", "[]"));
        this.lblArticleGroup = new JLabel(this.BUNDLE.getString("ArticleGroup") + ":");
        this.panel_2.add((Component)this.lblArticleGroup, "cell 0 0,alignx trailing");
        this.txtArticleGroup = new ETextField();
        this.txtArticleGroup.setEditable(false);
        this.panel_2.add((Component)this.txtArticleGroup, "cell 1 0,growx");
        this.txtArticleGroup.setColumns(10);
        this.separator = new JSeparator();
        this.panel_1.add((Component)this.separator, "South");
        this.tablePanel = new DataTablePanel<Article>(Article.MODEL, this.ctx.getClient());
        this.panel.add(this.tablePanel);
    }
}

