/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditAttachmentDialogs;
import de.inahware.dav.models.Attachment;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.AttachmentType;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.DefaultDataEditDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.filter.And;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowAttachmentsDialog
extends DataTableDialog<Attachment> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowAttachmentsDialog(ClientContext ctx, String title_prefix, AttachmentObjectType objectType, Long objectId) {
        this(ctx, title_prefix, objectType, objectId, false);
    }

    public ShowAttachmentsDialog(ClientContext ctx, String title_prefix, AttachmentObjectType objectType, Long objectId, boolean select) {
        super(Attachment.MODEL, ctx);
        this.setTitle(title_prefix + " - " + this.BUNDLE.getString("Attachments"));
        this.addSearchColumnLong(Attachment.COL_ID);
        for (AttachmentType type : AttachmentType.values()) {
            this.addSearchKeyword(type.getLocalizedString(this.BUNDLE), Attachment.COL_TYPE.with(type));
        }
        this.addSearchColumnString(Attachment.COL_TITLE);
        this.addSearchColumnString(Attachment.COL_TEXT);
        this.addColumn(Attachment.COL_ID);
        this.addColumn(Attachment.COL_TYPE.getLocalizedString(Attachment.MODEL, this.BUNDLE), (T obj) -> obj.getType().getLocalizedString(this.BUNDLE));
        this.addColumn(Attachment.COL_TITLE);
        this.addColumn(Attachment.COL_TEXT);
        this.getTable().setAutoCreateRowSorter(true);
        this.setFilter(new And(Attachment.COL_OBJECT_TYPE.with(objectType), Attachment.COL_OBJECT_ID.with(objectId), Attachment.COL_HIDDEN.with(false)));
        if (select) {
            this.addSelectDoubleClickAction();
            this.addSelectCancelButtons();
        } else {
            this.addDoubleClickAction(obj -> EditAttachmentDialogs.create(this, ctx, obj.getId()).openPage(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Attachment.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.new"), _obj -> {
                    DefaultDataEditDialog<Attachment> dialog = EditAttachmentDialogs.create(this, ctx, objectType, objectId);
                    if (dialog == null) {
                        return;
                    }
                    dialog.openPage(this, () -> this.refresh());
                });
            }
            this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> EditAttachmentDialogs.create(this, ctx, obj.getId()).openPage(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Attachment.MODEL.getName() + ".delete")) {
                this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null && obj.getRefCount() == 0L, obj -> {
                    int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowAttachmentsDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + ": " + obj.getTitle() + "\n\n" + this.BUNDLE.getString("ShowAttachmentsDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                    if (answer != 0) {
                        return;
                    }
                    EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Attachment>(Attachment.MODEL, obj.getPrimaryFilter())));
                    this.refresh();
                });
            }
            this.addCloseButton();
        }
    }
}

