/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditBankStatementDialog;
import de.inahware.dav.models.BankStatement;
import de.inahware.dav.models.BankStatementFull;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowBankStatementsDialog
extends DataTableDialog<BankStatement> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowBankStatementsDialog(ClientContext ctx) {
        super(BankStatement.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("BankStatements"));
        this.addSearchColumnLong(BankStatement.COL_ID);
        this.addSearchColumnDate(BankStatement.COL_DATE);
        this.addColumn(BankStatement.COL_ID);
        this.addColumn(BankStatement.COL_DATE);
        this.addColumn(BankStatement.COL_BALANCE_BEFORE);
        this.addColumn(BankStatement.COL_BALANCE_AFTER);
        this.getTable().setAutoCreateRowSorter(true);
        this.addDoubleClickAction(obj -> {
            BankStatementFull obj2 = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<BankStatementFull>(BankStatementFull.MODEL, BankStatementFull.COL_ID.with(obj.getId()))));
            new EditBankStatementDialog(ctx, obj2).openPage(this, () -> this.refresh());
        });
        if (ctx.getPermissions().contains(BankStatement.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditBankStatementDialog(ctx, null, new BankStatementFull()).openPage(this, () -> this.refresh()));
        }
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> {
            BankStatementFull obj2 = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<BankStatementFull>(BankStatementFull.MODEL, BankStatementFull.COL_ID.with(obj.getId()))));
            new EditBankStatementDialog(ctx, obj2).openPage(this, () -> this.refresh());
        });
        if (ctx.getPermissions().contains(BankStatement.MODEL.getName() + ".delete")) {
            this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowBankStatementsDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + " [" + I18N.formatDate(obj.getDate()) + "]\n\n" + this.BUNDLE.getString("ShowBankStatementsDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<BankStatement>(BankStatement.MODEL, obj.getPrimaryFilter())));
                this.refresh();
            });
        }
        this.addCloseButton();
    }
}

