/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditCustomerDialog;
import de.inahware.dav.models.Customer;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowCustomersDialog
extends DataTableDialog<Customer> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowCustomersDialog(boolean select, ClientContext ctx) {
        super(Customer.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Customers"));
        this.addSearchColumnString(Customer.COL_NUMBER);
        this.addSearchColumnString(Customer.COL_COMPANY);
        for (Salutation s2 : Salutation.values()) {
            this.addSearchKeyword(s2.getLocalizedString(this.BUNDLE), Customer.COL_SALUTATION.with(s2));
        }
        this.addSearchColumnString(Customer.COL_PREFIX);
        this.addSearchColumnString(Customer.COL_FIRST_NAME);
        this.addSearchColumnString(Customer.COL_LAST_NAME);
        this.addColumn(Customer.COL_NUMBER);
        this.addColumn(Customer.COL_COMPANY);
        this.addColumn(Customer.COL_SALUTATION, (U s) -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.addColumn(Customer.COL_PREFIX);
        this.addColumn(Customer.COL_FIRST_NAME);
        this.addColumn(Customer.COL_LAST_NAME);
        this.getTable().setAutoCreateRowSorter(true);
        if (select) {
            this.addSelectDoubleClickAction();
            this.addSelectCancelButtons();
        } else {
            this.addDoubleClickAction(obj -> new EditCustomerDialog(ctx, (Customer)obj).openPage(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Customer.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditCustomerDialog(ctx, null, new Customer()).openPage(this, () -> this.refresh()));
            }
            this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditCustomerDialog(ctx, (Customer)obj).openPage(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Customer.MODEL.getName() + ".delete")) {
                this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                    int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowCustomersDialog.messages.delete_confirm.text1") + "\n\n    " + obj.getNumber() + ": " + obj.getDisplayName(this.BUNDLE) + "\n\n" + this.BUNDLE.getString("ShowCustomersDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                    if (answer != 0) {
                        return;
                    }
                    EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Customer>(Customer.MODEL, obj.getPrimaryFilter())));
                    this.refresh();
                });
            }
            this.addCloseButton();
        }
    }
}

