/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditDiscountDialog;
import de.inahware.dav.models.ArticleGroup;
import de.inahware.dav.models.Discount;
import de.inahware.dav.models.DiscountView;
import de.inahware.dav.models.Person;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowDiscountsDialog
extends DataTableDialog<DiscountView> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowDiscountsDialog(Component parent, ClientContext ctx) throws Exception {
        super(DiscountView.MODEL, ctx);
        this.setWindowSize(800, 450);
        Map articleGroups = EUtils.blocking(parent, blocking -> ArticleGroup.getArticleGroupMap(ctx));
        this.setTitle(this.BUNDLE.getString("Discounts"));
        this.addSearchColumnLong(DiscountView.COL_ID);
        this.addSearchColumnDate(DiscountView.COL_BEGIN);
        this.addSearchColumnDate(DiscountView.COL_END);
        this.addSearchColumnString(DiscountView.COL_CUSTOMER_NUMBER);
        for (Salutation s : Salutation.values()) {
            this.addSearchKeyword(s.getLocalizedString(this.BUNDLE), DiscountView.COL_CUSTOMER_SALUTATION.with(s));
        }
        this.addSearchColumnString(DiscountView.COL_CUSTOMER_PREFIX);
        this.addSearchColumnString(DiscountView.COL_CUSTOMER_LAST_NAME);
        this.addSearchColumnString(DiscountView.COL_CUSTOMER_FIRST_NAME);
        this.addSearchColumnString(DiscountView.COL_CUSTOMER_COMPANY);
        this.addSearchColumnLong(DiscountView.COL_ARTICLE_GROUP_ID);
        this.addSearchColumnString(DiscountView.COL_ARTICLE_NUMBER);
        this.addSearchColumnString(DiscountView.COL_ARTICLE_TITLE);
        this.addSearchColumnString(DiscountView.COL_DESCRIPTION);
        this.addColumn(DiscountView.COL_ID);
        this.addColumn(DiscountView.COL_BEGIN);
        this.addColumn(DiscountView.COL_END);
        this.addColumn(this.BUNDLE.getString("Customer"), (T obj) -> obj.getCustomerId() == null ? "-" : obj.getCustomerNumber() + " - " + Person.getDisplayName(this.BUNDLE, obj.getCustomerSalutation(), obj.getCustomerPrefix(), obj.getCustomerFirstName(), obj.getCustomerLastName(), obj.getCustomerCompany()));
        this.addColumn(this.BUNDLE.getString("ArticleGroup"), (T obj) -> obj.getArticleGroupId() == null ? "-" : ArticleGroup.getArticleGroupPath(this.BUNDLE, (Map<Long, ArticleGroup>)articleGroups, obj.getArticleGroupId()));
        this.addColumn(this.BUNDLE.getString("Article"), (T obj) -> obj.getArticleId() == null ? "-" : "#" + obj.getArticleNumber() + ": " + obj.getArticleTitle());
        this.addColumn(DiscountView.COL_DISCOUNT);
        this.addColumn(DiscountView.COL_DESCRIPTION);
        this.getTable().setAutoCreateRowSorter(true);
        this.addDoubleClickAction(obj -> {
            Discount discount = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<Discount>(Discount.MODEL, Discount.COL_ID.with(obj.getId()))));
            new EditDiscountDialog(ctx, discount).openInnerModal(this, () -> this.refresh());
        });
        if (ctx.getPermissions().contains(Discount.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditDiscountDialog(ctx, null, new Discount()).openInnerModal(this, () -> this.refresh()));
        }
        this.addButton(this.BUNDLE.getString("generic.button.edit"), obj -> obj != null, obj -> {
            Discount discount = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<Discount>(Discount.MODEL, Discount.COL_ID.with(obj.getId()))));
            new EditDiscountDialog(ctx, discount).openInnerModal(this, () -> this.refresh());
        });
        if (ctx.getPermissions().contains(Discount.MODEL.getName() + ".delete")) {
            this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowDiscountsDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + ": " + I18N.formatDecimal(obj.getDiscount()) + "%" + (String)(obj.getCustomerId() != null ? "; " + this.BUNDLE.getString("Customer") + " " + obj.getCustomerNumber() : "") + (String)(obj.getArticleGroupId() != null ? "; " + this.BUNDLE.getString("ArticleGroup") + " " + ArticleGroup.getArticleGroupPath(this.BUNDLE, (Map<Long, ArticleGroup>)articleGroups, obj.getArticleGroupId()) : "") + (String)(obj.getArticleId() != null ? "; " + this.BUNDLE.getString("Article") + " #" + obj.getArticleNumber() : "") + "\n\n" + this.BUNDLE.getString("ShowDiscountsDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Discount>(Discount.MODEL, obj.getPrimaryFilter())));
                this.refresh();
            });
        }
        this.addCloseButton();
    }
}

