/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditDocumentDialog;
import de.inahware.dav.client.gui.EditOrderDialog;
import de.inahware.dav.models.DocumentFull;
import de.inahware.dav.models.DocumentView;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.models.types.Taxation;
import de.inahware.dav.requests.GetSettings;
import de.inahware.edvj.NamedException;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Select;
import de.inahware.edvj.query.filter.Filter;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class ShowDocumentsDialog
extends DataTableDialog<DocumentView> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowDocumentsDialog(ClientContext ctx) {
        this(ctx, false);
    }

    public ShowDocumentsDialog(ClientContext ctx, boolean select) {
        this(ctx, select, null);
    }

    public ShowDocumentsDialog(ClientContext ctx, boolean select, Filter filter) {
        super(DocumentView.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Documents"));
        this.setWindowSize(1024, 576);
        this.addSearchColumnString(DocumentView.COL_NUMBER);
        for (DocumentType documentType : DocumentType.values()) {
            this.addSearchKeyword(documentType.getLocalizedString(this.BUNDLE), DocumentView.COL_TYPE.with(documentType));
        }
        this.addSearchColumnDate(DocumentView.COL_DATE);
        for (Enum enum_ : OrderState.values()) {
            this.addSearchKeyword(((OrderState)enum_).getLocalizedString(this.BUNDLE), DocumentView.COL_STATE.with((OrderState)enum_));
        }
        this.addSearchColumnString(DocumentView.COL_CUSTOMER_NUMBER);
        this.addSearchColumnString(DocumentView.COL_VENDOR_NUMBER);
        for (Enum enum_ : Salutation.values()) {
            this.addSearchKeyword(((Salutation)enum_).getLocalizedString(this.BUNDLE), DocumentView.COL_SALUTATION.with((Salutation)enum_));
        }
        this.addSearchColumnString(DocumentView.COL_COMPANY);
        this.addSearchColumnString(DocumentView.COL_PREFIX);
        this.addSearchColumnString(DocumentView.COL_FIRST_NAME);
        this.addSearchColumnString(DocumentView.COL_LAST_NAME);
        this.addColumn(DocumentView.COL_STATE, (U state) -> state.getLocalizedString(this.BUNDLE));
        this.addColumn(DocumentView.COL_NUMBER);
        this.addColumn(DocumentView.COL_TYPE, (U type) -> type.getLocalizedString(this.BUNDLE));
        this.addColumn(DocumentView.COL_DATE);
        this.addColumn(this.BUNDLE.getString("Customer") + " / " + this.BUNDLE.getString("Vendor"), (T obj) -> {
            if (obj.getCustomerId() != null) {
                return obj.getCustomerNumber();
            }
            if (obj.getVendorNumber() != null) {
                return obj.getVendorNumber();
            }
            return "-";
        });
        this.addColumn(DocumentView.COL_COMPANY);
        this.addColumn(DocumentView.COL_SALUTATION, (U s) -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.addColumn(DocumentView.COL_PREFIX);
        this.addColumn(DocumentView.COL_FIRST_NAME);
        this.addColumn(DocumentView.COL_LAST_NAME);
        this.setFilter(filter);
        this.getTable().setAutoCreateRowSorter(true);
        if (select) {
            this.addSelectDoubleClickAction();
            this.addSelectCancelButtons();
        } else {
            this.addDoubleClickAction(obj -> {
                DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId()))));
                new EditDocumentDialog(ctx, doc).openPage(this, () -> this.refresh());
            });
            if (ctx.getPermissions().contains(DocumentFull.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.new"), _obj -> {
                    JComboBox<Object> cmb = new JComboBox<Object>();
                    for (DocumentType type2 : DocumentType.values()) {
                        if (!type2.usesCustomer()) continue;
                        cmb.addItem((Object)type2);
                    }
                    cmb.setSelectedIndex(0);
                    cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)type))))).getLocalizedString(this.BUNDLE)));
                    int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                    if (answer != 0) {
                        return;
                    }
                    DocumentType type3 = (DocumentType)((Object)((Object)((Object)cmb.getSelectedItem())));
                    DocumentFull doc = new DocumentFull(List.of(), type3, ctx.getLogin().getId());
                    Properties settings = ctx.query(new GetSettings());
                    boolean kleinunternehmer = Boolean.parseBoolean(settings.getProperty("company.kleinunternehmer"));
                    if (kleinunternehmer) {
                        doc.setTaxation(Taxation.KLEINUNTERNEHMER);
                    }
                    new EditDocumentDialog(ctx, null, doc).openPage(this, () -> this.refresh());
                });
            }
            this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> {
                DocumentFull doc = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId()))));
                new EditDocumentDialog(ctx, doc).openPage(this, () -> this.refresh());
            });
            this.addButton(this.BUNDLE.getString("ShowDocumentsDialog.button.show_order"), obj -> obj != null, obj -> {
                Order order = EUtils.blocking((Component)this, blocking -> {
                    DocumentFull document = ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId())));
                    ArrayList<Long> orders = document.getOrders();
                    if (orders.isEmpty()) {
                        throw new NamedException("ShowDocumentsDialog.messages.document_no_order");
                    }
                    if (orders.size() > 1) {
                        throw new RuntimeException("not yet implemented");
                    }
                    return ctx.query(new Select<Order>(Order.MODEL, Order.COL_ID.with(orders.get(0))));
                });
                new EditOrderDialog(ctx, order).openPage(this, () -> this.refresh());
            });
            if (ctx.getPermissions().contains(DocumentFull.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.clone"), obj -> obj != null, obj -> {
                    JComboBox<Object> cmb = new JComboBox<Object>();
                    for (DocumentType type2 : DocumentType.values()) {
                        if (type2.usesCustomer() != obj.getType().usesCustomer()) continue;
                        cmb.addItem((Object)type2);
                    }
                    cmb.setSelectedItem((Object)obj.getType());
                    cmb.setRenderer(new FormattedListCellRenderer(type -> ((DocumentType)((Object)((Object)((Object)((Object)type))))).getLocalizedString(this.BUNDLE)));
                    int answer = JOptionPane.showConfirmDialog(this, cmb, "select type", 2, 3);
                    if (answer != 0) {
                        return;
                    }
                    DocumentType type3 = (DocumentType)((Object)((Object)((Object)cmb.getSelectedItem())));
                    DocumentFull cloned = EUtils.blocking((Component)this, blocking -> {
                        DocumentFull doc = ctx.query(new Select<DocumentFull>(DocumentFull.MODEL, DocumentFull.COL_ID.with(obj.getId())));
                        Properties settings = ctx.query(new GetSettings());
                        boolean kleinunternehmer = Boolean.parseBoolean(settings.getProperty("company.kleinunternehmer"));
                        return doc.cloneDocument(type3, kleinunternehmer ? Taxation.KLEINUNTERNEHMER : Taxation.DEFAULT);
                    });
                    new EditDocumentDialog(ctx, null, cloned).openPage(this, () -> this.refresh());
                });
            }
            this.addCloseButton();
        }
    }
}

