/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditNoticeDialog;
import de.inahware.dav.models.Notice;
import de.inahware.dav.models.types.OrderState;
import de.inahware.edvj.gui.DataTableDialog;
import java.util.ResourceBundle;

public class ShowNoticesDialog
extends DataTableDialog<Notice> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowNoticesDialog(ClientContext ctx) {
        super(Notice.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Notices"));
        this.setWindowSize(1024, 576);
        for (OrderState state2 : OrderState.values()) {
            this.addSearchKeyword(state2.getLocalizedString(this.BUNDLE), Notice.COL_STATE.with(state2));
        }
        this.addSearchColumnString(Notice.COL_DOCUMENT_NUMBER);
        this.addSearchColumnDate(Notice.COL_DATE);
        this.addSearchColumnLong(Notice.COL_COUNT);
        this.addColumn(Notice.COL_STATE, (U state) -> state.getLocalizedString(this.BUNDLE));
        this.addColumn(Notice.COL_DOCUMENT_NUMBER);
        this.addColumn(Notice.COL_DATE);
        this.addColumn(Notice.COL_REMAINING_PRICE);
        this.addColumn(Notice.COL_COUNT, (U number) -> {
            String color = number == 1L ? "#cccc00" : (number == 2L ? "#cc6600" : "#cc0000");
            return "<html><font color=\"" + color + "\"><b>" + number + ". " + this.BUNDLE.getString("Notice") + "</b></font></html>";
        });
        this.getTable().setAutoCreateRowSorter(true);
        this.addDoubleClickAction(obj -> new EditNoticeDialog(ctx, (Notice)obj).openInnerModal(this, () -> this.refresh()));
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditNoticeDialog(ctx, (Notice)obj).openInnerModal(this, () -> this.refresh()));
        this.addCloseButton();
    }
}

