/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditOrderDialog;
import de.inahware.dav.models.Order;
import de.inahware.dav.models.OrderView;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Select;
import java.awt.Component;
import java.util.ResourceBundle;

public class ShowOrdersDialog
extends DataTableDialog<OrderView> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowOrdersDialog(ClientContext ctx) {
        this(ctx, false);
    }

    public ShowOrdersDialog(ClientContext ctx, boolean select) {
        super(OrderView.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Orders"));
        this.setWindowSize(1024, 576);
        this.addSearchColumnString(OrderView.COL_NUMBER);
        for (OrderState orderState : OrderState.values()) {
            this.addSearchKeyword(orderState.getLocalizedString(this.BUNDLE), OrderView.COL_STATE.with(orderState));
        }
        this.addSearchColumnDate(OrderView.COL_DATE);
        this.addSearchColumnString(OrderView.COL_TITLE);
        this.addSearchColumnString(OrderView.COL_CUSTOMER_NUMBER);
        this.addSearchColumnString(OrderView.COL_VENDOR_NUMBER);
        for (Enum enum_ : Salutation.values()) {
            this.addSearchKeyword(((Salutation)enum_).getLocalizedString(this.BUNDLE), OrderView.COL_SALUTATION.with((Salutation)enum_));
        }
        this.addSearchColumnString(OrderView.COL_COMPANY);
        this.addSearchColumnString(OrderView.COL_PREFIX);
        this.addSearchColumnString(OrderView.COL_FIRST_NAME);
        this.addSearchColumnString(OrderView.COL_LAST_NAME);
        this.addColumn(OrderView.COL_STATE, (U state) -> state.getLocalizedString(this.BUNDLE));
        this.addColumn(OrderView.COL_NUMBER);
        this.addColumn(OrderView.COL_DATE);
        this.addColumn(OrderView.COL_TITLE);
        this.addColumn(this.BUNDLE.getString("Customer") + " / " + this.BUNDLE.getString("Vendor"), (T obj) -> {
            if (obj.getCustomerId() != null) {
                return obj.getCustomerNumber();
            }
            if (obj.getVendorNumber() != null) {
                return obj.getVendorNumber();
            }
            return "-";
        });
        this.addColumn(OrderView.COL_COMPANY);
        this.addColumn(OrderView.COL_SALUTATION, (U s) -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.addColumn(OrderView.COL_PREFIX);
        this.addColumn(OrderView.COL_FIRST_NAME);
        this.addColumn(OrderView.COL_LAST_NAME);
        this.getTable().setAutoCreateRowSorter(true);
        if (select) {
            this.addSelectDoubleClickAction();
            this.addSelectCancelButtons();
        } else {
            this.addDoubleClickAction(obj -> {
                Order order = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<Order>(Order.MODEL, Order.COL_ID.with(obj.getId()))));
                new EditOrderDialog(ctx, order).openPage(this, () -> this.refresh());
            });
            if (ctx.getPermissions().contains(Order.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> {
                    Order order = new Order();
                    order.setUserId(ctx.getLogin().getId());
                    new EditOrderDialog(ctx, null, order).openPage(this, () -> this.refresh());
                });
            }
            this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> {
                Order order = EUtils.blocking((Component)this, blocking -> ctx.query(new Select<Order>(Order.MODEL, Order.COL_ID.with(obj.getId()))));
                new EditOrderDialog(ctx, order).openPage(this, () -> this.refresh());
            });
            this.addCloseButton();
        }
    }
}

