/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditPendingNoticeDialog;
import de.inahware.dav.models.PendingNotice;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.query.filter.Span;
import java.time.LocalDate;
import java.util.ResourceBundle;

public class ShowPendingNoticesDialog
extends DataTableDialog<PendingNotice> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowPendingNoticesDialog(ClientContext ctx) {
        super(PendingNotice.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("PendingNotices"));
        this.setWindowSize(1024, 576);
        this.addSearchColumnLong(PendingNotice.COL_DOCUMENT_ID);
        this.addSearchColumnDate(PendingNotice.COL_DATE);
        this.addSearchColumnLong(PendingNotice.COL_COUNT);
        this.addColumn(PendingNotice.COL_DOCUMENT_ID);
        this.addColumn(PendingNotice.COL_DATE);
        this.addColumn(PendingNotice.COL_COUNT, (U number) -> {
            String color = number == 1L ? "#cccc00" : (number == 2L ? "#cc6600" : "#cc0000");
            return "<html><font color=\"" + color + "\"><b>" + number + ". " + this.BUNDLE.getString("Notice") + "</b></font></html>";
        });
        this.getTable().setAutoCreateRowSorter(true);
        this.setFilter(new Span<LocalDate>(PendingNotice.COL_DATE, null, LocalDate.now()));
        this.addDoubleClickAction(obj -> new EditPendingNoticeDialog(ctx, (PendingNotice)obj).openInnerModal(this, () -> this.refresh()));
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditPendingNoticeDialog(ctx, (PendingNotice)obj).openInnerModal(this, () -> this.refresh()));
        this.addCloseButton();
    }
}

