/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditRecordCategoryDialog;
import de.inahware.dav.models.RecordCategory;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETree;
import de.inahware.edvj.gui.ETreeCellRenderer;
import de.inahware.edvj.gui.ETreeModel;
import de.inahware.edvj.gui.ETreeNode;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class ShowRecordCategoriesDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private ClientContext client;
    private JPanel rootPanel;
    private ETree<RecordCategory> tree;
    private JPanel bottomPanel;
    private JButton btnAdd;
    private JButton btnShow;
    private JButton btnRemove;
    private JButton btnClose;
    private JScrollPane scrollPane;

    public ShowRecordCategoriesDialog(ClientContext client) {
        this.client = client;
        this.setTitle(this.BUNDLE.getString("RecordCategories"));
        this.setWindowSize(640, 480);
        this.initialize();
        this.addOpenListener(() -> this.refresh());
        ETreeCellRenderer<RecordCategory> renderer = this.tree.setFormatter(node -> node.getValue() != null ? ((RecordCategory)node.getValue()).getTitle() : this.BUNDLE.getString("RecordCategory.root"));
        renderer.setLeafIcon(renderer.getClosedIcon());
        this.tree.addSelectAction(node -> {
            this.btnAdd.setEnabled(node != null && client.getPermissions().contains(RecordCategory.MODEL.getName() + ".insert"));
            this.btnShow.setEnabled(node != null && node.getValue() != null);
            this.btnRemove.setEnabled(node != null && node.getValue() != null && client.getPermissions().contains(RecordCategory.MODEL.getName() + ".remove"));
        });
        this.tree.addDoubleClickAction(node -> {
            RecordCategory obj = (RecordCategory)node.getValue();
            if (obj != null) {
                new EditRecordCategoryDialog(client, obj).openInnerModal(this, () -> this.refresh());
            }
        });
        this.btnAdd.addActionListener(ev -> {
            RecordCategory obj = new RecordCategory();
            if (this.tree.getSelectedValue() != null) {
                obj.setParentId(this.tree.getSelectedValue().getId());
            }
            new EditRecordCategoryDialog(client, null, obj).openInnerModal(this, () -> this.refresh());
        });
        this.btnShow.addActionListener(ev -> new EditRecordCategoryDialog(client, this.tree.getSelectedValue()).openInnerModal(this, () -> this.refresh()));
        this.btnRemove.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            RecordCategory obj = this.tree.getSelectedValue();
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowRecordCategoriesDialog.messages.delete_confirm.text1") + "\n\n    " + obj.getTitle() + "\n\n" + this.BUNDLE.getString("ShowRecordCategoriesDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> client.query(new Delete<RecordCategory>(RecordCategory.MODEL, obj.getPrimaryFilter())));
            this.refresh();
        }));
        this.btnClose.addActionListener(ev -> this.close());
    }

    private void refresh() throws Exception {
        List categories = EUtils.blocking((Component)this, blocking -> (List)((Object)this.client.query(new SelectAll<RecordCategory>(RecordCategory.MODEL))));
        Set<Long> expanded = this.getExpanded();
        Long selected = this.tree.getSelectedValue() != null ? this.tree.getSelectedValue().getId() : null;
        ETreeNode<Object> root = new ETreeNode<Object>(false, null);
        HashMap<Long, ETreeNode<Object>> categories_nodes = new HashMap<Long, ETreeNode<Object>>();
        categories_nodes.put(null, root);
        for (Object c : categories) {
            categories_nodes.put(((RecordCategory)c).getId(), new ETreeNode<RecordCategory>(false, (RecordCategory)c));
        }
        for (ETreeNode node : categories_nodes.values()) {
            RecordCategory c = (RecordCategory)node.getValue();
            if (c == null) continue;
            ((ETreeNode)categories_nodes.get(c.getParentId())).addChild(node);
        }
        for (ETreeNode node : categories_nodes.values()) {
            if (node.getChildCount() != 0) continue;
            node.setLeaf(true);
        }
        this.tree.setModel(new ETreeModel<Object>(root));
        if (expanded == null) {
            for (Object c : categories_nodes.values()) {
                this.tree.expandPath(new TreePath(((ETreeNode)c).getPath()));
            }
        } else {
            for (Long id : expanded) {
                this.tree.expandPath(new TreePath(((ETreeNode)categories_nodes.get(id)).getPath()));
            }
        }
        if (selected != null) {
            this.tree.setSelectionPath(new TreePath(((ETreeNode)categories_nodes.get(selected)).getPath()));
        }
    }

    private Set<Long> getExpanded() {
        if (this.tree.getModel() == null) {
            return null;
        }
        HashSet<Long> res = new HashSet<Long>();
        this.getExpanded(new TreePath(this.tree.getRoot().getPath()), res);
        return res;
    }

    private void getExpanded(TreePath parent, HashSet<Long> expanded) {
        Enumeration<TreePath> childs = this.tree.getExpandedDescendants(parent);
        if (childs == null) {
            return;
        }
        while (childs.hasMoreElements()) {
            TreePath path = childs.nextElement();
            ETreeNode node = (ETreeNode)path.getLastPathComponent();
            expanded.add(node.getValue() == null ? null : ((RecordCategory)node.getValue()).getId());
            this.getExpanded(path, expanded);
        }
    }

    private void initialize() {
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.add((Component)this.rootPanel, "Center");
        this.scrollPane = new JScrollPane();
        this.rootPanel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.tree = new ETree();
        this.scrollPane.setViewportView(this.tree);
        this.tree.setToggleClickCount(0);
        this.tree.setModel(null);
        this.bottomPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.bottomPanel.getLayout();
        flowLayout.setAlignment(2);
        this.add((Component)this.bottomPanel, "South");
        this.btnAdd = new JButton(this.BUNDLE.getString("generic.button.add"));
        this.bottomPanel.add(this.btnAdd);
        this.btnShow = new JButton(this.BUNDLE.getString("generic.button.show"));
        this.bottomPanel.add(this.btnShow);
        this.btnRemove = new JButton(this.BUNDLE.getString("generic.button.remove"));
        this.bottomPanel.add(this.btnRemove);
        this.btnClose = new JButton(this.BUNDLE.getString("edvj.generic.button.close"));
        this.bottomPanel.add(this.btnClose);
    }
}

