/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditRecordDialog;
import de.inahware.dav.models.Record;
import de.inahware.dav.models.RecordCategory;
import de.inahware.edvj.I18N;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowRecordsDialog
extends DataTableDialog<Record> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private List<RecordCategory> categories;
    private Map<Long, RecordCategory> categories_map;

    public ShowRecordsDialog(Component parent, ClientContext ctx) throws Exception {
        this(parent, false, ctx);
    }

    public ShowRecordsDialog(Component parent, boolean select, ClientContext ctx) throws Exception {
        super(Record.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Records"));
        EUtils.blocking(parent, blocking -> {
            this.categories = (List)((Object)ctx.query(new SelectAll<RecordCategory>(RecordCategory.MODEL)));
            this.categories_map = new HashMap<Long, RecordCategory>();
            for (RecordCategory c : this.categories) {
                this.categories_map.put(c.getId(), c);
            }
            this.categories.sort(Comparator.comparing(category -> this.getFullTitle((RecordCategory)category)));
        });
        this.addSearchColumnLong(Record.COL_ID);
        this.addSearchColumnDate(Record.COL_DATE);
        this.addSearchColumnString(Record.COL_DESCRIPTION);
        this.addColumn(Record.COL_ID);
        this.addColumn(Record.COL_DATE);
        this.addColumn(this.BUNDLE.getString("RecordCategory"), (T obj) -> obj.getCategoryId() == null ? "-" : this.getFullTitle(this.categories_map.get(obj.getCategoryId())));
        this.addColumn(Record.COL_NET_AMOUNT);
        this.addColumn(Record.COL_TOTAL_AMOUNT);
        this.addColumn(Record.COL_DESCRIPTION);
        this.getTable().setAutoCreateRowSorter(true);
        if (select) {
            this.addSelectDoubleClickAction();
            this.addSelectCancelButtons();
        } else {
            this.addDoubleClickAction(obj -> new EditRecordDialog(ctx, (Record)obj).openInnerModal(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Record.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditRecordDialog(ctx, null, new Record()).openInnerModal(this, () -> this.refresh()));
            }
            this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditRecordDialog(ctx, (Record)obj).openInnerModal(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Record.MODEL.getName() + ".delete")) {
                this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                    int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowRecordsDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + " [" + I18N.formatDate(obj.getDate()) + "]\n\n" + this.BUNDLE.getString("ShowRecordsDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                    if (answer != 0) {
                        return;
                    }
                    EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Record>(Record.MODEL, obj.getPrimaryFilter())));
                    this.refresh();
                });
            }
            this.addCloseButton();
        }
    }

    private String getFullTitle(RecordCategory category) {
        Object title = category.getTitle();
        while (category.getParentId() != null) {
            category = this.categories_map.get(category.getParentId());
            title = category.getTitle() + " - " + (String)title;
        }
        return title;
    }
}

