/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.RecordCategory;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.Report;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.ETable;
import de.inahware.edvj.gui.ETableModel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class ShowReportDialog
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private HashMap<Long, RecordCategory> categories_map;
    private HashMap<Long, List<RecordCategory>> tree;
    private JPanel panel;
    private JScrollPane scrollPane;
    private ETable<RecordCategory> table;
    private JPanel panel_bottom;
    private JButton btnClose;

    public ShowReportDialog(List<RecordCategory> categories, List<TaxRate> taxRates, Report report) {
        this.setTitle(this.BUNDLE.getString("Report"));
        this.setSize(1280, 720);
        this.initialize();
        this.table.addColumn(this.BUNDLE.getString("RecordCategory"), c -> {
            if (c == null) {
                return this.BUNDLE.getString("RecordCategory.root");
            }
            return "        ".repeat(this.depth((RecordCategory)c)) + c.getTitle();
        });
        if (report.getNetSum() != null) {
            this.table.addColumn(this.BUNDLE.getString("Report.net"), BigDecimal.class, c -> {
                if (c == null) {
                    return report.getNetSum();
                }
                return report.getNetOf((RecordCategory)c);
            });
            for (TaxRate taxRate : taxRates) {
                if (report.getTaxSum(taxRate) == null) continue;
                this.table.addColumn(taxRate.getDisplayName(), BigDecimal.class, c -> {
                    if (c == null) {
                        return report.getTaxSum(taxRate);
                    }
                    return report.getTaxOf((RecordCategory)c, taxRate);
                });
            }
        }
        this.table.addColumn(this.BUNDLE.getString("Report.total"), BigDecimal.class, c -> {
            if (c == null) {
                return report.getTotalSum();
            }
            return report.getTotalOf((RecordCategory)c);
        });
        this.categories_map = new HashMap();
        for (RecordCategory recordCategory : categories) {
            this.categories_map.put(recordCategory.getId(), recordCategory);
        }
        this.tree = new HashMap();
        this.tree.put(null, new ArrayList());
        for (RecordCategory recordCategory : categories) {
            this.tree.put(recordCategory.getId(), new ArrayList());
        }
        for (RecordCategory recordCategory : categories) {
            this.tree.get(recordCategory.getParentId()).add(recordCategory);
        }
        for (List list : this.tree.values()) {
            list.sort(Comparator.comparing(c -> c.getId()));
        }
        this.insert(null);
        this.btnClose.addActionListener(ev -> this.close());
    }

    private void insert(RecordCategory category) {
        ((ETableModel)this.table.getModel()).addRow(category);
        Long id = category == null ? null : category.getId();
        for (RecordCategory c : this.tree.get(id)) {
            this.insert(c);
        }
    }

    private int depth(RecordCategory category) {
        if (category == null) {
            return 0;
        }
        return this.depth(this.categories_map.get(category.getParentId())) + 1;
    }

    private void initialize() {
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new MigLayout("", "[grow]", "[grow]"));
        this.scrollPane = new JScrollPane();
        this.panel.add((Component)this.scrollPane, "cell 0 0,grow");
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.table = new ETable();
        this.scrollPane.setViewportView(this.table);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.panel_bottom = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.panel_bottom.getLayout();
        flowLayout.setAlignment(2);
        this.add((Component)this.panel_bottom, "South");
        this.btnClose = new JButton(this.BUNDLE.getString("generic.button.close"));
        this.panel_bottom.add(this.btnClose);
    }
}

