/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditRoleDialog;
import de.inahware.dav.models.Role;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowRolesDialog
extends DataTableDialog<Role> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowRolesDialog(ClientContext ctx) {
        super(Role.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Roles"));
        this.addSearchColumnLong(Role.COL_ID);
        this.addSearchColumnString(Role.COL_NAME);
        this.addColumn(Role.COL_ID);
        this.addColumn(Role.COL_NAME);
        this.addDoubleClickAction(obj -> new EditRoleDialog(ctx, (Role)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(Role.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditRoleDialog(ctx, null, new Role()).openInnerModal(this, () -> this.refresh()));
        }
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditRoleDialog(ctx, (Role)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(Role.MODEL.getName() + ".delete")) {
            this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null && obj.getId() != 1L, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowRolesDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + ": " + obj.getName() + "\n\n" + this.BUNDLE.getString("ShowRolesDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blockingCatchWithDialog(this, blocking -> ctx.query(new Delete<Role>(Role.MODEL, obj.getPrimaryFilter())));
                this.refresh();
            });
        }
        this.addCloseButton();
    }
}

