/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditTaskDialog;
import de.inahware.dav.models.Task;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowTasksDialog
extends DataTableDialog<Task> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowTasksDialog(ClientContext ctx) {
        super(Task.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Tasks"));
        this.addSearchColumnLong(Task.COL_ID);
        this.addSearchColumnString(Task.COL_TITLE);
        this.addColumn(Task.COL_ID);
        this.addColumn(Task.COL_TITLE);
        this.addColumn(Task.COL_CREATED_AT);
        this.addColumn(Task.COL_DUE_AT);
        this.addColumn(Task.COL_COMPLETED_AT);
        this.getTable().setAutoCreateRowSorter(true);
        this.addDoubleClickAction(obj -> new EditTaskDialog(ctx, (Task)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(Task.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditTaskDialog(ctx, null, new Task(ctx.getLogin())).openInnerModal(this, () -> this.refresh()));
        }
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditTaskDialog(ctx, (Task)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(Task.MODEL.getName() + ".delete")) {
            this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowCustomersDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + ": " + obj.getTitle() + "\n\n" + this.BUNDLE.getString("ShowCustomersDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Task>(Task.MODEL, obj.getPrimaryFilter())));
                this.refresh();
            });
        }
        this.addCloseButton();
    }
}

