/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditTaxRateDialog;
import de.inahware.dav.models.TaxRate;
import de.inahware.edvj.gui.DataTableDialog;
import java.util.ResourceBundle;

public class ShowTaxRatesDialog
extends DataTableDialog<TaxRate> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowTaxRatesDialog(ClientContext ctx) {
        super(TaxRate.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("TaxRates"));
        this.addSearchColumnString(TaxRate.COL_COMMENT);
        this.addSearchColumnString(TaxRate.COL_NAME);
        this.addColumn(TaxRate.COL_COMMENT);
        this.addColumn(TaxRate.COL_NAME);
        this.addColumn(TaxRate.COL_RATE);
        this.setFilter(TaxRate.COL_ENABLED.with(true));
        this.addDoubleClickAction(obj -> new EditTaxRateDialog(ctx, (TaxRate)obj).openInnerModal(this, () -> this.refresh()));
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditTaxRateDialog(ctx, (TaxRate)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(TaxRate.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.replace"), obj -> obj != null, obj -> {
                Long prev = obj.getId();
                obj = new TaxRate((TaxRate)obj);
                obj.setId(null);
                obj.setPrevTaxRateId(prev);
                new EditTaxRateDialog(ctx, null, (TaxRate)obj).openInnerModal(this, () -> this.refresh());
            });
        }
        this.addCloseButton();
    }
}

