/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.models.Role;
import de.inahware.dav.models.User;
import de.inahware.dav.models.UserRole;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.Insert;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.query.filter.And;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class ShowUserRolesDialog
extends DataTableDialog<UserRole> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowUserRolesDialog(Component parent, ClientContext ctx, User user) throws Exception {
        super(UserRole.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("User") + " #" + user.getId() + " (" + user.getUsername() + "; " + user.getName() + ") - " + this.BUNDLE.getString("Roles"));
        this.setWindowSize(480, 270);
        List roles = EUtils.blocking(parent, blocking -> (List)((Object)ctx.query(new SelectAll<Role>(Role.MODEL))));
        HashMap<Long, Role> roles_by_id = new HashMap<Long, Role>();
        for (Role g : roles) {
            roles_by_id.put(g.getId(), g);
        }
        this.disableSearch();
        this.addColumn(this.BUNDLE.getString("Roles"), (T obj) -> ((Role)roles_by_id.get(obj.getRoleId())).getName());
        this.setFilter(UserRole.COL_USER_ID.with(user.getId()));
        this.addButton(this.BUNDLE.getString("generic.button.add"), _obj -> {
            JComboBox<Object> cmbRoles = new JComboBox<Object>();
            for (Role g : roles) {
                cmbRoles.addItem(g);
            }
            cmbRoles.setRenderer(new FormattedListCellRenderer(obj -> ((Role)obj).getName()));
            int answer = JOptionPane.showConfirmDialog(this, cmbRoles, this.BUNDLE.getString("ShowUserRolesDialog.messages.select_role"), 2, 3);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new Insert<UserRole>(UserRole.MODEL, new UserRole(user.getId(), ((Role)cmbRoles.getSelectedItem()).getId()))));
            this.refresh();
        });
        this.addButton(this.BUNDLE.getString("generic.button.remove"), obj -> obj != null, obj -> {
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowUserRolesDialog.messages.delete_confirm.text1") + "\n\n    " + this.BUNDLE.getString("User") + " #" + obj.getUserId() + " - " + this.BUNDLE.getString("Role") + " " + ((Role)roles_by_id.get(obj.getRoleId())).getName() + "\n\n" + this.BUNDLE.getString("ShowUserRolesDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<UserRole>(UserRole.MODEL, new And(obj.getPrimaryFields()))));
            this.refresh();
        });
        this.addCloseButton();
    }
}

