/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditUserDialog;
import de.inahware.dav.models.User;
import de.inahware.dav.requests.UserHasPassword;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import de.inahware.edvj.query.SelectAll;
import java.awt.Component;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowUsersDialog
extends DataTableDialog<User> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowUsersDialog(Component parent, ClientContext ctx) throws Exception {
        super(User.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Users"));
        this.addSearchColumnLong(User.COL_ID);
        this.addSearchColumnString(User.COL_USERNAME);
        this.addSearchColumnString(User.COL_NAME);
        this.addColumn(User.COL_ID);
        this.addColumn(User.COL_USERNAME);
        this.addColumn(User.COL_NAME);
        this.addDoubleClickAction(obj -> new EditUserDialog(ctx, (User)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(User.MODEL.getName() + ".insert")) {
            this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> {
                EUtils.blocking((Component)this, blocking -> {
                    boolean pw;
                    ArrayList users = (ArrayList)((Object)ctx.query(new SelectAll<User>(User.MODEL)));
                    if (users.size() == 1 && !(pw = ctx.query(new UserHasPassword(((User)users.get(0)).getId())).booleanValue())) {
                        throw new RuntimeException(this.BUNDLE.getString("EditUserDialog.messages.error_single_user"));
                    }
                });
                new EditUserDialog(ctx, null, new User()).openInnerModal(this, () -> this.refresh());
            });
        }
        this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditUserDialog(ctx, (User)obj).openInnerModal(this, () -> this.refresh()));
        if (ctx.getPermissions().contains(User.MODEL.getName() + ".delete")) {
            this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null && obj.getId() != 1L, obj -> {
                int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowUsersDialog.messages.delete_confirm.text1") + "\n\n    #" + obj.getId() + ": " + obj.getUsername() + " (" + obj.getName() + ")\n\n" + this.BUNDLE.getString("ShowUsersDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                if (answer != 0) {
                    return;
                }
                EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<User>(User.MODEL, obj.getPrimaryFilter())));
                this.refresh();
            });
        }
        this.addCloseButton();
    }
}

