/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.gui.EditVendorDialog;
import de.inahware.dav.models.Vendor;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.gui.DataTableDialog;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.query.Delete;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class ShowVendorsDialog
extends DataTableDialog<Vendor> {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();

    public ShowVendorsDialog(boolean select, ClientContext ctx) {
        super(Vendor.MODEL, ctx);
        this.setTitle(this.BUNDLE.getString("Vendors"));
        this.addSearchColumnString(Vendor.COL_NUMBER);
        this.addSearchColumnString(Vendor.COL_COMPANY);
        for (Salutation s2 : Salutation.values()) {
            this.addSearchKeyword(s2.getLocalizedString(this.BUNDLE), Vendor.COL_SALUTATION.with(s2));
        }
        this.addSearchColumnString(Vendor.COL_PREFIX);
        this.addSearchColumnString(Vendor.COL_FIRST_NAME);
        this.addSearchColumnString(Vendor.COL_LAST_NAME);
        this.addColumn(Vendor.COL_NUMBER);
        this.addColumn(Vendor.COL_COMPANY);
        this.addColumn(Vendor.COL_SALUTATION, (U s) -> s == null ? "-" : s.getLocalizedString(this.BUNDLE));
        this.addColumn(Vendor.COL_PREFIX);
        this.addColumn(Vendor.COL_FIRST_NAME);
        this.addColumn(Vendor.COL_LAST_NAME);
        this.getTable().setAutoCreateRowSorter(true);
        if (select) {
            this.addSelectDoubleClickAction();
            this.addSelectCancelButtons();
        } else {
            this.addDoubleClickAction(obj -> new EditVendorDialog(ctx, (Vendor)obj).openPage(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Vendor.MODEL.getName() + ".insert")) {
                this.addButton(this.BUNDLE.getString("generic.button.new"), obj -> new EditVendorDialog(ctx, null, new Vendor()).openPage(this, () -> this.refresh()));
            }
            this.addButton(this.BUNDLE.getString("generic.button.show"), obj -> obj != null, obj -> new EditVendorDialog(ctx, (Vendor)obj).openPage(this, () -> this.refresh()));
            if (ctx.getPermissions().contains(Vendor.MODEL.getName() + ".delete")) {
                this.addButton(this.BUNDLE.getString("generic.button.delete"), obj -> obj != null, obj -> {
                    int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("ShowVendorsDialog.messages.delete_confirm.text1") + "\n\n    " + obj.getNumber() + ": " + obj.getDisplayName(this.BUNDLE) + "\n\n" + this.BUNDLE.getString("ShowVendorsDialog.messages.delete_confirm.text2"), this.getTitle(), 0);
                    if (answer != 0) {
                        return;
                    }
                    EUtils.blocking((Component)this, blocking -> ctx.query(new Delete<Vendor>(Vendor.MODEL, obj.getPrimaryFilter())));
                    this.refresh();
                });
            }
            this.addCloseButton();
        }
    }
}

