/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.client.gui;

import de.inahware.dav.client.BaseMain;
import de.inahware.dav.client.ClientContext;
import de.inahware.dav.client.LocalClient;
import de.inahware.dav.client.LocalClientConfig;
import de.inahware.dav.models.Models;
import de.inahware.edvj.gui.EFileChooser;
import de.inahware.edvj.gui.EFrame;
import de.inahware.edvj.gui.EUtils;
import de.inahware.edvj.gui.FormattedListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class StartupWindow
extends EFrame {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle BUNDLE = ClientContext.getBundle();
    private Path p_profiles;
    private boolean started;
    private JPanel panel;
    private JLabel lblProfile;
    private JComboBox<LocalProfile> cmbProfile;
    private JPanel panel_bottom;
    private JPanel panel_1;
    private JButton btnNew;
    private JButton btnDelete;
    private JButton btnExport;
    private JButton btnImport;
    private JPanel panel_2;
    private JButton btnStart;
    private JButton btnClose;

    private StartupWindow() {
        this.initialize();
    }

    public StartupWindow(BaseMain main) {
        this.p_profiles = Path.of(System.getProperty("user.home"), ".inahware", "dav", "profiles");
        this.setTitle("InahWare DAV");
        this.setPacking(true);
        this.initialize();
        this.addClosedListener(() -> {
            if (!this.started) {
                System.exit(0);
            }
        });
        this.cmbProfile.setRenderer(new FormattedListCellRenderer(obj -> obj == null ? "-" : ((LocalProfile)obj).config.getProfileName()));
        this.cmbProfile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean active = StartupWindow.this.cmbProfile.getSelectedItem() != null;
                StartupWindow.this.btnExport.setEnabled(active);
                StartupWindow.this.btnDelete.setEnabled(active);
                StartupWindow.this.btnStart.setEnabled(active);
            }
        });
        this.btnNew.addActionListener(ev -> EUtils.catchWithDialog(this, () -> {
            String name = JOptionPane.showInputDialog(this, (Object)this.BUNDLE.getString("StartupWindow.messages.input_name"));
            if (name == null) {
                return;
            }
            Object pathname = name.replaceAll("[^A-Za-z0-9-_]", "_");
            if (this.p_profiles.resolve((String)pathname).toFile().exists()) {
                int i = 1;
                while (this.p_profiles.resolve((String)pathname + "-" + i).toFile().exists()) {
                    ++i;
                }
                pathname = (String)pathname + "-" + i;
            }
            Path p_profile = this.p_profiles.resolve((String)pathname);
            Files.createDirectories(p_profile, new FileAttribute[0]);
            LocalClientConfig config = new LocalClientConfig();
            config.setProfileName(name);
            config.setLocalDb(Path.of("main.db", new String[0]));
            config.setStoragePath(Path.of("storage", new String[0]));
            config.write(p_profile.resolve("config.properties"));
            this.loadProfiles(p_profile);
        }));
        this.btnImport.addActionListener(ev -> {
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("generic.button.import"));
            dialog.addDefaultFilter("ZIP archive", "zip");
            Path inputPath = dialog.open(this);
            if (inputPath == null) {
                return;
            }
            String initialName = FilenameUtils.removeExtension(inputPath.getFileName().toString());
            String profileName = JOptionPane.showInputDialog(this, this.BUNDLE.getString("StartupWindow.messages.input_name"), initialName);
            if (profileName == null) {
                return;
            }
            Object pathname = profileName.replaceAll("[^A-Za-z0-9-_]", "_");
            if (this.p_profiles.resolve((String)pathname).toFile().exists()) {
                int i = 1;
                while (this.p_profiles.resolve((String)pathname + "-" + i).toFile().exists()) {
                    ++i;
                }
                pathname = (String)pathname + "-" + i;
            }
            Path p_profile = this.p_profiles.resolve((String)pathname);
            try {
                EUtils.blocking((Component)this, blocking -> {
                    Files.createDirectories(p_profile, new FileAttribute[0]);
                    LocalClientConfig config = new LocalClientConfig();
                    config.setProfileName(profileName);
                    config.setLocalDb(Path.of("main.db", new String[0]));
                    config.setStoragePath(Path.of("storage", new String[0]));
                    config.write(p_profile.resolve("config.properties"));
                    LocalClient client = LocalClient.fromConfig(main.getVersion(), main.getModelExtensions(), ClientContext.getBundle(), config, p_profile);
                    try (FileInputStream input = new FileInputStream(inputPath.toFile());){
                        Models.importBackup(client.getDSLContext(), client.getStoragePath(), input);
                    }
                    finally {
                        client.shutdown();
                    }
                });
                this.loadProfiles(p_profile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                EUtils.showErrorDialog((Component)this, ex);
                EUtils.blockingCatchWithDialog(this, blocking -> FileUtils.deleteDirectory(this.p_profiles.toFile()));
            }
        });
        this.btnExport.addActionListener(ev -> {
            LocalProfile profile = (LocalProfile)this.cmbProfile.getSelectedItem();
            EFileChooser dialog = new EFileChooser();
            dialog.setDialogTitle(this.BUNDLE.getString("generic.button.export"));
            dialog.addDefaultFilter("ZIP archive", "zip");
            dialog.setSelectedFile(Path.of(profile.config.getProfileName().replaceAll("[^A-Za-z0-9-_]", "_") + ".zip", new String[0]).toFile());
            Path path = dialog.save(this);
            if (path == null) {
                return;
            }
            EUtils.blockingCatchWithDialog(this, blocking -> {
                LocalClient client = LocalClient.fromConfig(main.getVersion(), main.getModelExtensions(), ClientContext.getBundle(), profile.config, profile.path);
                try (FileOutputStream output = new FileOutputStream(path.toFile());){
                    Models.exportBackup(client.getDSLContext(), client.getStoragePath(), output);
                }
                finally {
                    client.shutdown();
                }
            });
        });
        this.btnDelete.addActionListener(ev -> {
            LocalProfile profile = (LocalProfile)this.cmbProfile.getSelectedItem();
            int answer = JOptionPane.showConfirmDialog(this, this.BUNDLE.getString("StartupWindow.messages.delete_confirm.text1") + "\n\n    " + profile.config.getProfileName() + "\n\n" + this.BUNDLE.getString("StartupWindow.messages.delete_confirm.text2"), this.getTitle(), 0);
            if (answer != 0) {
                return;
            }
            EUtils.catchWithDialog(this, () -> {
                EUtils.blocking((Component)this, blocking -> FileUtils.deleteDirectory(profile.path.toFile()));
                this.loadProfiles();
            });
        });
        this.btnStart.addActionListener(ev -> {
            LocalProfile profile = (LocalProfile)this.cmbProfile.getSelectedItem();
            EUtils.catchWithDialog(this, () -> {
                EUtils.blocking((Component)this, blocking -> main.run(profile.config, profile.path));
                this.started = true;
                this.close();
            });
        });
        this.btnClose.addActionListener(ev -> this.close());
        EUtils.catchWithDialog(this, () -> this.loadProfiles());
    }

    private void loadProfiles() throws Exception {
        this.loadProfiles(null);
    }

    private void loadProfiles(Path select) throws Exception {
        List profiles = EUtils.blocking((Component)this, blocking -> LocalProfile.loadProfiles(this.p_profiles));
        this.cmbProfile.removeAllItems();
        for (LocalProfile p : profiles) {
            this.cmbProfile.addItem(p);
            if (!p.path.equals(select)) continue;
            this.cmbProfile.setSelectedItem(p);
        }
        this.btnDelete.setEnabled(!profiles.isEmpty());
        this.btnExport.setEnabled(!profiles.isEmpty());
        this.btnStart.setEnabled(!profiles.isEmpty());
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.add((Component)this.panel, "Center");
        this.panel.setLayout(new MigLayout("", "[][240px,grow][][]", "[][][]"));
        this.lblProfile = new JLabel(this.BUNDLE.getString("StartupWindow.label.profile") + ":");
        this.panel.add((Component)this.lblProfile, "cell 0 0,alignx trailing");
        this.cmbProfile = new JComboBox();
        this.panel.add(this.cmbProfile, "flowx,cell 1 0,growx");
        this.btnNew = new JButton(this.BUNDLE.getString("generic.button.new"));
        this.panel.add((Component)this.btnNew, "cell 2 0,growx");
        this.btnImport = new JButton(this.BUNDLE.getString("generic.button.import"));
        this.panel.add((Component)this.btnImport, "cell 3 0,growx");
        this.btnExport = new JButton(this.BUNDLE.getString("generic.button.export"));
        this.panel.add((Component)this.btnExport, "cell 0 1 4 1,growx");
        this.btnDelete = new JButton(this.BUNDLE.getString("generic.button.delete"));
        this.panel.add((Component)this.btnDelete, "cell 0 2 4 1,growx");
        this.panel_bottom = new JPanel();
        this.add((Component)this.panel_bottom, "South");
        this.panel_bottom.setLayout(new BorderLayout(0, 0));
        this.panel_1 = new JPanel();
        this.panel_bottom.add((Component)this.panel_1, "West");
        this.panel_2 = new JPanel();
        this.panel_bottom.add((Component)this.panel_2, "East");
        this.btnStart = new JButton(this.BUNDLE.getString("generic.button.start"));
        this.panel_2.add(this.btnStart);
        this.btnClose = new JButton(this.BUNDLE.getString("generic.button.close"));
        this.panel_2.add(this.btnClose);
    }

    private static class LocalProfile {
        public Path path;
        public Path configFile;
        public LocalClientConfig config;

        public LocalProfile(Path path) throws Exception {
            this.path = path;
            this.configFile = path.resolve("config.properties");
            this.config = LocalClientConfig.fromFile(this.configFile);
        }

        public static List<LocalProfile> loadProfiles(Path path) {
            List<LocalProfile> list;
            block8: {
                Stream<Path> files = Files.list(path);
                try {
                    list = files.map(f -> {
                        if (Files.isDirectory(f, new LinkOption[0])) {
                            try {
                                return new LocalProfile((Path)f);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                return null;
                            }
                        }
                        return null;
                    }).filter(p -> p != null).collect(Collectors.toList());
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return List.of();
                    }
                }
                files.close();
            }
            return list;
        }
    }
}

