/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.jooq.tables;

import de.inahware.dav.jooq.DefaultSchema;
import de.inahware.dav.jooq.Indexes;
import de.inahware.dav.jooq.Keys;
import de.inahware.dav.jooq.tables.Attachment;
import de.inahware.dav.jooq.tables.Customer;
import de.inahware.dav.jooq.tables.User;
import de.inahware.dav.jooq.tables.Vendor;
import de.inahware.dav.jooq.tables.records.DocumentRecord;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class Document
extends TableImpl<DocumentRecord> {
    private static final long serialVersionUID = 1L;
    public static final Document DOCUMENT = new Document();
    public final TableField<DocumentRecord, Long> ID = Document.createField(DSL.name("id"), SQLDataType.BIGINT.nullable(false).identity(true), this, "");
    public final TableField<DocumentRecord, String> NUMBER = Document.createField(DSL.name("number"), SQLDataType.VARCHAR(64).nullable(false), this, "");
    public final TableField<DocumentRecord, String> TYPE = Document.createField(DSL.name("type"), SQLDataType.VARCHAR(64).nullable(false), this, "");
    public final TableField<DocumentRecord, String> STATE = Document.createField(DSL.name("state"), SQLDataType.VARCHAR(64).nullable(false), this, "");
    public final TableField<DocumentRecord, LocalDate> DATE = Document.createField(DSL.name("date"), SQLDataType.LOCALDATE.nullable(false), this, "");
    public final TableField<DocumentRecord, LocalDate> DUE_DATE = Document.createField(DSL.name("due_date"), SQLDataType.LOCALDATE.defaultValue(DSL.field("NULL", SQLDataType.LOCALDATE)), this, "");
    public final TableField<DocumentRecord, String> SERVICE_TYPE = Document.createField(DSL.name("service_type"), SQLDataType.VARCHAR(64).defaultValue(DSL.field("NULL", SQLDataType.VARCHAR)), this, "");
    public final TableField<DocumentRecord, LocalDate> SERVICE_DATE1 = Document.createField(DSL.name("service_date1"), SQLDataType.LOCALDATE.defaultValue(DSL.field("NULL", SQLDataType.LOCALDATE)), this, "");
    public final TableField<DocumentRecord, LocalDate> SERVICE_DATE2 = Document.createField(DSL.name("service_date2"), SQLDataType.LOCALDATE.defaultValue(DSL.field("NULL", SQLDataType.LOCALDATE)), this, "");
    public final TableField<DocumentRecord, Long> USER_ID = Document.createField(DSL.name("user_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<DocumentRecord, Long> CUSTOMER_ID = Document.createField(DSL.name("customer_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<DocumentRecord, Long> VENDOR_ID = Document.createField(DSL.name("vendor_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<DocumentRecord, String> SALUTATION = Document.createField(DSL.name("salutation"), SQLDataType.VARCHAR(64).defaultValue(DSL.field("NULL", SQLDataType.VARCHAR)), this, "");
    public final TableField<DocumentRecord, String> PREFIX = Document.createField(DSL.name("prefix"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> FIRST_NAME = Document.createField(DSL.name("first_name"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> LAST_NAME = Document.createField(DSL.name("last_name"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> COMPANY = Document.createField(DSL.name("company"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> ADDRESS1 = Document.createField(DSL.name("address1"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> ADDRESS2 = Document.createField(DSL.name("address2"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> COUNTRY = Document.createField(DSL.name("country"), SQLDataType.CHAR(2).nullable(false), this, "");
    public final TableField<DocumentRecord, String> REFERENCE_NUMBER = Document.createField(DSL.name("reference_number"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<DocumentRecord, String> TEXT = Document.createField(DSL.name("text"), SQLDataType.CLOB.nullable(false), this, "");
    public final TableField<DocumentRecord, String> TAXATION = Document.createField(DSL.name("taxation"), SQLDataType.VARCHAR(64).nullable(false), this, "");
    public final TableField<DocumentRecord, BigDecimal> PARTIAL_PRICE = Document.createField(DSL.name("partial_price"), SQLDataType.DECIMAL(18, 2).defaultValue(DSL.field("NULL", SQLDataType.DECIMAL)), this, "");
    public final TableField<DocumentRecord, BigDecimal> TOTAL_PRICE = Document.createField(DSL.name("total_price"), SQLDataType.DECIMAL(18, 2).defaultValue(DSL.field("NULL", SQLDataType.DECIMAL)), this, "");
    public final TableField<DocumentRecord, BigDecimal> REMAINING_PRICE = Document.createField(DSL.name("remaining_price"), SQLDataType.DECIMAL(18, 2).defaultValue(DSL.field("NULL", SQLDataType.DECIMAL)), this, "");
    public final TableField<DocumentRecord, Long> ATTACHMENT_ID = Document.createField(DSL.name("attachment_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<DocumentRecord, Long> HEADLESS_ATTACHMENT_ID = Document.createField(DSL.name("headless_attachment_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<DocumentRecord, Long> PRINTED = Document.createField(DSL.name("printed"), SQLDataType.BIGINT.nullable(false), this, "");
    private transient User _user;
    private transient Customer _customer;
    private transient Vendor _vendor;
    private transient Attachment _documentAttachmentId;
    private transient Attachment _documentHeadlessAttachmentId;

    @Override
    public Class<DocumentRecord> getRecordType() {
        return DocumentRecord.class;
    }

    private Document(Name alias, Table<DocumentRecord> aliased) {
        this(alias, aliased, null);
    }

    private Document(Name alias, Table<DocumentRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment(""), TableOptions.table());
    }

    public Document(String alias) {
        this(DSL.name(alias), DOCUMENT);
    }

    public Document(Name alias) {
        this(alias, DOCUMENT);
    }

    public Document() {
        this(DSL.name("document"), (Table<DocumentRecord>)null);
    }

    public <O extends Record> Document(Table<O> child, ForeignKey<O, DocumentRecord> key) {
        super(child, key, DOCUMENT);
    }

    @Override
    public Schema getSchema() {
        return this.aliased() ? null : DefaultSchema.DEFAULT_SCHEMA;
    }

    @Override
    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.DOCUMENT_DOCUMENT_DATE, Indexes.DOCUMENT_DOCUMENT_STATE, Indexes.DOCUMENT_DOCUMENT_TYPE);
    }

    @Override
    public Identity<DocumentRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    @Override
    public UniqueKey<DocumentRecord> getPrimaryKey() {
        return Keys.KEY_DOCUMENT_PRIMARY;
    }

    @Override
    public List<UniqueKey<DocumentRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.KEY_DOCUMENT_DOCUMENT_NUMBER);
    }

    @Override
    public List<ForeignKey<DocumentRecord, ?>> getReferences() {
        return Arrays.asList(Keys.DOCUMENT_USER_ID, Keys.DOCUMENT_CUSTOMER_ID, Keys.DOCUMENT_VENDOR_ID, Keys.DOCUMENT_ATTACHMENT_ID, Keys.DOCUMENT_HEADLESS_ATTACHMENT_ID);
    }

    public User user() {
        if (this._user == null) {
            this._user = new User(this, Keys.DOCUMENT_USER_ID);
        }
        return this._user;
    }

    public Customer customer() {
        if (this._customer == null) {
            this._customer = new Customer(this, Keys.DOCUMENT_CUSTOMER_ID);
        }
        return this._customer;
    }

    public Vendor vendor() {
        if (this._vendor == null) {
            this._vendor = new Vendor(this, Keys.DOCUMENT_VENDOR_ID);
        }
        return this._vendor;
    }

    public Attachment documentAttachmentId() {
        if (this._documentAttachmentId == null) {
            this._documentAttachmentId = new Attachment(this, Keys.DOCUMENT_ATTACHMENT_ID);
        }
        return this._documentAttachmentId;
    }

    public Attachment documentHeadlessAttachmentId() {
        if (this._documentHeadlessAttachmentId == null) {
            this._documentHeadlessAttachmentId = new Attachment(this, Keys.DOCUMENT_HEADLESS_ATTACHMENT_ID);
        }
        return this._documentHeadlessAttachmentId;
    }

    @Override
    public Document as(String alias) {
        return new Document(DSL.name(alias), this);
    }

    @Override
    public Document as(Name alias) {
        return new Document(alias, this);
    }

    public Document as(Table<?> alias) {
        return new Document(alias.getQualifiedName(), this);
    }

    public Document rename(String name) {
        return new Document(DSL.name(name), null);
    }

    public Document rename(Name name) {
        return new Document(name, null);
    }

    public Document rename(Table<?> name) {
        return new Document(name.getQualifiedName(), null);
    }
}

