/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.jooq.tables;

import de.inahware.dav.jooq.DefaultSchema;
import de.inahware.dav.jooq.Indexes;
import de.inahware.dav.jooq.Keys;
import de.inahware.dav.jooq.tables.Customer;
import de.inahware.dav.jooq.tables.User;
import de.inahware.dav.jooq.tables.Vendor;
import de.inahware.dav.jooq.tables.records.OrderRecord;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class Order
extends TableImpl<OrderRecord> {
    private static final long serialVersionUID = 1L;
    public static final Order ORDER = new Order();
    public final TableField<OrderRecord, Long> ID = Order.createField(DSL.name("id"), SQLDataType.BIGINT.nullable(false).identity(true), this, "");
    public final TableField<OrderRecord, String> NUMBER = Order.createField(DSL.name("number"), SQLDataType.VARCHAR(64).nullable(false), this, "");
    public final TableField<OrderRecord, String> STATE = Order.createField(DSL.name("state"), SQLDataType.VARCHAR(64).nullable(false), this, "");
    public final TableField<OrderRecord, LocalDate> DATE = Order.createField(DSL.name("date"), SQLDataType.LOCALDATE.nullable(false), this, "");
    public final TableField<OrderRecord, Long> USER_ID = Order.createField(DSL.name("user_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<OrderRecord, String> TITLE = Order.createField(DSL.name("title"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, Long> CUSTOMER_ID = Order.createField(DSL.name("customer_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<OrderRecord, Long> VENDOR_ID = Order.createField(DSL.name("vendor_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<OrderRecord, String> REFERENCE_NUMBER = Order.createField(DSL.name("reference_number"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SALUTATION = Order.createField(DSL.name("salutation"), SQLDataType.VARCHAR(64).defaultValue(DSL.field("NULL", SQLDataType.VARCHAR)), this, "");
    public final TableField<OrderRecord, String> PREFIX = Order.createField(DSL.name("prefix"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> FIRST_NAME = Order.createField(DSL.name("first_name"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> LAST_NAME = Order.createField(DSL.name("last_name"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> COMPANY = Order.createField(DSL.name("company"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> ADDRESS1 = Order.createField(DSL.name("address1"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> ADDRESS2 = Order.createField(DSL.name("address2"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> COUNTRY = Order.createField(DSL.name("country"), SQLDataType.CHAR(2).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_SALUTATION = Order.createField(DSL.name("shipping_salutation"), SQLDataType.VARCHAR(64).defaultValue(DSL.field("NULL", SQLDataType.VARCHAR)), this, "");
    public final TableField<OrderRecord, String> SHIPPING_PREFIX = Order.createField(DSL.name("shipping_prefix"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_FIRST_NAME = Order.createField(DSL.name("shipping_first_name"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_LAST_NAME = Order.createField(DSL.name("shipping_last_name"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_COMPANY = Order.createField(DSL.name("shipping_company"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_ADDRESS1 = Order.createField(DSL.name("shipping_address1"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_ADDRESS2 = Order.createField(DSL.name("shipping_address2"), SQLDataType.VARCHAR(255).nullable(false), this, "");
    public final TableField<OrderRecord, String> SHIPPING_COUNTRY = Order.createField(DSL.name("shipping_country"), SQLDataType.CHAR(2).nullable(false), this, "");
    private transient User _user;
    private transient Customer _customer;
    private transient Vendor _vendor;

    @Override
    public Class<OrderRecord> getRecordType() {
        return OrderRecord.class;
    }

    private Order(Name alias, Table<OrderRecord> aliased) {
        this(alias, aliased, null);
    }

    private Order(Name alias, Table<OrderRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment(""), TableOptions.table());
    }

    public Order(String alias) {
        this(DSL.name(alias), ORDER);
    }

    public Order(Name alias) {
        this(alias, ORDER);
    }

    public Order() {
        this(DSL.name("order"), (Table<OrderRecord>)null);
    }

    public <O extends Record> Order(Table<O> child, ForeignKey<O, OrderRecord> key) {
        super(child, key, ORDER);
    }

    @Override
    public Schema getSchema() {
        return this.aliased() ? null : DefaultSchema.DEFAULT_SCHEMA;
    }

    @Override
    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.ORDER_ORDER_DATE);
    }

    @Override
    public Identity<OrderRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    @Override
    public UniqueKey<OrderRecord> getPrimaryKey() {
        return Keys.KEY_ORDER_PRIMARY;
    }

    @Override
    public List<UniqueKey<OrderRecord>> getUniqueKeys() {
        return Arrays.asList(Keys.KEY_ORDER_ORDER_NUMBER);
    }

    @Override
    public List<ForeignKey<OrderRecord, ?>> getReferences() {
        return Arrays.asList(Keys.ORDER_USER_ID, Keys.ORDER_CUSTOMER_ID, Keys.ORDER_VENDOR_ID);
    }

    public User user() {
        if (this._user == null) {
            this._user = new User(this, Keys.ORDER_USER_ID);
        }
        return this._user;
    }

    public Customer customer() {
        if (this._customer == null) {
            this._customer = new Customer(this, Keys.ORDER_CUSTOMER_ID);
        }
        return this._customer;
    }

    public Vendor vendor() {
        if (this._vendor == null) {
            this._vendor = new Vendor(this, Keys.ORDER_VENDOR_ID);
        }
        return this._vendor;
    }

    @Override
    public Order as(String alias) {
        return new Order(DSL.name(alias), this);
    }

    @Override
    public Order as(Name alias) {
        return new Order(alias, this);
    }

    public Order as(Table<?> alias) {
        return new Order(alias.getQualifiedName(), this);
    }

    public Order rename(String name) {
        return new Order(DSL.name(name), null);
    }

    public Order rename(Name name) {
        return new Order(name, null);
    }

    public Order rename(Table<?> name) {
        return new Order(name.getQualifiedName(), null);
    }
}

