/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.jooq.tables;

import de.inahware.dav.jooq.DefaultSchema;
import de.inahware.dav.jooq.Indexes;
import de.inahware.dav.jooq.Keys;
import de.inahware.dav.jooq.tables.Attachment;
import de.inahware.dav.jooq.tables.Document;
import de.inahware.dav.jooq.tables.RecordCategory;
import de.inahware.dav.jooq.tables.records.RecordRecord;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.jooq.Check;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Function9;
import org.jooq.Identity;
import org.jooq.Index;
import org.jooq.JSON;
import org.jooq.Name;
import org.jooq.Records;
import org.jooq.Row9;
import org.jooq.Schema;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class Record
extends TableImpl<RecordRecord> {
    private static final long serialVersionUID = 1L;
    public static final Record RECORD = new Record();
    public final TableField<RecordRecord, Long> ID = Record.createField(DSL.name("id"), SQLDataType.BIGINT.nullable(false).identity(true), this, "");
    public final TableField<RecordRecord, LocalDate> DATE = Record.createField(DSL.name("date"), SQLDataType.LOCALDATE.nullable(false), this, "");
    public final TableField<RecordRecord, Long> CATEGORY_ID = Record.createField(DSL.name("category_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<RecordRecord, BigDecimal> NET_AMOUNT = Record.createField(DSL.name("net_amount"), SQLDataType.DECIMAL(18, 2).nullable(false), this, "");
    public final TableField<RecordRecord, BigDecimal> TOTAL_AMOUNT = Record.createField(DSL.name("total_amount"), SQLDataType.DECIMAL(18, 2).nullable(false), this, "");
    public final TableField<RecordRecord, JSON> TAXES = Record.createField(DSL.name("taxes"), SQLDataType.JSON.nullable(false).defaultValue(DSL.field("'[]'", SQLDataType.JSON)), this, "");
    public final TableField<RecordRecord, String> DESCRIPTION = Record.createField(DSL.name("description"), SQLDataType.CLOB.nullable(false), this, "");
    public final TableField<RecordRecord, Long> DOCUMENT_ID = Record.createField(DSL.name("document_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    public final TableField<RecordRecord, Long> ATTACHMENT_ID = Record.createField(DSL.name("attachment_id"), SQLDataType.BIGINT.defaultValue(DSL.field("NULL", SQLDataType.BIGINT)), this, "");
    private transient RecordCategory _recordCategory;
    private transient Document _document;
    private transient Attachment _attachment;

    @Override
    public Class<RecordRecord> getRecordType() {
        return RecordRecord.class;
    }

    private Record(Name alias, Table<RecordRecord> aliased) {
        this(alias, aliased, null);
    }

    private Record(Name alias, Table<RecordRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment(""), TableOptions.table());
    }

    public Record(String alias) {
        this(DSL.name(alias), RECORD);
    }

    public Record(Name alias) {
        this(alias, RECORD);
    }

    public Record() {
        this(DSL.name("record"), (Table<RecordRecord>)null);
    }

    public <O extends org.jooq.Record> Record(Table<O> child, ForeignKey<O, RecordRecord> key) {
        super(child, key, RECORD);
    }

    @Override
    public Schema getSchema() {
        return this.aliased() ? null : DefaultSchema.DEFAULT_SCHEMA;
    }

    @Override
    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.RECORD_RECORD_DATE);
    }

    @Override
    public Identity<RecordRecord, Long> getIdentity() {
        return super.getIdentity();
    }

    @Override
    public UniqueKey<RecordRecord> getPrimaryKey() {
        return Keys.KEY_RECORD_PRIMARY;
    }

    @Override
    public List<ForeignKey<RecordRecord, ?>> getReferences() {
        return Arrays.asList(Keys.RECORD_CATEGORY_ID, Keys.RECORD_DOCUMENT_ID, Keys.RECORD_ATTACHMENT_ID);
    }

    public RecordCategory recordCategory() {
        if (this._recordCategory == null) {
            this._recordCategory = new RecordCategory(this, Keys.RECORD_CATEGORY_ID);
        }
        return this._recordCategory;
    }

    public Document document() {
        if (this._document == null) {
            this._document = new Document(this, Keys.RECORD_DOCUMENT_ID);
        }
        return this._document;
    }

    public Attachment attachment() {
        if (this._attachment == null) {
            this._attachment = new Attachment(this, Keys.RECORD_ATTACHMENT_ID);
        }
        return this._attachment;
    }

    @Override
    public List<Check<RecordRecord>> getChecks() {
        return Arrays.asList(Internal.createCheck(this, DSL.name("taxes"), "json_valid(`taxes`)", true));
    }

    @Override
    public Record as(String alias) {
        return new Record(DSL.name(alias), this);
    }

    @Override
    public Record as(Name alias) {
        return new Record(alias, this);
    }

    public Record as(Table<?> alias) {
        return new Record(alias.getQualifiedName(), this);
    }

    public Record rename(String name) {
        return new Record(DSL.name(name), null);
    }

    public Record rename(Name name) {
        return new Record(name, null);
    }

    public Record rename(Table<?> name) {
        return new Record(name.getQualifiedName(), null);
    }

    @Override
    public Row9<Long, LocalDate, Long, BigDecimal, BigDecimal, JSON, String, Long, Long> fieldsRow() {
        return (Row9)super.fieldsRow();
    }

    public <U> SelectField<U> mapping(Function9<? super Long, ? super LocalDate, ? super Long, ? super BigDecimal, ? super BigDecimal, ? super JSON, ? super String, ? super Long, ? super Long, ? extends U> from) {
        return this.convertFrom(Records.mapping(from));
    }

    public <U> SelectField<U> mapping(Class<U> toType, Function9<? super Long, ? super LocalDate, ? super Long, ? super BigDecimal, ? super BigDecimal, ? super JSON, ? super String, ? super Long, ? super Long, ? extends U> from) {
        return this.convertFrom(toType, Records.mapping(from));
    }
}

