/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.migrations;

import de.inahware.edvj.sql.Migration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class M000014CreateDiscount
extends Migration {
    @Override
    public void run(DSLContext dsl) {
        dsl.createTable("discount").column("id", SQLDataType.BIGINT.identity(true)).column("begin", SQLDataType.DATE).column("end", SQLDataType.DATE).column("customer_id", SQLDataType.BIGINT).column("article_group_id", SQLDataType.BIGINT).column("article_id", SQLDataType.BIGINT).column("discount", SQLDataType.DECIMAL(18, 2).notNull()).column("description", SQLDataType.CLOB.notNull()).primaryKey("id").constraints(DSL.constraint("discount-customer_id").foreignKey("customer_id").references("customer", "id").onUpdateRestrict().onDeleteCascade(), DSL.constraint("discount-article_group_id").foreignKey("article_group_id").references("article_group", "id").onUpdateRestrict().onDeleteCascade(), DSL.constraint("discount-article_id").foreignKey("article_id").references("article", "id").onUpdateRestrict().onDeleteCascade()).execute();
        dsl.createIndex("discount-begin-end").on("discount", "begin", "end").execute();
        dsl.createIndex("discount-end").on("discount", "end").execute();
        dsl.createIndex("discount-customer_id").on("discount", "customer_id").execute();
        dsl.createIndex("discount-article_group_id").on("discount", "article_group_id").execute();
        dsl.createIndex("discount-article_id").on("discount", "article_id").execute();
        dsl.createView("discount_view", "id", "begin", "end", "customer_id", "article_group_id", "article_id", "discount", "description", "customer_number", "customer_salutation", "customer_prefix", "customer_first_name", "customer_last_name", "customer_company", "article_number", "article_title").as(dsl.select(DSL.table("discount").asterisk(), DSL.field("customer.number").as("customer_number"), DSL.field("customer.salutation").as("customer_salutation"), DSL.field("customer.prefix").as("customer_prefix"), DSL.field("customer.first_name").as("customer_first_name"), DSL.field("customer.last_name").as("customer_last_name"), DSL.field("customer.company").as("customer_company"), DSL.field("article.number").as("article_number"), DSL.field("article.title").as("article_title")).from("discount").leftOuterJoin("customer").on(DSL.field("discount.customer_id").eq(DSL.field("customer.id"))).leftOuterJoin("article").on(DSL.field("discount.article_id").eq(DSL.field("article.id")))).execute();
    }
}

