/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.migrations;

import de.inahware.edvj.sql.Migration;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class M000016CreateDocument
extends Migration {
    @Override
    public void run(DSLContext dsl) {
        dsl.createTable("document").column("id", SQLDataType.BIGINT.identity(true)).column("number", SQLDataType.VARCHAR(64).notNull()).column("type", SQLDataType.VARCHAR(64).notNull()).column("state", SQLDataType.VARCHAR(64).notNull()).column("date", SQLDataType.DATE.notNull()).column("due_date", SQLDataType.DATE).column("service_type", SQLDataType.VARCHAR(64)).column("service_date1", SQLDataType.DATE).column("service_date2", SQLDataType.DATE).column("user_id", SQLDataType.BIGINT).column("customer_id", SQLDataType.BIGINT).column("vendor_id", SQLDataType.BIGINT).column("salutation", SQLDataType.VARCHAR(64)).column("prefix", SQLDataType.VARCHAR(255).notNull()).column("first_name", SQLDataType.VARCHAR(255).notNull()).column("last_name", SQLDataType.VARCHAR(255).notNull()).column("company", SQLDataType.VARCHAR(255).notNull()).column("address1", SQLDataType.VARCHAR(255).notNull()).column("address2", SQLDataType.VARCHAR(255).notNull()).column("country", SQLDataType.CHAR(2).notNull()).column("reference_number", SQLDataType.VARCHAR(255).notNull()).column("text", SQLDataType.CLOB.notNull()).column("taxation", SQLDataType.VARCHAR(64).notNull()).column("partial_price", SQLDataType.DECIMAL(18, 2)).column("total_price", SQLDataType.DECIMAL(18, 2)).column("remaining_price", SQLDataType.DECIMAL(18, 2)).column("attachment_id", SQLDataType.BIGINT).column("headless_attachment_id", SQLDataType.BIGINT).column("printed", SQLDataType.BIGINT.notNull()).primaryKey("id").constraints(DSL.constraint("document-user_id").foreignKey("user_id").references("user", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("document-customer_id").foreignKey("customer_id").references("customer", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("document-vendor_id").foreignKey("vendor_id").references("vendor", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("document-attachment_id").foreignKey("attachment_id").references("attachment", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("document-headless_attachment_id").foreignKey("headless_attachment_id").references("attachment", "id").onUpdateRestrict().onDeleteSetNull()).execute();
        dsl.createUniqueIndex("document-number").on("document", "number").execute();
        dsl.createIndex("document-type").on("document", "type").execute();
        dsl.createIndex("document-state").on("document", "state").execute();
        dsl.createIndex("document-date").on("document", "date").execute();
        dsl.createIndex("document-user_id").on("document", "user_id").execute();
        dsl.createIndex("document-customer_id").on("document", "customer_id").execute();
        dsl.createIndex("document-vendor_id").on("document", "vendor_id").execute();
        dsl.createIndex("document-attachment_id").on("document", "attachment_id").execute();
        dsl.createIndex("document-headless_attachment_id").on("document", "headless_attachment_id").execute();
        dsl.createTable("line_item").column("id", SQLDataType.BIGINT.identity(true)).column("document_id", SQLDataType.BIGINT.notNull()).column("row", SQLDataType.BIGINT.notNull()).column("state", SQLDataType.VARCHAR(64)).column("prev_document_id", SQLDataType.BIGINT).column("prev_line_item_id", SQLDataType.BIGINT).column("next_document_id", SQLDataType.BIGINT).column("next_line_item_id", SQLDataType.BIGINT).column("article_id", SQLDataType.BIGINT).column("article_number", SQLDataType.VARCHAR(64)).column("vendors_article_number", SQLDataType.VARCHAR(64)).column("article_title", SQLDataType.VARCHAR(255).notNull()).column("price", SQLDataType.DECIMAL(18, 2).notNull()).column("unit", SQLDataType.VARCHAR(64).notNull()).column("tax_rate_id", SQLDataType.BIGINT.notNull()).column("amount", SQLDataType.DECIMAL(18, 2).notNull()).column("discount", SQLDataType.DECIMAL(18, 2).notNull()).column("text", SQLDataType.CLOB.notNull()).primaryKey("id").constraints(DSL.constraint("line_item-document_id").foreignKey("document_id").references("document", "id").onUpdateRestrict().onDeleteCascade(), DSL.constraint("line_item-prev_document_id").foreignKey("prev_document_id").references("document", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("line_item-prev_line_item_id").foreignKey("prev_line_item_id").references("line_item", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("line_item-next_document_id").foreignKey("next_document_id").references("document", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("line_item-next_line_item_id").foreignKey("next_line_item_id").references("line_item", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("line_item-article_id").foreignKey("article_id").references("article", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("line_item-tax_rate_id").foreignKey("tax_rate_id").references("tax_rate", "id").onUpdateRestrict().onDeleteRestrict()).execute();
        dsl.createIndex("line_item-document_id-row").on("line_item", "document_id", "row").execute();
        dsl.createIndex("line_item-prev_line_item_id").on("line_item", "prev_line_item_id").execute();
        dsl.createIndex("line_item-prev_document_id").on("line_item", "prev_document_id").execute();
        dsl.createIndex("line_item-next_line_item_id").on("line_item", "next_line_item_id").execute();
        dsl.createIndex("line_item-next_document_id").on("line_item", "next_document_id").execute();
        dsl.createIndex("line_item-article_id").on("line_item", "article_id").execute();
        dsl.createIndex("line_item-tax_rate_id").on("line_item", "tax_rate_id").execute();
        dsl.createView("document_view", "id", "number", "type", "state", "date", "due_date", "service_type", "service_date1", "service_date2", "user_id", "customer_id", "vendor_id", "salutation", "prefix", "first_name", "last_name", "company", "address1", "address2", "country", "reference_number", "text", "taxation", "partial_price", "total_price", "remaining_price", "attachment_id", "headless_attachment_id", "printed", "customer_number", "customer_salutation", "customer_prefix", "customer_first_name", "customer_last_name", "customer_company", "vendor_number", "vendor_salutation", "vendor_prefix", "vendor_first_name", "vendor_last_name", "vendor_company").as(dsl.select(DSL.table("document").asterisk(), DSL.field("customer.number").as("customer_number"), DSL.field("customer.salutation").as("customer_salutation"), DSL.field("customer.prefix").as("customer_prefix"), DSL.field("customer.first_name").as("customer_first_name"), DSL.field("customer.last_name").as("customer_last_name"), DSL.field("customer.company").as("customer_company"), DSL.field("vendor.number").as("vendor_number"), DSL.field("vendor.salutation").as("vendor_salutation"), DSL.field("vendor.prefix").as("vendor_prefix"), DSL.field("vendor.first_name").as("vendor_first_name"), DSL.field("vendor.last_name").as("vendor_last_name"), DSL.field("vendor.company").as("vendor_company")).from("document").leftOuterJoin("customer").on(DSL.field("document.customer_id").eq(DSL.field("customer.id"))).leftOuterJoin("vendor").on(DSL.field("document.vendor_id").eq(DSL.field("vendor.id")))).execute();
        dsl.createTable("document_document").column("parent_document_id", SQLDataType.BIGINT.notNull()).column("child_document_id", SQLDataType.BIGINT.notNull()).primaryKey("parent_document_id", "child_document_id").constraints(DSL.constraint("document_document-parent_document_id").foreignKey("parent_document_id").references("document", "id").onUpdateRestrict().onDeleteCascade(), DSL.constraint("document_document-child_document_id").foreignKey("child_document_id").references("document", "id").onUpdateRestrict().onDeleteCascade()).execute();
        dsl.createIndex("document_document-child_document_id").on("document_document", "child_document_id").execute();
        dsl.createTable("order_document").column("order_id", SQLDataType.BIGINT.notNull()).column("document_id", SQLDataType.BIGINT.notNull()).primaryKey("order_id", "document_id").constraints(DSL.constraint("order_document-order_id").foreignKey("order_id").references("order", "id").onUpdateRestrict().onDeleteRestrict(), DSL.constraint("order_document-document_id").foreignKey("document_id").references("document", "id").onUpdateRestrict().onDeleteCascade()).execute();
        dsl.createIndex("order_document-document_id").on("order_document", "document_id").execute();
        dsl.createView("order_document_view", "order_id", "document_id", "id", "number", "type", "state", "date", "due_date", "service_type", "service_date1", "service_date2", "user_id", "customer_id", "vendor_id", "salutation", "prefix", "first_name", "last_name", "company", "address1", "address2", "country", "reference_number", "text", "taxation", "partial_price", "total_price", "remaining_price", "attachment_id", "headless_attachment_id", "printed", "customer_number", "customer_salutation", "customer_prefix", "customer_first_name", "customer_last_name", "customer_company", "vendor_number", "vendor_salutation", "vendor_prefix", "vendor_first_name", "vendor_last_name", "vendor_company").as(dsl.select(DSL.table("order_document").asterisk(), DSL.table("document").asterisk(), DSL.field("customer.number").as("customer_number"), DSL.field("customer.salutation").as("customer_salutation"), DSL.field("customer.prefix").as("customer_prefix"), DSL.field("customer.first_name").as("customer_first_name"), DSL.field("customer.last_name").as("customer_last_name"), DSL.field("customer.company").as("customer_company"), DSL.field("vendor.number").as("vendor_number"), DSL.field("vendor.salutation").as("vendor_salutation"), DSL.field("vendor.prefix").as("vendor_prefix"), DSL.field("vendor.first_name").as("vendor_first_name"), DSL.field("vendor.last_name").as("vendor_last_name"), DSL.field("vendor.company").as("vendor_company")).from("order_document").innerJoin("document").on(DSL.field("order_document.document_id").eq(DSL.field("document.id"))).leftOuterJoin("customer").on(DSL.field("document.customer_id").eq(DSL.field("customer.id"))).leftOuterJoin("vendor").on(DSL.field("document.vendor_id").eq(DSL.field("vendor.id")))).execute();
        dsl.createTable("deduction").column("id", SQLDataType.BIGINT.identity(true)).column("document_id", SQLDataType.BIGINT.notNull()).column("row", SQLDataType.BIGINT.notNull()).column("partial_document_id", SQLDataType.BIGINT).column("title", SQLDataType.VARCHAR(255).notNull()).column("price", SQLDataType.DECIMAL(18, 2).notNull()).column("tax_rate_id", SQLDataType.BIGINT.notNull()).primaryKey("id").constraints(DSL.constraint("deduction-document_id").foreignKey("document_id").references("document", "id").onUpdateRestrict().onDeleteCascade(), DSL.constraint("deduction-partial_document_id").foreignKey("partial_document_id").references("document", "id").onUpdateRestrict().onDeleteSetNull(), DSL.constraint("deduction-tax_rate_id").foreignKey("tax_rate_id").references("tax_rate", "id").onUpdateRestrict().onDeleteRestrict()).execute();
        dsl.createIndex("deduction-document_id-row").on("deduction", "document_id", "row").execute();
        dsl.createIndex("deduction-partial_document_id").on("deduction", "partial_document_id").execute();
        dsl.createIndex("deduction-tax_rate_id").on("deduction", "tax_rate_id").execute();
    }
}

