/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Address
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.ADDRESS.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<Long> COL_CUSTOMER_ID = new SQLColumn(Tables.ADDRESS.CUSTOMER_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_VENDOR_ID = new SQLColumn(Tables.ADDRESS.VENDOR_ID, new ColumnFlag[0]);
    public static final SQLConvertColumn<Boolean, Byte> COL_DEFAULT_ADDRESS = new SQLConvertColumn(Boolean.class, Tables.ADDRESS.DEFAULT_ADDRESS, new ColumnFlag[0]);
    public static final SQLConvertColumn<Boolean, Byte> COL_DEFAULT_SHIPPING_ADDRESS = new SQLConvertColumn(Boolean.class, Tables.ADDRESS.DEFAULT_SHIPPING_ADDRESS, new ColumnFlag[0]);
    public static final SQLConvertColumn<Salutation, String> COL_SALUTATION = new SQLConvertColumn(Salutation.class, Tables.ADDRESS.SALUTATION, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_PREFIX = new SQLColumn(Tables.ADDRESS.PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_FIRST_NAME = new SQLColumn(Tables.ADDRESS.FIRST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_LAST_NAME = new SQLColumn(Tables.ADDRESS.LAST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COMPANY = new SQLColumn(Tables.ADDRESS.COMPANY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COUNTRY = new SQLColumn(Tables.ADDRESS.COUNTRY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS1 = new SQLColumn(Tables.ADDRESS.ADDRESS1, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS2 = new SQLColumn(Tables.ADDRESS.ADDRESS2, new ColumnFlag[0]);
    public static final DataModel<Address> MODEL = new DataModel<Address>(Address.class).with(COL_ID, Address::getId, Address::setId).with(COL_CUSTOMER_ID, Address::getCustomerId, Address::setCustomerId).with(COL_VENDOR_ID, Address::getVendorId, Address::setVendorId).with(COL_DEFAULT_ADDRESS, Address::isDefaultAddress, Address::setDefaultAddress).with(COL_DEFAULT_SHIPPING_ADDRESS, Address::isDefaultShippingAddress, Address::setDefaultShippingAddress).with(COL_SALUTATION, Address::getSalutation, Address::setSalutation).with(COL_PREFIX, Address::getPrefix, Address::setPrefix).with(COL_FIRST_NAME, Address::getFirstName, Address::setFirstName).with(COL_LAST_NAME, Address::getLastName, Address::setLastName).with(COL_COMPANY, Address::getCompany, Address::setCompany).with(COL_COUNTRY, Address::getCountry, Address::setCountry).with(COL_ADDRESS1, Address::getAddress1, Address::setAddress1).with(COL_ADDRESS2, Address::getAddress2, Address::setAddress2);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withScope(MODEL.getName()).withUpdatableColumns(COL_DEFAULT_ADDRESS, COL_DEFAULT_SHIPPING_ADDRESS, COL_SALUTATION, COL_PREFIX, COL_FIRST_NAME, COL_LAST_NAME, COL_COMPANY, COL_COUNTRY, COL_ADDRESS1, COL_ADDRESS2);
    private Long id;
    private Long customerId;
    private Long vendorId;
    private Boolean defaultAddress = false;
    private Boolean defaultShippingAddress = false;
    private Salutation salutation;
    private String prefix = "";
    private String firstName = "";
    private String lastName = "";
    private String company = "";
    private String country = Locale.getDefault().getCountry();
    private String address1 = "";
    private String address2 = "";

    public Address() {
    }

    public Address(Address obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(Long vendorId) {
        this.vendorId = vendorId;
    }

    public Boolean isDefaultAddress() {
        return this.defaultAddress;
    }

    public void setDefaultAddress(Boolean defaultAddress) {
        this.defaultAddress = defaultAddress;
    }

    public Boolean isDefaultShippingAddress() {
        return this.defaultShippingAddress;
    }

    public void setDefaultShippingAddress(Boolean defaultShippingAddress) {
        this.defaultShippingAddress = defaultShippingAddress;
    }

    public Salutation getSalutation() {
        return this.salutation;
    }

    public void setSalutation(Salutation salutation) {
        this.salutation = salutation;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public void validate() throws Exception {
        if (!(this.getSalutation() != null || this.getPrefix().isEmpty() && this.getFirstName().isEmpty() && this.getLastName().isEmpty())) {
            throw new ValidationException();
        }
        if (this.getSalutation() != null && (this.getFirstName().isEmpty() || this.getLastName().isEmpty())) {
            throw new ValidationException("Address.errors.name_empty");
        }
        if (this.getSalutation() == null && this.getCompany().isEmpty()) {
            throw new ValidationException("Address.errors.salutation_or_company_required");
        }
    }

    public String getDisplayString(ResourceBundle bundle) {
        String name = Stream.of(this.salutation.getDisplayName(bundle), this.prefix, this.firstName, this.lastName).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
        return Stream.of(this.company, name, this.address1, this.address2, this.country).filter(s -> !s.isEmpty()).collect(Collectors.joining(" / "));
    }
}

