/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Models;
import de.inahware.dav.models.types.ArticlePrice;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.util.ArrayList;
import java.util.List;
import org.jooq.JSON;

public class Article
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.ARTICLE.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<String> COL_NUMBER = new SQLColumn(Tables.ARTICLE.NUMBER, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ARTICLE_GROUP_ID = new SQLColumn(Tables.ARTICLE.ARTICLE_GROUP_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TITLE = new SQLColumn(Tables.ARTICLE.TITLE, new ColumnFlag[0]);
    public static final SQLConvertColumn<String, JSON> COL_PRICES = new SQLConvertColumn(String.class, Tables.ARTICLE.PRICES, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_UNIT = new SQLColumn(Tables.ARTICLE.UNIT, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_TAX_RATE_ID = new SQLColumn(Tables.ARTICLE.TAX_RATE_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_DESCRIPTION = new SQLColumn(Tables.ARTICLE.DESCRIPTION, new ColumnFlag[0]);
    public static final DataModel<Article> MODEL = new DataModel<Article>(Article.class).with(COL_ID, Article::getId, Article::setId).with(COL_NUMBER, Article::getNumber, Article::setNumber).with(COL_ARTICLE_GROUP_ID, Article::getArticleGroupId, Article::setArticleGroupId).with(COL_TITLE, Article::getTitle, Article::setTitle).with(COL_PRICES, Article::getPrices, Article::setPrices).with(COL_UNIT, Article::getUnit, Article::setUnit).with(COL_TAX_RATE_ID, Article::getTaxRateId, Article::setTaxRate).with(COL_DESCRIPTION, Article::getDescription, Article::setDescription);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_NUMBER, COL_ARTICLE_GROUP_ID, COL_TITLE, COL_PRICES, COL_UNIT, COL_TAX_RATE_ID, COL_DESCRIPTION);
    private Long id;
    private String number;
    private Long articleGroupId;
    private String title;
    private String prices = "[]";
    private String unit;
    private Long taxRateId;
    private String description;

    public Article() {
    }

    public Article(Article obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getArticleGroupId() {
        return this.articleGroupId;
    }

    public void setArticleGroupId(Long group) {
        this.articleGroupId = group;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected String getPrices() {
        return this.prices;
    }

    protected void setPrices(String prices) {
        this.prices = prices;
    }

    public ArrayList<ArticlePrice> getPriceList() {
        try {
            return Models.MAPPER.readValue(this.prices, new TypeReference<ArrayList<ArticlePrice>>(){});
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setPriceList(List<ArticlePrice> contact) {
        try {
            this.prices = Models.MAPPER.writeValueAsString(contact);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.prices = null;
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getTaxRateId() {
        return this.taxRateId;
    }

    public void setTaxRate(Long taxRateId) {
        this.taxRateId = taxRateId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        if (this.getNumber() == null || this.getNumber().isEmpty()) {
            return this.getTitle();
        }
        return this.getNumber() + " - " + this.getTitle();
    }

    public void validate() throws Exception {
        if (this.getTitle().isEmpty()) {
            throw new ValidationException("Article.errors.title_empty");
        }
        try {
            this.getPriceList();
        }
        catch (Exception ex) {
            throw new ValidationException();
        }
    }
}

