/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.query.Queryable;
import de.inahware.edvj.query.SelectAll;
import de.inahware.edvj.sql.SQLColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class ArticleGroup
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.ARTICLE_GROUP.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<Long> COL_PARENT_ID = new SQLColumn(Tables.ARTICLE_GROUP.PARENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TITLE = new SQLColumn(Tables.ARTICLE_GROUP.TITLE, new ColumnFlag[0]);
    public static final DataModel<ArticleGroup> MODEL = new DataModel<ArticleGroup>(ArticleGroup.class).with(COL_ID, ArticleGroup::getId, ArticleGroup::setId).with(COL_PARENT_ID, ArticleGroup::getParentId, ArticleGroup::setParentId).with(COL_TITLE, ArticleGroup::getTitle, ArticleGroup::setTitle);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_PARENT_ID, COL_TITLE);
    private Long id;
    private Long parentId;
    private String title;

    public ArticleGroup() {
    }

    public ArticleGroup(ArticleGroup obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void validate() throws Exception {
        if (this.getId() == 1L ? this.getParentId() != null || this.getTitle() != null : this.getParentId() == null || this.getTitle() == null) {
            throw new ValidationException();
        }
    }

    public static Map<Long, ArticleGroup> getArticleGroupMap(Queryable client) throws Exception {
        HashMap<Long, ArticleGroup> res = new HashMap<Long, ArticleGroup>();
        for (ArticleGroup group : (ArrayList)((Object)client.query(new SelectAll<ArticleGroup>(MODEL)))) {
            res.put(group.getId(), group);
        }
        return res;
    }

    public static String getArticleGroupPath(ResourceBundle bundle, Map<Long, ArticleGroup> map, Long group) {
        return ArticleGroup.getArticleGroupPath(bundle, map, map.get(group));
    }

    public static String getArticleGroupPath(ResourceBundle bundle, Map<Long, ArticleGroup> map, ArticleGroup group) {
        Object res = group.getTitle();
        while (group.getParentId() != null) {
            group = map.get(group.getParentId());
            res = group.getTitle() + " / " + (String)res;
        }
        return res;
    }
}

