/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Models;
import de.inahware.dav.models.types.ArticlePrice;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.util.ArrayList;
import java.util.List;
import org.jooq.JSON;

public class ArticleVendor
extends DataObject {
    public static final SQLColumn<Long> COL_ARTICLE_ID = new SQLColumn(Tables.ARTICLE_VENDOR.ARTICLE_ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<Long> COL_VENDOR_ID = new SQLColumn(Tables.ARTICLE_VENDOR.VENDOR_ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<String> COL_VENDORS_ARTICLE_NUMBER = new SQLColumn(Tables.ARTICLE_VENDOR.VENDORS_ARTICLE_NUMBER, new ColumnFlag[0]);
    public static final SQLConvertColumn<String, JSON> COL_PRICES = new SQLConvertColumn(String.class, Tables.ARTICLE.PRICES, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COMMENT = new SQLColumn(Tables.ARTICLE_VENDOR.COMMENT, new ColumnFlag[0]);
    public static final DataModel<ArticleVendor> MODEL = new DataModel<ArticleVendor>(ArticleVendor.class).with(COL_ARTICLE_ID, ArticleVendor::getArticleId, ArticleVendor::setArticleId).with(COL_VENDOR_ID, ArticleVendor::getVendorId, ArticleVendor::setVendorId).with(COL_VENDORS_ARTICLE_NUMBER, ArticleVendor::getVendorsArticleNumber, ArticleVendor::setVendorsArticleNumber).with(COL_PRICES, ArticleVendor::getPrices, ArticleVendor::setPrices).with(COL_COMMENT, ArticleVendor::getComment, ArticleVendor::setComment);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_VENDORS_ARTICLE_NUMBER, COL_PRICES, COL_COMMENT);
    private Long articleId;
    private Long vendorId;
    private String vendorsArticleNumber;
    private String prices = "[]";
    private String comment;

    public ArticleVendor() {
        this.setPriceList(List.of());
    }

    public ArticleVendor(Long articleId, Long vendorId) {
        this.setArticleId(articleId);
        this.setVendorId(vendorId);
        this.setPriceList(List.of());
    }

    public ArticleVendor(ArticleVendor obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getArticleId() {
        return this.articleId;
    }

    public void setArticleId(Long articleId) {
        this.articleId = articleId;
    }

    public Long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(Long vendorId) {
        this.vendorId = vendorId;
    }

    public String getVendorsArticleNumber() {
        return this.vendorsArticleNumber;
    }

    public void setVendorsArticleNumber(String vendorsArticleNumber) {
        this.vendorsArticleNumber = vendorsArticleNumber;
    }

    protected String getPrices() {
        return this.prices;
    }

    protected void setPrices(String prices) {
        this.prices = prices;
    }

    public ArrayList<ArticlePrice> getPriceList() {
        try {
            return Models.MAPPER.readValue(this.prices, new TypeReference<ArrayList<ArticlePrice>>(){});
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setPriceList(List<ArticlePrice> contact) {
        try {
            this.prices = Models.MAPPER.writeValueAsString(contact);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.prices = null;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void validate() throws Exception {
        try {
            this.getPriceList();
        }
        catch (Exception ex) {
            throw new ValidationException();
        }
    }
}

