/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.types.AttachmentObjectType;
import de.inahware.dav.models.types.AttachmentType;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.nio.file.Path;

public class Attachment
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.ATTACHMENT.ID, ColumnFlag.PRIMARY);
    public static final SQLConvertColumn<AttachmentObjectType, String> COL_OBJECT_TYPE = new SQLConvertColumn(AttachmentObjectType.class, Tables.ATTACHMENT.OBJECT_TYPE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_OBJECT_ID = new SQLColumn(Tables.ATTACHMENT.OBJECT_ID, new ColumnFlag[0]);
    public static final SQLConvertColumn<AttachmentType, String> COL_TYPE = new SQLConvertColumn(AttachmentType.class, Tables.ATTACHMENT.TYPE, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SUBTYPE = new SQLColumn(Tables.ATTACHMENT.SUBTYPE, new ColumnFlag[0]);
    public static final SQLConvertColumn<Boolean, Byte> COL_HIDDEN = new SQLConvertColumn(Boolean.class, Tables.ATTACHMENT.HIDDEN, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_REF_COUNT = new SQLColumn(Tables.ATTACHMENT.REF_COUNT, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_LOCK_COUNT = new SQLColumn(Tables.ATTACHMENT.LOCK_COUNT, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TITLE = new SQLColumn(Tables.ATTACHMENT.TITLE, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TEXT = new SQLColumn(Tables.ATTACHMENT.TEXT, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_FILENAME = new SQLColumn(Tables.ATTACHMENT.FILENAME, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_FILESIZE = new SQLColumn(Tables.ATTACHMENT.FILESIZE, new ColumnFlag[0]);
    public static final DataModel<Attachment> MODEL = new DataModel<Attachment>(Attachment.class).with(COL_ID, Attachment::getId, Attachment::setId).with(COL_OBJECT_TYPE, Attachment::getObjectType, Attachment::setObjectType).with(COL_OBJECT_ID, Attachment::getObjectId, Attachment::setObjectId).with(COL_TYPE, Attachment::getType, Attachment::setType).with(COL_SUBTYPE, Attachment::getSubtype, Attachment::setSubtype).with(COL_HIDDEN, Attachment::isHidden, Attachment::setHidden).with(COL_REF_COUNT, Attachment::getRefCount, Attachment::setRefCount).with(COL_LOCK_COUNT, Attachment::getLockCount, Attachment::setLockCount).with(COL_TITLE, Attachment::getTitle, Attachment::setTitle).with(COL_TEXT, Attachment::getText, Attachment::setText).with(COL_FILENAME, Attachment::getFilename, Attachment::setFilename).with(COL_FILESIZE, Attachment::getFilesize, Attachment::setFilesize);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withInsertLimit(1).withUpdatableColumns(COL_SUBTYPE, COL_HIDDEN, COL_TITLE, COL_TEXT, COL_FILENAME, COL_FILESIZE);
    private Long id;
    private AttachmentObjectType objectType;
    private Long objectId;
    private AttachmentType type;
    private String subtype;
    private Boolean hidden = false;
    private Long refCount = 0L;
    private Long lockCount = 0L;
    private String title = "";
    private String text = "";
    private String filename;
    private Long filesize;

    public Attachment() {
    }

    public Attachment(AttachmentObjectType objectType, Long objectId, AttachmentType type) {
        this(objectType, objectId, type, null);
    }

    public Attachment(AttachmentObjectType objectType, Long objectId, AttachmentType type, String subtype) {
        this(objectType, objectId, type, subtype, false);
    }

    public Attachment(AttachmentObjectType objectType, Long objectId, AttachmentType type, String subtype, boolean hidden) {
        this(objectType, objectId, type, subtype, hidden, "");
    }

    public Attachment(AttachmentObjectType objectType, Long objectId, AttachmentType type, String subtype, boolean hidden, String title) {
        this();
        this.setObjectType(objectType);
        this.setObjectId(objectId);
        this.setType(type);
        this.setSubtype(subtype);
        this.setHidden(hidden);
        this.setTitle(title);
    }

    public Attachment(Attachment obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AttachmentObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(AttachmentObjectType objectType) {
        this.objectType = objectType;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public AttachmentType getType() {
        return this.type;
    }

    public void setType(AttachmentType type) {
        this.type = type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Long getRefCount() {
        return this.refCount;
    }

    public void setRefCount(Long refCount) {
        this.refCount = refCount;
    }

    public Long getLockCount() {
        return this.lockCount;
    }

    public void setLockCount(Long lockCount) {
        this.lockCount = lockCount;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(Long filesize) {
        this.filesize = filesize;
    }

    public Path getPath() {
        long id = this.getId();
        Path path = Path.of(String.format("%020d", id), new String[0]);
        long rest = id / 1000L;
        for (int i = 0; i < 5; ++i) {
            path = Path.of(String.format("%03d", rest % 1000L), new String[0]).resolve(path);
            rest /= 1000L;
        }
        path = Path.of(String.format("%02d", rest), new String[0]).resolve(path);
        return Path.of("attachments", new String[0]).resolve(path);
    }
}

