/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;

public class Counter
extends DataObject {
    public static final SQLColumn<String> COL_NAME = new SQLColumn(Tables.COUNTER.NAME, ColumnFlag.PRIMARY);
    public static final SQLColumn<String> COL_PREFIX = new SQLColumn(Tables.COUNTER.PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<Byte> COL_LENGTH = new SQLColumn(Tables.COUNTER.LENGTH, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SUFFIX = new SQLColumn(Tables.COUNTER.SUFFIX, new ColumnFlag[0]);
    public static final SQLConvertColumn<Boolean, Byte> COL_RESET_ON_PREFIX_CHANGE = new SQLConvertColumn(Boolean.class, Tables.COUNTER.RESET_ON_PREFIX_CHANGE, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_LAST_PREFIX = new SQLColumn(Tables.COUNTER.LAST_PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_COUNT = new SQLColumn(Tables.COUNTER.COUNT, new ColumnFlag[0]);
    public static final DataModel<Counter> MODEL = new DataModel<Counter>(Counter.class).with(COL_NAME, Counter::getName, Counter::setName).with(COL_PREFIX, Counter::getPrefix, Counter::setPrefix).with(COL_LENGTH, Counter::getLength, Counter::setLength).with(COL_SUFFIX, Counter::getSuffix, Counter::setSuffix).with(COL_RESET_ON_PREFIX_CHANGE, Counter::getResetOnPrefixChange, Counter::setResetOnPrefixChange).with(COL_LAST_PREFIX, Counter::getLastPrefix, Counter::setLastPrefix).with(COL_COUNT, Counter::getCount, Counter::setCount);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_PREFIX, COL_LENGTH, COL_SUFFIX, COL_RESET_ON_PREFIX_CHANGE, COL_COUNT);
    private String name;
    private String prefix;
    private Byte length;
    private String suffix = "";
    private Boolean resetOnPrefixChange = true;
    private String lastPrefix;
    private Long count = 1L;

    public Counter() {
    }

    public Counter(Counter obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Byte getLength() {
        return this.length;
    }

    public void setLength(Byte length) {
        this.length = length;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Boolean getResetOnPrefixChange() {
        return this.resetOnPrefixChange;
    }

    public void setResetOnPrefixChange(Boolean resetOnPrefixChange) {
        this.resetOnPrefixChange = resetOnPrefixChange;
    }

    public String getLastPrefix() {
        return this.lastPrefix;
    }

    public void setLastPrefix(String lastPrefix) {
        this.lastPrefix = lastPrefix;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public String renderPrefix() {
        return this.prefix;
    }

    public String generateNext() {
        String nextPrefix = this.renderPrefix();
        if (this.resetOnPrefixChange.booleanValue() && this.lastPrefix != null && !this.lastPrefix.equals(nextPrefix)) {
            this.count = 1L;
        }
        String res = ("%s%0" + this.length + "d%s").formatted(nextPrefix, this.count, this.suffix);
        this.lastPrefix = nextPrefix;
        this.count = this.count + 1L;
        return res;
    }
}

