/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.commons.lang3.compare.ComparableUtils;

public class Discount
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.DISCOUNT.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<LocalDate> COL_BEGIN = new SQLColumn(Tables.DISCOUNT.BEGIN, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_END = new SQLColumn(Tables.DISCOUNT.END, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_CUSTOMER_ID = new SQLColumn(Tables.DISCOUNT.CUSTOMER_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ARTICLE_GROUP_ID = new SQLColumn(Tables.DISCOUNT.ARTICLE_GROUP_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ARTICLE_ID = new SQLColumn(Tables.DISCOUNT.ARTICLE_ID, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_DISCOUNT = new SQLColumn(Tables.DISCOUNT.DISCOUNT_, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_DESCRIPTION = new SQLColumn(Tables.DISCOUNT.DESCRIPTION, new ColumnFlag[0]);
    public static final DataModel<Discount> MODEL = new DataModel<Discount>(Discount.class).with(COL_ID, Discount::getId, Discount::setId).with(COL_BEGIN, Discount::getFrom, Discount::setFrom).with(COL_END, Discount::getUntil, Discount::setUntil).with(COL_CUSTOMER_ID, Discount::getCustomerId, Discount::setCustomerId).with(COL_ARTICLE_GROUP_ID, Discount::getArticleGroupId, Discount::setArticleGroupId).with(COL_ARTICLE_ID, Discount::getArticleId, Discount::setArticleId).with(COL_DISCOUNT, Discount::getDiscount, Discount::setDiscount).with(COL_DESCRIPTION, Discount::getDescription, Discount::setDescription);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_BEGIN, COL_END, COL_CUSTOMER_ID, COL_ARTICLE_GROUP_ID, COL_ARTICLE_ID, COL_DISCOUNT, COL_DESCRIPTION);
    private Long id;
    private LocalDate from;
    private LocalDate until;
    private Long customerId;
    private Long articleGroupId;
    private Long articleId;
    private BigDecimal discount;
    private String description;

    public Discount() {
    }

    public Discount(Discount obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public void setFrom(LocalDate from) {
        this.from = from;
    }

    public LocalDate getUntil() {
        return this.until;
    }

    public void setUntil(LocalDate until) {
        this.until = until;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getArticleGroupId() {
        return this.articleGroupId;
    }

    public void setArticleGroupId(Long articleGroupId) {
        this.articleGroupId = articleGroupId;
    }

    public Long getArticleId() {
        return this.articleId;
    }

    public void setArticleId(Long articleId) {
        this.articleId = articleId;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void validate() throws Exception {
        if (this.getFrom() != null && this.getUntil() != null && this.getFrom().isAfter(this.getUntil())) {
            throw new ValidationException("Discount.errors.from_after_until");
        }
        if (this.getDiscount() != null && !ComparableUtils.between(BigDecimal.ZERO, new BigDecimal(100)).test(this.getDiscount())) {
            throw new ValidationException("Discount.errors.invalid_discount");
        }
    }
}

