/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.types.DocumentServiceType;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.models.types.Taxation;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Locale;

public class Document
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.DOCUMENT.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<String> COL_NUMBER = new SQLColumn(Tables.DOCUMENT.NUMBER, new ColumnFlag[0]);
    public static final SQLConvertColumn<DocumentType, String> COL_TYPE = new SQLConvertColumn(DocumentType.class, Tables.DOCUMENT.TYPE, new ColumnFlag[0]);
    public static final SQLConvertColumn<OrderState, String> COL_STATE = new SQLConvertColumn(OrderState.class, Tables.DOCUMENT.STATE, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_DATE = new SQLColumn(Tables.DOCUMENT.DATE, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_DUE_DATE = new SQLColumn(Tables.DOCUMENT.DUE_DATE, new ColumnFlag[0]);
    public static final SQLConvertColumn<DocumentServiceType, String> COL_SERVICE_TYPE = new SQLConvertColumn(DocumentServiceType.class, Tables.DOCUMENT.SERVICE_TYPE, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_SERVICE_DATE1 = new SQLColumn(Tables.DOCUMENT.SERVICE_DATE1, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_SERVICE_DATE2 = new SQLColumn(Tables.DOCUMENT.SERVICE_DATE2, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_USER_ID = new SQLColumn(Tables.DOCUMENT.USER_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_CUSTOMER_ID = new SQLColumn(Tables.DOCUMENT.CUSTOMER_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_VENDOR_ID = new SQLColumn(Tables.DOCUMENT.VENDOR_ID, new ColumnFlag[0]);
    public static final SQLConvertColumn<Salutation, String> COL_SALUTATION = new SQLConvertColumn(Salutation.class, Tables.DOCUMENT.SALUTATION, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_PREFIX = new SQLColumn(Tables.DOCUMENT.PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_FIRST_NAME = new SQLColumn(Tables.DOCUMENT.FIRST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_LAST_NAME = new SQLColumn(Tables.DOCUMENT.LAST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COMPANY = new SQLColumn(Tables.DOCUMENT.COMPANY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COUNTRY = new SQLColumn(Tables.DOCUMENT.COUNTRY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS1 = new SQLColumn(Tables.DOCUMENT.ADDRESS1, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS2 = new SQLColumn(Tables.DOCUMENT.ADDRESS2, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_REFERENCE_NUMBER = new SQLColumn(Tables.DOCUMENT.REFERENCE_NUMBER, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TEXT = new SQLColumn(Tables.DOCUMENT.TEXT, new ColumnFlag[0]);
    public static final SQLConvertColumn<Taxation, String> COL_TAXATION = new SQLConvertColumn(Taxation.class, Tables.DOCUMENT.TAXATION, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_PARTIAL_PRICE = new SQLColumn(Tables.DOCUMENT.PARTIAL_PRICE, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_TOTAL_PRICE = new SQLColumn(Tables.DOCUMENT.TOTAL_PRICE, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_REMAINING_PRICE = new SQLColumn(Tables.DOCUMENT.REMAINING_PRICE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ATTACHMENT_ID = new SQLColumn(Tables.DOCUMENT.ATTACHMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_HEADLESS_ATTACHMENT_ID = new SQLColumn(Tables.DOCUMENT.HEADLESS_ATTACHMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_PRINTED = new SQLColumn(Tables.DOCUMENT.PRINTED, new ColumnFlag[0]);
    public static final DataModel<Document> MODEL = new DataModel<Document>(Document.class).with(COL_ID, Document::getId, Document::setId).with(COL_NUMBER, Document::getNumber, Document::setNumber).with(COL_TYPE, Document::getType, Document::setType).with(COL_STATE, Document::getState, Document::setState).with(COL_DATE, Document::getDate, Document::setDate).with(COL_SERVICE_TYPE, Document::getServiceType, Document::setServiceType).with(COL_SERVICE_DATE1, Document::getServiceDate1, Document::setServiceDate1).with(COL_SERVICE_DATE2, Document::getServiceDate2, Document::setServiceDate2).with(COL_DUE_DATE, Document::getDueDate, Document::setDueDate).with(COL_USER_ID, Document::getUserId, Document::setUserId).with(COL_CUSTOMER_ID, Document::getCustomerId, Document::setCustomerId).with(COL_VENDOR_ID, Document::getVendorId, Document::setVendorId).with(COL_SALUTATION, Document::getSalutation, Document::setSalutation).with(COL_PREFIX, Document::getPrefix, Document::setPrefix).with(COL_FIRST_NAME, Document::getFirstName, Document::setFirstName).with(COL_LAST_NAME, Document::getLastName, Document::setLastName).with(COL_COMPANY, Document::getCompany, Document::setCompany).with(COL_COUNTRY, Document::getCountry, Document::setCountry).with(COL_ADDRESS1, Document::getAddress1, Document::setAddress1).with(COL_ADDRESS2, Document::getAddress2, Document::setAddress2).with(COL_REFERENCE_NUMBER, Document::getReferenceNumber, Document::setReferenceNumber).with(COL_TEXT, Document::getText, Document::setText).with(COL_TAXATION, Document::getTaxation, Document::setTaxation).with(COL_PARTIAL_PRICE, Document::getPartialPrice, Document::setPartialPrice).with(COL_TOTAL_PRICE, Document::getTotalPrice, Document::setTotalPrice).with(COL_REMAINING_PRICE, Document::getRemainingPrice, Document::setRemainingPrice).with(COL_ATTACHMENT_ID, Document::getAttachmentId, Document::setAttachmentId).with(COL_HEADLESS_ATTACHMENT_ID, Document::getHeadlessAttachmentId, Document::setHeadlessAttachmentId).with(COL_PRINTED, Document::getPrinted, Document::setPrinted);
    private Long id;
    private String number;
    private DocumentType type;
    private OrderState state = OrderState.DRAFT;
    private LocalDate date = LocalDate.now();
    private LocalDate dueDate;
    private DocumentServiceType serviceType;
    private LocalDate serviceDate1;
    private LocalDate serviceDate2;
    private Long userId;
    private Long customerId;
    private Long vendorId;
    private Salutation salutation;
    private String prefix;
    private String firstName;
    private String lastName;
    private String company;
    private String country = Locale.getDefault().getCountry();
    private String address1;
    private String address2;
    private String referenceNumber = "";
    private String text = "";
    private Taxation taxation = Taxation.DEFAULT;
    private BigDecimal partialPrice;
    private BigDecimal totalPrice;
    private BigDecimal remainingPrice;
    private Long attachmentId;
    private Long headlessAttachmentId;
    private Long printed = 0L;

    public Document() {
    }

    public Document(Document obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public DocumentType getType() {
        return this.type;
    }

    public void setType(DocumentType type) {
        this.type = type;
    }

    public OrderState getState() {
        return this.state;
    }

    public void setState(OrderState state) {
        this.state = state;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public DocumentServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(DocumentServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public LocalDate getServiceDate1() {
        return this.serviceDate1;
    }

    public void setServiceDate1(LocalDate serviceDate1) {
        this.serviceDate1 = serviceDate1;
    }

    public LocalDate getServiceDate2() {
        return this.serviceDate2;
    }

    public void setServiceDate2(LocalDate serviceDate2) {
        this.serviceDate2 = serviceDate2;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(Long vendorId) {
        this.vendorId = vendorId;
    }

    public Salutation getSalutation() {
        return this.salutation;
    }

    public void setSalutation(Salutation salutation) {
        this.salutation = salutation;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String customersOrderId) {
        this.referenceNumber = customersOrderId;
    }

    public BigDecimal getPartialPrice() {
        return this.partialPrice;
    }

    public void setPartialPrice(BigDecimal partialPrice) {
        this.partialPrice = partialPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public BigDecimal getRemainingPrice() {
        return this.remainingPrice;
    }

    public void setRemainingPrice(BigDecimal remainingPrice) {
        this.remainingPrice = remainingPrice;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Taxation getTaxation() {
        return this.taxation;
    }

    public void setTaxation(Taxation taxation) {
        this.taxation = taxation;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public Long getHeadlessAttachmentId() {
        return this.headlessAttachmentId;
    }

    public void setHeadlessAttachmentId(Long headlessAttachmentId) {
        this.headlessAttachmentId = headlessAttachmentId;
    }

    public Long getPrinted() {
        return this.printed;
    }

    public void setPrinted(Long printed) {
        this.printed = printed;
    }

    public void validate() throws Exception {
        if (this.date == null) {
            throw new ValidationException("Document.errors.missing_date");
        }
        if (this.type.needsShippingDate() && this.serviceType != DocumentServiceType.SHIPPING_DATE) {
            throw new ValidationException("Document.errors.shippingDate_required");
        }
        if (this.type.needsServiceType() && this.serviceType == null) {
            throw new ValidationException("Document.errors.serviceType_required");
        }
        if (this.serviceType != null) {
            switch (this.serviceType) {
                case SHIPPING_DATE: {
                    if (this.serviceDate1 == null) {
                        throw new ValidationException("Document.errors.missing_shippingDate");
                    }
                    if (this.serviceDate2 == null) break;
                    throw new ValidationException();
                }
                case SERVICE_DATE: {
                    if (this.serviceDate1 == null) {
                        throw new ValidationException("Document.errors.missing_serviceDate");
                    }
                    if (this.serviceDate2 == null) break;
                    throw new ValidationException();
                }
                case SERVICE_PERIOD: {
                    if (this.serviceDate1 != null && this.serviceDate2 != null) break;
                    throw new ValidationException("Document.errors.missing_servicePeriod");
                }
            }
        }
        if (!(this.getSalutation() != null || this.getPrefix().isEmpty() && this.getFirstName().isEmpty() && this.getLastName().isEmpty())) {
            throw new ValidationException();
        }
        if (this.getSalutation() != null && (this.getFirstName().isEmpty() || this.getLastName().isEmpty())) {
            throw new ValidationException("Address.errors.name_empty");
        }
        if (this.getSalutation() == null && this.getCompany().isEmpty()) {
            throw new ValidationException("Address.errors.salutation_or_company_required");
        }
        if (this.getType().isPartialInvoice() && this.getPartialPrice() == null) {
            throw new ValidationException("Document.errors.missing_partialPrice");
        }
        if (this.getPartialPrice() != null && this.getPartialPrice().signum() < 0) {
            throw new ValidationException("Document.errors.partialPrice_negative");
        }
    }
}

