/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Deduction;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.LineItem;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Taxation;
import de.inahware.dav.models.types.TotalPrice;
import de.inahware.edvj.I18N;
import de.inahware.edvj.data.ArrayListColumn;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.jooq.DSLContext;

public class DocumentFull
extends Document {
    public static final ArrayListColumn<Long> COL_ORDERS = new ArrayListColumn<Long>(Long.class, "ORDERS", new ColumnFlag[0]);
    public static final ArrayListColumn<Long> COL_PARENTS = new ArrayListColumn<Long>(Long.class, "PARENTS", new ColumnFlag[0]);
    public static final ArrayListColumn<LineItem> COL_ITEMS = new ArrayListColumn<LineItem>(LineItem.class, "ITEMS", new ColumnFlag[0]);
    public static final ArrayListColumn<Deduction> COL_DEDUCTIONS = new ArrayListColumn<Deduction>(Deduction.class, "DEDUCTIONS", new ColumnFlag[0]);
    public static final DataModel<DocumentFull> MODEL = new DataModel<DocumentFull>(DocumentFull.class, "DocumentFull", "Document").with(COL_ID, Document::getId, Document::setId).with(COL_NUMBER, Document::getNumber, Document::setNumber).with(COL_TYPE, Document::getType, Document::setType).with(COL_STATE, Document::getState, Document::setState).with(COL_DATE, Document::getDate, Document::setDate).with(COL_SERVICE_TYPE, Document::getServiceType, Document::setServiceType).with(COL_SERVICE_DATE1, Document::getServiceDate1, Document::setServiceDate1).with(COL_SERVICE_DATE2, Document::getServiceDate2, Document::setServiceDate2).with(COL_DUE_DATE, Document::getDueDate, Document::setDueDate).with(COL_USER_ID, Document::getUserId, Document::setUserId).with(COL_CUSTOMER_ID, Document::getCustomerId, Document::setCustomerId).with(COL_VENDOR_ID, Document::getVendorId, Document::setVendorId).with(COL_SALUTATION, Document::getSalutation, Document::setSalutation).with(COL_PREFIX, Document::getPrefix, Document::setPrefix).with(COL_FIRST_NAME, Document::getFirstName, Document::setFirstName).with(COL_LAST_NAME, Document::getLastName, Document::setLastName).with(COL_COMPANY, Document::getCompany, Document::setCompany).with(COL_COUNTRY, Document::getCountry, Document::setCountry).with(COL_ADDRESS1, Document::getAddress1, Document::setAddress1).with(COL_ADDRESS2, Document::getAddress2, Document::setAddress2).with(COL_REFERENCE_NUMBER, Document::getReferenceNumber, Document::setReferenceNumber).with(COL_TEXT, Document::getText, Document::setText).with(COL_TAXATION, Document::getTaxation, Document::setTaxation).with(COL_TOTAL_PRICE, Document::getTotalPrice, Document::setTotalPrice).with(COL_REMAINING_PRICE, Document::getRemainingPrice, Document::setRemainingPrice).with(COL_ATTACHMENT_ID, Document::getAttachmentId, Document::setAttachmentId).with(COL_HEADLESS_ATTACHMENT_ID, Document::getHeadlessAttachmentId, Document::setHeadlessAttachmentId).with(COL_PRINTED, Document::getPrinted, Document::setPrinted).with(COL_ORDERS, DocumentFull::getOrders, DocumentFull::setOrders).with(COL_PARENTS, DocumentFull::getParents, DocumentFull::setParents).with(COL_ITEMS, DocumentFull::getItems, DocumentFull::setItems);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withScope(Document.MODEL.getName()).withUpdatableColumns(COL_DATE, COL_SERVICE_TYPE, COL_SERVICE_DATE1, COL_SERVICE_DATE2, COL_DUE_DATE, COL_USER_ID, COL_CUSTOMER_ID, COL_VENDOR_ID, COL_SALUTATION, COL_PREFIX, COL_FIRST_NAME, COL_LAST_NAME, COL_COMPANY, COL_COUNTRY, COL_ADDRESS1, COL_ADDRESS2, COL_REFERENCE_NUMBER, COL_TEXT, COL_TAXATION, COL_PARTIAL_PRICE, COL_TOTAL_PRICE, COL_ITEMS);
    private ArrayList<Long> orders = new ArrayList();
    private ArrayList<Long> parents = new ArrayList();
    private ArrayList<LineItem> items = new ArrayList();
    private ArrayList<Deduction> deductions = new ArrayList();

    public DocumentFull() {
    }

    public DocumentFull(DocumentFull document) {
        super(document);
        this.setOrders(document.orders);
        this.setParents(document.parents);
        this.setItems(document.items);
        this.setDeductions(document.deductions);
    }

    public DocumentFull(List<Long> orders, DocumentType type, Long user) {
        this.setOrders(orders);
        this.setType(type);
        this.setUserId(user);
    }

    public DocumentFull(Document document, DSLContext dsl) throws Exception {
        this.copyFrom(document);
        this.queryFullDocument(dsl);
    }

    public void queryFullDocument(DSLContext dsl) throws Exception {
        this.setOrders(dsl.selectFrom(Tables.ORDER_DOCUMENT).where(Tables.ORDER_DOCUMENT.DOCUMENT_ID.eq(this.getId())).fetch().stream().map(od -> od.getOrderId()).collect(Collectors.toList()));
        this.setParents(dsl.selectFrom(Tables.DOCUMENT_DOCUMENT).where(Tables.DOCUMENT_DOCUMENT.CHILD_DOCUMENT_ID.eq(this.getId())).fetch().stream().map(od -> od.getParentDocumentId()).collect(Collectors.toList()));
        this.setItems((List<LineItem>)((Object)dsl.selectFrom(Tables.LINE_ITEM).where(Tables.LINE_ITEM.DOCUMENT_ID.eq(this.getId())).orderBy(Tables.LINE_ITEM.ROW.asc()).fetchInto(LineItem.class)));
        this.setDeductions((List<Deduction>)((Object)dsl.selectFrom(Tables.DEDUCTION).where(Tables.DEDUCTION.DOCUMENT_ID.eq(this.getId())).orderBy(Tables.DEDUCTION.ROW.asc()).fetchInto(Deduction.class)));
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public ArrayList<Long> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Long> orders) {
        this.orders = new ArrayList<Long>(orders);
    }

    public ArrayList<Long> getParents() {
        return this.parents;
    }

    public void setParents(List<Long> parents) {
        this.parents = new ArrayList<Long>(parents);
    }

    public ArrayList<LineItem> getItems() {
        return this.items;
    }

    public void setItems(List<LineItem> items) {
        this.items = items.stream().map(item -> new LineItem((LineItem)item)).collect(Collectors.toCollection(() -> new ArrayList()));
    }

    public ArrayList<Deduction> getDeductions() {
        return this.deductions;
    }

    public void setDeductions(List<Deduction> deductions) {
        this.deductions = deductions.stream().map(item -> new Deduction((Deduction)item)).collect(Collectors.toCollection(() -> new ArrayList()));
    }

    public TotalPrice computeNetPrice() {
        TotalPrice price = LineItem.computeNetPrice(this.getItems());
        if (!this.getDeductions().isEmpty()) {
            BigDecimal sum = price.getTotalSum();
            for (Deduction deduction : this.getDeductions()) {
                sum = sum.subtract(deduction.getPrice());
            }
            price = new TotalPrice(price.isComplete(), price.getNetRestDeduction(), BigDecimal.ZERO, sum);
        }
        if (this.getPartialPrice() != null) {
            BigDecimal deduction = price.getNetSum().subtract(this.getPartialPrice());
            price = new TotalPrice(price.isComplete(), price.getNetSumBeforeDeductions(), deduction, this.getPartialPrice());
        }
        return price;
    }

    public TotalPrice computeTotalPrice(List<TaxRate> taxRates) {
        switch (this.getTaxation()) {
            case DEFAULT: {
                TotalPrice price = LineItem.computeTotalPrice(taxRates, this.getTaxation(), this.getItems());
                if (!this.getDeductions().isEmpty()) {
                    HashMap<Long, BigDecimal> netSum = new HashMap<Long, BigDecimal>(price.getNet());
                    for (Deduction deduction : this.getDeductions()) {
                        Long taxRate = deduction.getTaxRateId();
                        netSum.put(taxRate, netSum.get(taxRate).subtract(deduction.getPrice()));
                    }
                    price = new TotalPrice(price.isComplete(), price.getNetSumBeforeDeductions(), BigDecimal.ZERO, taxRates, netSum);
                }
                if (this.getPartialPrice() != null) {
                    if (price.getTaxRates().size() > 1) {
                        throw new RuntimeException("unimplemented");
                    }
                    BigDecimal deduction = price.getNetSum().subtract(this.getPartialPrice());
                    HashMap<Long, BigDecimal> netSum = new HashMap<Long, BigDecimal>(price.getNet());
                    Long taxRate = price.getTaxRates().get(0);
                    netSum.put(taxRate, this.getPartialPrice());
                    price = new TotalPrice(price.isComplete(), price.getNetSumBeforeDeductions(), deduction, taxRates, netSum);
                }
                return price;
            }
            case KLEINUNTERNEHMER: {
                return this.computeNetPrice();
            }
        }
        return null;
    }

    @Override
    public void validate() throws Exception {
        TotalPrice price;
        super.validate();
        if (this.getType().needsPrices()) {
            for (LineItem item : this.getItems()) {
                if (item.getTotalPrice() != null) continue;
                throw new ValidationException("Document.errors.entry_without_price");
            }
        }
        if (!this.getType().isContinuedPartialInvoice()) {
            for (Deduction deduction : this.getDeductions()) {
                if (deduction.getPartialDocumentId() == null) continue;
                throw new ValidationException();
            }
        }
        if ((price = this.computeNetPrice()).getNetRestDeduction().signum() < 0) {
            throw new ValidationException("Document.errors.partialPrice_too_high");
        }
    }

    public DocumentFull cloneDocument(DocumentType type, Taxation taxation) {
        DocumentFull res = new DocumentFull(this);
        res.setId(null);
        res.setNumber(null);
        res.setType(type);
        res.setState(OrderState.DRAFT);
        res.setDate(LocalDate.now());
        res.setServiceDate1(null);
        res.setServiceDate2(null);
        res.setDueDate(null);
        res.setUserId(null);
        res.setTaxation(taxation);
        res.setPartialPrice(null);
        res.setTotalPrice(null);
        res.setRemainingPrice(null);
        res.setAttachmentId(null);
        res.setHeadlessAttachmentId(null);
        res.setPrinted(0L);
        res.setParents(List.of());
        for (LineItem item : res.getItems()) {
            item.setId(null);
            item.setDocumentId(null);
            item.setState(null);
            item.setPrevLineItemId(null);
            item.setPrevDocumentId(null);
            item.setNextLineItemId(null);
            item.setNextDocumentId(null);
        }
        ArrayList<Deduction> deductions = new ArrayList<Deduction>();
        for (Deduction deduction : res.getDeductions()) {
            if (deduction.getPartialDocumentId() != null) continue;
            deduction = new Deduction(deduction);
            deduction.setId(null);
            deduction.setDocumentId(null);
            deduction.setRow(Long.valueOf(deductions.size()));
            deductions.add(deduction);
        }
        res.setDeductions(deductions);
        return res;
    }

    private static DocumentFull createFromDocument(DocumentType type, DocumentFull document, boolean keepCompleted) {
        DocumentFull res = new DocumentFull(document);
        res.setId(null);
        res.setNumber(null);
        res.setType(type);
        res.setState(OrderState.DRAFT);
        res.setDate(LocalDate.now());
        res.setDueDate(null);
        res.setUserId(null);
        res.setPartialPrice(null);
        res.setTotalPrice(null);
        res.setRemainingPrice(null);
        res.setAttachmentId(null);
        res.setHeadlessAttachmentId(null);
        res.setPrinted(0L);
        res.setParents(List.of(document.getId()));
        ArrayList<LineItem> items = new ArrayList<LineItem>();
        for (LineItem item : document.getItems()) {
            if (item.getNextLineItemId() != null || !keepCompleted && item.getState() != null) continue;
            LineItem item2 = new LineItem(item);
            item2.setId(null);
            item2.setDocumentId(null);
            item2.setRow(Long.valueOf(items.size()));
            item2.setState(null);
            item2.setPrevLineItemId(item.getId());
            item2.setPrevDocumentId(item.getDocumentId());
            item2.setNextLineItemId(null);
            item2.setNextDocumentId(null);
            items.add(item2);
        }
        res.setItems(items);
        for (Deduction deduction : res.getDeductions()) {
            deduction.setId(null);
            deduction.setDocumentId(null);
        }
        res.setPartialPrice(null);
        res.setTotalPrice(null);
        res.setRemainingPrice(null);
        return res;
    }

    public static DocumentFull createConfirmFromOffer(DocumentFull offer) {
        if (offer.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (offer.getType() != DocumentType.OFFER) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.CONFIRM, offer, false);
    }

    public static DocumentFull createReceiptFromConfirm(DocumentFull confirm) {
        if (confirm.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (confirm.getType() != DocumentType.CONFIRM) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.RECEIPT, confirm, false);
    }

    public static DocumentFull createReceiptFromDepositInvoice(DocumentFull confirm) {
        if (confirm.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (confirm.getType() != DocumentType.DEPOSITINVOICE) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.RECEIPT, confirm, false);
    }

    public static DocumentFull createInvoiceFromConfirm(DocumentFull confirm) {
        if (confirm.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (confirm.getType() != DocumentType.CONFIRM) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.INVOICE, confirm, false);
    }

    public static DocumentFull createInvoiceFromReceipts(List<DocumentFull> receipts) {
        if (receipts.isEmpty()) {
            throw new IllegalArgumentException();
        }
        DocumentFull res = DocumentFull.createFromDocument(DocumentType.INVOICE, receipts.get(0), false);
        res.setParents(receipts.stream().map(d -> d.getId()).collect(Collectors.toList()));
        ArrayList<LineItem> items = new ArrayList<LineItem>();
        for (DocumentFull receipt : receipts) {
            if (receipt.getId() == null) {
                throw new IllegalArgumentException();
            }
            if (receipt.getType() != DocumentType.RECEIPT) {
                throw new IllegalArgumentException();
            }
            for (LineItem item : receipt.getItems()) {
                Long id = item.getId();
                Long docId = item.getDocumentId();
                item = new LineItem(item);
                item.setId(null);
                item.setDocumentId(null);
                item.setRow(Long.valueOf(items.size()));
                item.setState(null);
                item.setPrevLineItemId(id);
                item.setPrevDocumentId(docId);
                item.setNextLineItemId(null);
                item.setNextDocumentId(null);
                items.add(item);
            }
        }
        res.setItems(items);
        return res;
    }

    public static DocumentFull createDepositInvoiceFromConfirm(DocumentFull confirm) {
        if (confirm.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (confirm.getType() != DocumentType.CONFIRM) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.DEPOSITINVOICE, confirm, false);
    }

    public static DocumentFull createPartialInvoiceFromConfirm(DocumentFull confirm) {
        if (confirm.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (confirm.getType() != DocumentType.CONFIRM) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.PARTIALPAYMENTINVOICE, confirm, false);
    }

    public static DocumentFull createPartialInvoiceFromReceipts(ResourceBundle bundle, DocumentFull depositInvoice, List<DocumentFull> receipts) {
        if (receipts.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (depositInvoice != null && depositInvoice.getType() != DocumentType.DEPOSITINVOICE) {
            throw new IllegalArgumentException();
        }
        DocumentFull res = DocumentFull.createFromDocument(DocumentType.PARTIALPAYMENTINVOICE, receipts.get(0), false);
        ArrayList<Long> parents = new ArrayList<Long>();
        if (depositInvoice != null) {
            parents.add(depositInvoice.getId());
        }
        for (DocumentFull documentFull : receipts) {
            parents.add(documentFull.getId());
        }
        res.setParents(parents);
        ArrayList<LineItem> items = new ArrayList<LineItem>();
        for (DocumentFull receipt : receipts) {
            if (receipt.getId() == null) {
                throw new IllegalArgumentException();
            }
            if (receipt.getType() != DocumentType.RECEIPT) {
                throw new IllegalArgumentException();
            }
            for (LineItem item : receipt.getItems()) {
                if (depositInvoice != null && item.getPrevDocumentId() != null && item.getPrevDocumentId().longValue() != depositInvoice.getId().longValue()) {
                    throw new IllegalArgumentException();
                }
                Long id = item.getId();
                Long docId = item.getDocumentId();
                item = new LineItem(item);
                item.setId(null);
                item.setDocumentId(null);
                item.setRow(Long.valueOf(items.size()));
                item.setState(null);
                item.setPrevLineItemId(id);
                item.setPrevDocumentId(docId);
                item.setNextLineItemId(null);
                item.setNextDocumentId(null);
                items.add(item);
            }
        }
        if (depositInvoice != null) {
            for (LineItem item : depositInvoice.getItems()) {
                if (item.getNextLineItemId() != null) continue;
                LineItem item2 = new LineItem(item);
                item2.setId(null);
                item2.setDocumentId(null);
                item2.setRow(Long.valueOf(items.size()));
                item2.setState(null);
                item2.setPrevLineItemId(item.getId());
                item2.setPrevDocumentId(item.getDocumentId());
                item2.setNextLineItemId(null);
                item2.setNextDocumentId(null);
                items.add(item2);
            }
        }
        res.setItems(items);
        if (depositInvoice != null) {
            res.setDeductions(depositInvoice.getDeductions());
            Deduction deduction = new Deduction();
            deduction.setRow(res.getDeductions().isEmpty() ? 0L : res.getDeductions().get(res.getDeductions().size() - 1).getRow() + 1L);
            deduction.setPartialDocumentId(depositInvoice.getId());
            deduction.setTitle(depositInvoice.getType().getLocalizedString(bundle) + " " + depositInvoice.getNumber() + " (" + I18N.formatDate(depositInvoice.getDate()) + ")");
            deduction.setPrice(depositInvoice.getPartialPrice());
            deduction.setTaxRateId(depositInvoice.getItems().get(0).getTaxRateId());
            res.getDeductions().add(deduction);
        }
        return res;
    }

    public static DocumentFull createPartialInvoiceFromPartialInvoice(ResourceBundle bundle, DocumentFull invoice) {
        if (invoice.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (!invoice.getType().isPartialInvoice()) {
            throw new IllegalArgumentException();
        }
        DocumentFull res = DocumentFull.createFromDocument(DocumentType.PARTIALPAYMENTINVOICE, invoice, false);
        Deduction deduction = new Deduction();
        deduction.setRow(res.getDeductions().isEmpty() ? 0L : res.getDeductions().get(res.getDeductions().size() - 1).getRow() + 1L);
        deduction.setPartialDocumentId(invoice.getId());
        deduction.setTitle(invoice.getType().getLocalizedString(bundle) + " " + invoice.getNumber() + " (" + I18N.formatDate(invoice.getDate()) + ")");
        deduction.setPrice(invoice.getPartialPrice());
        deduction.setTaxRateId(invoice.getItems().get(0).getTaxRateId());
        res.getDeductions().add(deduction);
        return res;
    }

    public static DocumentFull createFinalInvoiceFromReceipts(ResourceBundle bundle, DocumentFull depositInvoice, List<DocumentFull> receipts) {
        if (receipts.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (depositInvoice != null && depositInvoice.getType() != DocumentType.DEPOSITINVOICE) {
            throw new IllegalArgumentException();
        }
        DocumentFull res = DocumentFull.createFromDocument(DocumentType.FINALPAYMENTINVOICE, receipts.get(0), false);
        ArrayList<Long> parents = new ArrayList<Long>();
        if (depositInvoice != null) {
            parents.add(depositInvoice.getId());
        }
        for (DocumentFull documentFull : receipts) {
            parents.add(documentFull.getId());
        }
        res.setParents(parents);
        ArrayList<LineItem> items = new ArrayList<LineItem>();
        for (DocumentFull receipt : receipts) {
            if (receipt.getId() == null) {
                throw new IllegalArgumentException();
            }
            if (receipt.getType() != DocumentType.RECEIPT) {
                throw new IllegalArgumentException();
            }
            for (LineItem item : receipt.getItems()) {
                if (depositInvoice != null && item.getPrevDocumentId() != null && item.getPrevDocumentId().longValue() != depositInvoice.getId().longValue()) {
                    throw new IllegalArgumentException();
                }
                Long id = item.getId();
                Long docId = item.getDocumentId();
                item = new LineItem(item);
                item.setId(null);
                item.setDocumentId(null);
                item.setRow(Long.valueOf(items.size()));
                item.setState(null);
                item.setPrevLineItemId(id);
                item.setPrevDocumentId(docId);
                item.setNextLineItemId(null);
                item.setNextDocumentId(null);
                items.add(item);
            }
        }
        if (depositInvoice != null) {
            for (LineItem item : depositInvoice.getItems()) {
                if (item.getNextLineItemId() != null) continue;
                LineItem item2 = new LineItem(item);
                item2.setId(null);
                item2.setDocumentId(null);
                item2.setRow(Long.valueOf(items.size()));
                item2.setState(null);
                item2.setPrevLineItemId(item.getId());
                item2.setPrevDocumentId(item.getDocumentId());
                item2.setNextLineItemId(null);
                item2.setNextDocumentId(null);
                items.add(item2);
            }
        }
        res.setItems(items);
        if (depositInvoice != null) {
            res.setDeductions(depositInvoice.getDeductions());
            Deduction deduction = new Deduction();
            deduction.setRow(res.getDeductions().isEmpty() ? 0L : res.getDeductions().get(res.getDeductions().size() - 1).getRow() + 1L);
            deduction.setPartialDocumentId(depositInvoice.getId());
            deduction.setTitle(depositInvoice.getType().getLocalizedString(bundle) + " " + depositInvoice.getNumber() + " (" + I18N.formatDate(depositInvoice.getDate()) + ")");
            deduction.setPrice(depositInvoice.getPartialPrice());
            deduction.setTaxRateId(depositInvoice.getItems().get(0).getTaxRateId());
            res.getDeductions().add(deduction);
        }
        return res;
    }

    public static DocumentFull createFinalInvoiceFromPartialInvoice(ResourceBundle bundle, DocumentFull invoice) {
        if (invoice.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (!invoice.getType().isPartialInvoice()) {
            throw new IllegalArgumentException();
        }
        DocumentFull res = DocumentFull.createFromDocument(DocumentType.FINALPAYMENTINVOICE, invoice, false);
        Deduction deduction = new Deduction();
        deduction.setRow(res.getDeductions().isEmpty() ? 0L : res.getDeductions().get(res.getDeductions().size() - 1).getRow() + 1L);
        deduction.setPartialDocumentId(invoice.getId());
        deduction.setTitle(invoice.getType().getLocalizedString(bundle) + " " + invoice.getNumber() + " (" + I18N.formatDate(invoice.getDate()) + ")");
        deduction.setPrice(invoice.getPartialPrice());
        deduction.setTaxRateId(invoice.getItems().get(0).getTaxRateId());
        res.getDeductions().add(deduction);
        return res;
    }

    public static DocumentFull createCancelInvoiceFromInvoice(DocumentFull invoice) {
        if (invoice.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (!invoice.getType().isCancellableInvoice()) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.CANCELINVOICE, invoice, true);
    }

    public static DocumentFull createPurchaseFromRequest(DocumentFull request) {
        if (request.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (request.getType() != DocumentType.REQUEST) {
            throw new IllegalArgumentException();
        }
        DocumentFull res = DocumentFull.createFromDocument(DocumentType.PURCHASE, request, false);
        for (LineItem item : res.getItems()) {
            item.setPrevLineItemId(null);
            item.setPrevDocumentId(null);
        }
        return res;
    }

    public static DocumentFull createPaymentFromPurchase(DocumentFull purchase) {
        if (purchase.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (purchase.getType() != DocumentType.PURCHASE) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.PAYMENT, purchase, false);
    }

    public static DocumentFull createCancelFromPurchase(DocumentFull purchase) {
        if (purchase.getId() == null) {
            throw new IllegalArgumentException();
        }
        if (purchase.getType() != DocumentType.PURCHASE) {
            throw new IllegalArgumentException();
        }
        return DocumentFull.createFromDocument(DocumentType.CANCEL, purchase, false);
    }
}

