/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Document;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Taxation;
import de.inahware.dav.models.types.TotalPrice;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class LineItem
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.LINE_ITEM.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<Long> COL_DOCUMENT_ID = new SQLColumn(Tables.LINE_ITEM.DOCUMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ROW = new SQLColumn(Tables.LINE_ITEM.ROW, new ColumnFlag[0]);
    public static final SQLConvertColumn<OrderState, String> COL_STATE = new SQLConvertColumn(OrderState.class, Tables.LINE_ITEM.STATE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_PREV_DOCUMENT_ID = new SQLColumn(Tables.LINE_ITEM.PREV_DOCUMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_PREV_LINE_ITEM_ID = new SQLColumn(Tables.LINE_ITEM.PREV_LINE_ITEM_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_NEXT_DOCUMENT_ID = new SQLColumn(Tables.LINE_ITEM.NEXT_DOCUMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_NEXT_LINE_ITEM_ID = new SQLColumn(Tables.LINE_ITEM.NEXT_LINE_ITEM_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ARTICLE_ID = new SQLColumn(Tables.LINE_ITEM.ARTICLE_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ARTICLE_NUMBER = new SQLColumn(Tables.LINE_ITEM.ARTICLE_NUMBER, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_VENDORS_ARTICLE_NUMBER = new SQLColumn(Tables.LINE_ITEM.VENDORS_ARTICLE_NUMBER, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ARTICLE_TITLE = new SQLColumn(Tables.LINE_ITEM.ARTICLE_TITLE, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_PRICE = new SQLColumn(Tables.LINE_ITEM.PRICE, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_UNIT = new SQLColumn(Tables.LINE_ITEM.UNIT, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_TAX_RATE_ID = new SQLColumn(Tables.LINE_ITEM.TAX_RATE_ID, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_AMOUNT = new SQLColumn(Tables.LINE_ITEM.AMOUNT, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_DISCOUNT = new SQLColumn(Tables.LINE_ITEM.DISCOUNT, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TEXT = new SQLColumn(Tables.LINE_ITEM.TEXT, new ColumnFlag[0]);
    public static final DataModel<LineItem> MODEL = new DataModel<LineItem>(LineItem.class).with(COL_ID, LineItem::getId, LineItem::setId).with(COL_DOCUMENT_ID, LineItem::getDocumentId, LineItem::setDocumentId).with(COL_ROW, LineItem::getRow, LineItem::setRow).with(COL_STATE, LineItem::getState, LineItem::setState).with(COL_PREV_DOCUMENT_ID, LineItem::getPrevDocumentId, LineItem::setPrevDocumentId).with(COL_PREV_LINE_ITEM_ID, LineItem::getPrevLineItemId, LineItem::setPrevLineItemId).with(COL_NEXT_DOCUMENT_ID, LineItem::getNextDocumentId, LineItem::setNextDocumentId).with(COL_NEXT_LINE_ITEM_ID, LineItem::getNextLineItemId, LineItem::setNextLineItemId).with(COL_ARTICLE_ID, LineItem::getArticleId, LineItem::setArticleId).with(COL_ARTICLE_NUMBER, LineItem::getArticleNumber, LineItem::setArticleNumber).with(COL_VENDORS_ARTICLE_NUMBER, LineItem::getVendorsArticleNumber, LineItem::setVendorsArticleNumber).with(COL_ARTICLE_TITLE, LineItem::getArticleTitle, LineItem::setArticleTitle).with(COL_PRICE, LineItem::getPrice, LineItem::setPrice).with(COL_UNIT, LineItem::getUnit, LineItem::setUnit).with(COL_TAX_RATE_ID, LineItem::getTaxRateId, LineItem::setTaxRateId).with(COL_AMOUNT, LineItem::getAmount, LineItem::setAmount).with(COL_DISCOUNT, LineItem::getDiscount, LineItem::setDiscount).with(COL_TEXT, LineItem::getText, LineItem::setText);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withScope(Document.MODEL.getName());
    private Long id;
    private Long documentId;
    private Long row;
    private OrderState state;
    private Long prevDocumentId;
    private Long prevLineItemId;
    private Long nextDocumentId;
    private Long nextLineItemId;
    private Long articleId;
    private String articleNumber = "";
    private String vendorsArticleNumber = "";
    private String articleTitle = "";
    private BigDecimal price;
    private String unit = "";
    private Long taxRateId;
    private BigDecimal amount = BigDecimal.ONE;
    private BigDecimal discount = BigDecimal.ZERO;
    private String text = "";

    public LineItem() {
    }

    public LineItem(LineItem obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long orderId) {
        this.documentId = orderId;
    }

    public Long getRow() {
        return this.row;
    }

    public void setRow(Long row) {
        this.row = row;
    }

    public OrderState getState() {
        return this.state;
    }

    public void setState(OrderState state) {
        this.state = state;
    }

    public Long getPrevDocumentId() {
        return this.prevDocumentId;
    }

    public void setPrevDocumentId(Long prevDocument) {
        this.prevDocumentId = prevDocument;
    }

    public Long getPrevLineItemId() {
        return this.prevLineItemId;
    }

    public void setPrevLineItemId(Long prev) {
        this.prevLineItemId = prev;
    }

    public Long getNextDocumentId() {
        return this.nextDocumentId;
    }

    public void setNextDocumentId(Long nextDocument) {
        this.nextDocumentId = nextDocument;
    }

    public Long getNextLineItemId() {
        return this.nextLineItemId;
    }

    public void setNextLineItemId(Long next) {
        this.nextLineItemId = next;
    }

    public Long getArticleId() {
        return this.articleId;
    }

    public void setArticleId(Long articleId) {
        this.articleId = articleId;
    }

    public String getArticleNumber() {
        return this.articleNumber;
    }

    public void setArticleNumber(String articleNumber) {
        this.articleNumber = articleNumber;
    }

    public String getVendorsArticleNumber() {
        return this.vendorsArticleNumber;
    }

    public void setVendorsArticleNumber(String vendorsArticleNumber) {
        this.vendorsArticleNumber = vendorsArticleNumber;
    }

    public String getArticleTitle() {
        return this.articleTitle;
    }

    public void setArticleTitle(String articleTitle) {
        this.articleTitle = articleTitle;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Long getTaxRateId() {
        return this.taxRateId;
    }

    public void setTaxRateId(Long taxRate) {
        this.taxRateId = taxRate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getDiscount() {
        return this.discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDisplayName() {
        if (this.getArticleNumber() == null || this.getArticleNumber().isEmpty()) {
            return this.getArticleTitle();
        }
        return "#" + this.getArticleNumber() + " (" + this.getArticleTitle() + ")";
    }

    public BigDecimal getTotalPrice() {
        if (this.getPrice() == null) {
            return null;
        }
        BigDecimal factor = new BigDecimal(100).subtract(this.getDiscount()).divide(new BigDecimal(100));
        return this.getAmount().multiply(this.getPrice()).multiply(factor).setScale(2, RoundingMode.HALF_UP);
    }

    public boolean compatibleTo(LineItem entry) {
        return this.getState() == OrderState.ONGOING && entry.getState() == OrderState.ONGOING && this.getPrevLineItemId() == null && entry.getPrevLineItemId() == null && this.getNextLineItemId() == null && entry.getNextLineItemId() == null && this.getDocumentId().equals(entry.getDocumentId()) && this.getArticleId().equals(entry.getArticleId()) && this.getArticleNumber().equals(entry.getArticleNumber()) && Objects.equals(this.getVendorsArticleNumber(), entry.getVendorsArticleNumber()) && this.getArticleTitle().equals(entry.getArticleTitle()) && this.getPrice().equals(entry.getPrice()) && this.getUnit().equals(entry.getUnit()) && this.getTaxRateId().equals(entry.getTaxRateId()) && this.getDiscount().equals(entry.getDiscount()) && this.getText().equals(entry.getText());
    }

    public static List<LineItem> splitById(List<LineItem> entries, long id, BigDecimal amount) {
        for (int i = 0; i < entries.size(); ++i) {
            if (entries.get(i).getId() != id) continue;
            return LineItem.splitAt(entries, i, amount);
        }
        return null;
    }

    public static List<LineItem> splitAt(List<LineItem> entries, int idx, BigDecimal amount) {
        if (idx < 0 || idx >= entries.size()) {
            return null;
        }
        LineItem entry = entries.get(idx);
        if (entry.getState() != OrderState.ONGOING || entry.getPrevLineItemId() != null || entry.getNextLineItemId() != null) {
            return null;
        }
        if (amount.signum() <= 0 || amount.compareTo(entry.getAmount()) >= 0) {
            return null;
        }
        LineItem entry2 = new LineItem(entry);
        entry2.setId(null);
        entry2.setAmount(entry.getAmount().subtract(amount));
        entry = new LineItem(entry);
        entry.setAmount(amount);
        ArrayList<LineItem> entries2 = new ArrayList<LineItem>(entries);
        entries2.set(idx, entry);
        entries2.add(idx + 1, entry2);
        for (int i = idx + 1; i < entries2.size(); ++i) {
            entries2.get(i).setRow(Long.valueOf(i));
        }
        return entries2;
    }

    public static List<LineItem> mergeById(List<LineItem> entries, List<Long> ids) {
        HashMap<Long, Integer> idx_by_id = new HashMap<Long, Integer>();
        for (int i = 0; i < entries.size(); ++i) {
            idx_by_id.put(entries.get(i).getId(), i);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Long id : ids) {
            Integer idx = (Integer)idx_by_id.get(id);
            if (idx == null) {
                return null;
            }
            indices.add(idx);
        }
        return LineItem.mergeAt(entries, indices);
    }

    public static List<LineItem> mergeAt(List<LineItem> entries, List<Integer> indices) {
        ArrayList<LineItem> merging = new ArrayList<LineItem>();
        for (Integer n : indices) {
            if (n < 0 || n >= entries.size()) {
                return null;
            }
            LineItem entry = entries.get(n);
            if (entry.getState() != OrderState.ONGOING || entry.getPrevLineItemId() != null || entry.getNextLineItemId() != null) {
                return null;
            }
            merging.add(entry);
        }
        for (int i = 1; i < merging.size(); ++i) {
            if (((LineItem)merging.get(i)).compatibleTo((LineItem)merging.get(0))) continue;
            return null;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (LineItem next : merging) {
            sum = sum.add(next.getAmount());
        }
        LineItem lineItem = new LineItem((LineItem)merging.get(0));
        lineItem.setAmount(sum);
        ArrayList<LineItem> entries2 = new ArrayList<LineItem>(entries);
        entries2.set(indices.get(0), lineItem);
        indices.stream().skip(1L).sorted(Comparator.reverseOrder()).forEach(idx -> entries2.remove((int)idx));
        for (int i = 0; i < entries2.size(); ++i) {
            entries2.get(i).setRow(Long.valueOf(i));
        }
        return entries2;
    }

    public static TotalPrice computeNetPrice(List<LineItem> items) {
        boolean complete = true;
        BigDecimal res = BigDecimal.ZERO;
        for (LineItem item : items) {
            BigDecimal next = item.getTotalPrice();
            if (next == null) {
                complete = false;
                continue;
            }
            res = res.add(item.getTotalPrice());
        }
        return new TotalPrice(complete, res);
    }

    public static TotalPrice computeTotalPrice(List<TaxRate> taxRates, Taxation taxation, List<LineItem> items) {
        switch (taxation) {
            case DEFAULT: {
                boolean complete = true;
                HashMap<Long, BigDecimal> sum_net = new HashMap<Long, BigDecimal>();
                for (LineItem item : items) {
                    BigDecimal price = item.getTotalPrice();
                    if (price == null) {
                        complete = false;
                        continue;
                    }
                    Long taxRate = item.getTaxRateId();
                    if (!sum_net.containsKey(taxRate)) {
                        sum_net.put(taxRate, price);
                        continue;
                    }
                    sum_net.put(taxRate, sum_net.get(taxRate).add(price));
                }
                return new TotalPrice(complete, taxRates, sum_net);
            }
            case KLEINUNTERNEHMER: {
                return LineItem.computeNetPrice(items);
            }
        }
        return null;
    }
}

