/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.inahware.dav.Hashing;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.jooq.tables.records.UserAuthPasswordRecord;
import de.inahware.dav.jooq.tables.records.UserRoleRecord;
import de.inahware.dav.migrations.M000001CreateSetting;
import de.inahware.dav.migrations.M000002CreateCloudServerInstance;
import de.inahware.dav.migrations.M000003CreateUser;
import de.inahware.dav.migrations.M000004CreateRole;
import de.inahware.dav.migrations.M000005CreateSession;
import de.inahware.dav.migrations.M000006CreateCounter;
import de.inahware.dav.migrations.M000007CreateText;
import de.inahware.dav.migrations.M000008CreateCustomerVendorAddress;
import de.inahware.dav.migrations.M000009CreateTaxRate;
import de.inahware.dav.migrations.M000010CreateAttachment;
import de.inahware.dav.migrations.M000011CreateArticleGroup;
import de.inahware.dav.migrations.M000012CreateArticle;
import de.inahware.dav.migrations.M000013CreateArticleVendor;
import de.inahware.dav.migrations.M000014CreateDiscount;
import de.inahware.dav.migrations.M000015CreateOrder;
import de.inahware.dav.migrations.M000016CreateDocument;
import de.inahware.dav.migrations.M000017CreateNotice;
import de.inahware.dav.migrations.M000018CreateRecordCategory;
import de.inahware.dav.migrations.M000019CreateRecord;
import de.inahware.dav.migrations.M000020CreateBankStatement;
import de.inahware.dav.migrations.M000021CreateTask;
import de.inahware.dav.models.Counter;
import de.inahware.dav.models.Role;
import de.inahware.dav.models.Setting;
import de.inahware.dav.models.TaxRate;
import de.inahware.dav.models.Text;
import de.inahware.dav.models.User;
import de.inahware.dav.models.controllers.AddressController;
import de.inahware.dav.models.controllers.ArticleController;
import de.inahware.dav.models.controllers.ArticleGroupController;
import de.inahware.dav.models.controllers.ArticleVendorController;
import de.inahware.dav.models.controllers.ArticleVendorViewController;
import de.inahware.dav.models.controllers.AttachmentController;
import de.inahware.dav.models.controllers.BankStatementController;
import de.inahware.dav.models.controllers.BankStatementFullController;
import de.inahware.dav.models.controllers.BankStatementItemController;
import de.inahware.dav.models.controllers.CloudserverInstanceViewController;
import de.inahware.dav.models.controllers.CounterController;
import de.inahware.dav.models.controllers.CustomerController;
import de.inahware.dav.models.controllers.DeductionController;
import de.inahware.dav.models.controllers.DiscountController;
import de.inahware.dav.models.controllers.DiscountViewController;
import de.inahware.dav.models.controllers.DocumentController;
import de.inahware.dav.models.controllers.DocumentFullController;
import de.inahware.dav.models.controllers.DocumentViewController;
import de.inahware.dav.models.controllers.LineItemController;
import de.inahware.dav.models.controllers.NoticeController;
import de.inahware.dav.models.controllers.OrderController;
import de.inahware.dav.models.controllers.OrderDocumentViewController;
import de.inahware.dav.models.controllers.OrderViewController;
import de.inahware.dav.models.controllers.PendingNoticeController;
import de.inahware.dav.models.controllers.RecordCategoryController;
import de.inahware.dav.models.controllers.RecordController;
import de.inahware.dav.models.controllers.RoleController;
import de.inahware.dav.models.controllers.SettingController;
import de.inahware.dav.models.controllers.TaskController;
import de.inahware.dav.models.controllers.TaxRateController;
import de.inahware.dav.models.controllers.TextController;
import de.inahware.dav.models.controllers.UserAuthCloudserverController;
import de.inahware.dav.models.controllers.UserController;
import de.inahware.dav.models.controllers.UserRoleController;
import de.inahware.dav.models.controllers.VendorController;
import de.inahware.dav.models.types.DocumentType;
import de.inahware.dav.models.types.Salutation;
import de.inahware.dav.requests.ClientRequestContext;
import de.inahware.edvj.I18N;
import de.inahware.edvj.data.model.DataModelMap;
import de.inahware.edvj.sql.ArchiveReader;
import de.inahware.edvj.sql.ArchiveWriter;
import de.inahware.edvj.sql.MigrationManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.function.FailableFunction;
import org.jooq.DSLContext;

public class Models {
    private static final MigrationManager MIGRATIONS = new MigrationManager().with(new M000001CreateSetting(), new M000002CreateCloudServerInstance(), new M000003CreateUser(), new M000004CreateRole(), new M000005CreateSession(), new M000006CreateCounter(), new M000007CreateText(), new M000008CreateCustomerVendorAddress(), new M000009CreateTaxRate(), new M000010CreateAttachment(), new M000011CreateArticleGroup(), new M000012CreateArticle(), new M000013CreateArticleVendor(), new M000014CreateDiscount(), new M000015CreateOrder(), new M000016CreateDocument(), new M000017CreateNotice(), new M000018CreateRecordCategory(), new M000019CreateRecord(), new M000020CreateBankStatement(), new M000021CreateTask()).with(Tables.ADDRESS, Tables.ARTICLE, Tables.ARTICLE_GROUP, Tables.ARTICLE_VENDOR, Tables.ATTACHMENT, Tables.BANK_STATEMENT, Tables.BANK_STATEMENT_ITEM, Tables.CLOUDSERVER_INSTANCE, Tables.COUNTER, Tables.CUSTOMER, Tables.DEDUCTION, Tables.DISCOUNT, Tables.DOCUMENT, Tables.DOCUMENT_DOCUMENT, Tables.LINE_ITEM, Tables.NOTICE, Tables.ORDER, Tables.ORDER_DOCUMENT, Tables.PENDING_NOTICE, Tables.RECORD, Tables.RECORD_CATEGORY, Tables.ROLE, Tables.SESSION, Tables.SETTING, Tables.TASK, Tables.TAX_RATE, Tables.TEXT, Tables.USER, Tables.USER_AUTH_CLOUDSERVER, Tables.USER_AUTH_PASSWORD, Tables.USER_ROLE, Tables.VENDOR);
    public static final DataModelMap<ClientRequestContext> MODELS = new DataModelMap<ClientRequestContext>().with(new AddressController()).with(new ArticleController()).with(new ArticleGroupController()).with(new ArticleVendorController()).with(new ArticleVendorViewController()).with(new AttachmentController()).with(new BankStatementController()).with(new BankStatementFullController()).with(new BankStatementItemController()).with(new CloudserverInstanceViewController()).with(new CounterController()).with(new CustomerController()).with(new DeductionController()).with(new DiscountController()).with(new DiscountViewController()).with(new DocumentController()).with(new DocumentFullController()).with(new DocumentViewController()).with(new LineItemController()).with(new NoticeController()).with(new OrderController()).with(new OrderDocumentViewController()).with(new OrderViewController()).with(new PendingNoticeController()).with(new RecordController()).with(new RecordCategoryController()).with(new RoleController()).with(new SettingController()).with(new TaskController()).with(new TaxRateController()).with(new TextController()).with(new UserController()).with(new UserAuthCloudserverController()).with(new UserRoleController()).with(new VendorController());
    public static final ObjectMapper MAPPER = new ObjectMapper(((JsonFactoryBuilder)((JsonFactoryBuilder)((JsonFactoryBuilder)new JsonFactoryBuilder().disable(StreamWriteFeature.AUTO_CLOSE_TARGET)).enable(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN)).disable(StreamReadFeature.AUTO_CLOSE_SOURCE)).build()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).registerModule(new JavaTimeModule());

    public static void reset(DSLContext dsl, Path storagePath) throws Exception {
        MIGRATIONS.reset(dsl);
        if (Files.exists(storagePath, new LinkOption[0])) {
            try (Stream<Path> lazy = Files.list(storagePath);){
                for (Path p : lazy::iterator) {
                    FileUtils.deleteQuietly(p.toFile());
                }
            }
        }
    }

    public static void migrate(DSLContext dsl) throws Exception {
        MIGRATIONS.migrate(dsl);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize(DSLContext dsl, Path storagePath, boolean singleUser) throws Exception {
        void var7_16;
        Object counter;
        void var7_13;
        Setting[] settings;
        ResourceBundle BUNDLE = I18N.getBundle();
        Setting[] settingArray = settings = new Setting[]{new Setting("company.name", "Firmenname"), new Setting("company.salutation", ""), new Setting("company.prefix", ""), new Setting("company.firstName", ""), new Setting("company.lastName", ""), new Setting("company.address1", ""), new Setting("company.address2", ""), new Setting("company.country", "DE"), new Setting("company.phone", ""), new Setting("company.fax", ""), new Setting("company.email", ""), new Setting("company.internet", ""), new Setting("company.steuernummer", ""), new Setting("company.vat_number", ""), new Setting("company.iban", ""), new Setting("company.bic", ""), new Setting("company.kleinunternehmer", "false")};
        int n = settingArray.length;
        boolean bl = false;
        while (var7_13 < n) {
            Setting setting = settingArray[var7_13];
            if (!dsl.fetchExists(dsl.selectFrom(Tables.SETTING).where(Tables.SETTING.NAME.eq(setting.getName())))) {
                dsl.newRecord(Tables.SETTING, setting).insert();
            }
            ++var7_13;
        }
        if (!dsl.fetchExists(Tables.USER) && !dsl.fetchExists(Tables.ROLE)) {
            Role rootGroup = new Role();
            rootGroup.setId(1L);
            rootGroup.setName("root");
            rootGroup.getPermissions().insert("*");
            dsl.newRecord(Tables.ROLE, rootGroup).insert();
            User root = new User();
            root.setId(1L);
            root.setLocked(false);
            root.setUsername("admin");
            root.setName("Administrator");
            dsl.newRecord(Tables.USER, root).insert();
            UserRoleRecord userRoleRecord = dsl.newRecord(Tables.USER_ROLE);
            userRoleRecord.setUserId(root.getId());
            userRoleRecord.setRoleId(rootGroup.getId());
            userRoleRecord.insert();
            if (!singleUser) {
                String algorithm = Hashing.getDefault();
                byte[] byArray = Hashing.generatePasswordHashEntry(algorithm, "admin".toCharArray());
                UserAuthPasswordRecord auth = dsl.newRecord(Tables.USER_AUTH_PASSWORD);
                auth.setUserId(root.getId());
                auth.setPasswordAlgorithm(algorithm);
                auth.setPasswordHash(byArray);
                auth.insert();
            }
        }
        if (!dsl.fetchExists(dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Customer")))) {
            counter = new Counter();
            ((Counter)counter).setName("Customer");
            ((Counter)counter).setPrefix("C");
            ((Counter)counter).setLength((byte)1);
            ((Counter)counter).setSuffix("");
            ((Counter)counter).setResetOnPrefixChange(false);
            dsl.newRecord(Tables.COUNTER, counter).insert();
        }
        if (!dsl.fetchExists(dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Vendor")))) {
            counter = new Counter();
            ((Counter)counter).setName("Vendor");
            ((Counter)counter).setPrefix("V");
            ((Counter)counter).setLength((byte)1);
            ((Counter)counter).setSuffix("");
            ((Counter)counter).setResetOnPrefixChange(false);
            dsl.newRecord(Tables.COUNTER, counter).insert();
        }
        if (!dsl.fetchExists(dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Order")))) {
            counter = new Counter();
            ((Counter)counter).setName("Order");
            ((Counter)counter).setPrefix("O");
            ((Counter)counter).setLength((byte)1);
            ((Counter)counter).setSuffix("");
            ((Counter)counter).setResetOnPrefixChange(false);
            dsl.newRecord(Tables.COUNTER, counter).insert();
        }
        if (!dsl.fetchExists(dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq("Document.DRAFT")))) {
            counter = new Counter();
            ((Counter)counter).setName("Document.DRAFT");
            ((Counter)counter).setPrefix("draft#");
            ((Counter)counter).setLength((byte)1);
            ((Counter)counter).setSuffix("");
            ((Counter)counter).setResetOnPrefixChange(false);
            dsl.newRecord(Tables.COUNTER, counter).insert();
        }
        counter = DocumentType.values();
        int root = ((DocumentType[])counter).length;
        boolean bl2 = false;
        while (var7_16 < root) {
            Object type = counter[var7_16];
            if (((DocumentType)((Object)type)).getNumberType() == type) {
                String string = "Document." + (DocumentType)((Object)type);
                if (!dsl.fetchExists(dsl.selectFrom(Tables.COUNTER).where(Tables.COUNTER.NAME.eq(string)))) {
                    Counter counter2 = new Counter();
                    counter2.setName(string);
                    switch (3.$SwitchMap$de$inahware$dav$models$types$DocumentType[((Enum)type).ordinal()]) {
                        case 1: {
                            counter2.setPrefix("OF");
                            break;
                        }
                        case 2: {
                            counter2.setPrefix("CF");
                            break;
                        }
                        case 3: {
                            counter2.setPrefix("RC");
                            break;
                        }
                        case 4: {
                            counter2.setPrefix("IV");
                            break;
                        }
                        case 5: {
                            counter2.setPrefix("CI");
                            break;
                        }
                        case 6: {
                            counter2.setPrefix("RQ");
                            break;
                        }
                        case 7: {
                            counter2.setPrefix("PR");
                            break;
                        }
                        case 8: {
                            counter2.setPrefix("PY");
                            break;
                        }
                        case 9: {
                            counter2.setPrefix("CN");
                            break;
                        }
                        default: {
                            new RuntimeException("unreachable");
                        }
                    }
                    counter2.setLength((byte)8);
                    counter2.setSuffix("");
                    counter2.setResetOnPrefixChange(false);
                    dsl.newRecord(Tables.COUNTER, counter2).insert();
                }
            }
            ++var7_16;
        }
        if (!dsl.fetchExists(Tables.TAX_RATE)) {
            TaxRate t_ust = new TaxRate();
            t_ust.setEnabled(true);
            t_ust.setName("Umsatzsteuer");
            t_ust.setComment("2021");
            t_ust.setRate(new BigDecimal(19));
            dsl.newRecord(Tables.TAX_RATE, t_ust).insert();
            TaxRate t_ust2 = new TaxRate();
            t_ust2.setEnabled(true);
            t_ust2.setName("Umsatzsteuer vermindert");
            t_ust2.setComment("2021");
            t_ust2.setRate(new BigDecimal(7));
            dsl.newRecord(Tables.TAX_RATE, t_ust2).insert();
        }
        ArrayList<Object> texts = new ArrayList<Object>();
        for (Salutation salutation : Salutation.values()) {
            texts.add("Letter.opening." + salutation);
        }
        texts.add("Letter.opening.company");
        texts.add("Letter.closing");
        for (Enum enum_ : DocumentType.values()) {
            texts.add("Document." + (DocumentType)enum_ + ".head");
            texts.add("Document." + (DocumentType)enum_ + ".foot");
        }
        texts.add("Kleinunternehmerregelung");
        for (int i = 1; i <= 3; ++i) {
            texts.add("Notice.number_" + i);
        }
        for (String string : texts) {
            if (dsl.fetchExists(dsl.selectFrom(Tables.TEXT).where(Tables.TEXT.NAME.eq(string)))) continue;
            Text text = new Text();
            text.setName(string);
            text.setText(BUNDLE.getString("Texts." + string + ".text"));
            dsl.newRecord(Tables.TEXT, text).insert();
        }
    }

    public static void exportBackup(DSLContext dsl, Path storagePath, OutputStream output) throws Exception {
        final ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(output);
        zipOut.setUseZip64(Zip64Mode.Always);
        zipOut.putArchiveEntry(new ZipArchiveEntry("database/"));
        zipOut.closeArchiveEntry();
        MIGRATIONS.exportBackup(dsl, new ArchiveWriter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T nextValue(String name, FailableFunction<OutputStream, T, Exception> fn) throws Exception {
                zipOut.putArchiveEntry(new ZipArchiveEntry("database/" + name));
                try {
                    T t = fn.apply(zipOut);
                    return t;
                }
                finally {
                    zipOut.closeArchiveEntry();
                }
            }
        });
        try (Stream<Path> lazy = Files.walk(storagePath, new FileVisitOption[0]);){
            for (Path p : lazy::iterator) {
                Path rel = storagePath.relativize(p);
                String name = StreamSupport.stream(rel.spliterator(), false).map(Path::toString).collect(Collectors.joining("/"));
                if (Files.isDirectory(p, new LinkOption[0])) {
                    zipOut.putArchiveEntry(new ZipArchiveEntry("storage/" + (String)(name.isEmpty() ? "" : name + "/")));
                    zipOut.closeArchiveEntry();
                    continue;
                }
                zipOut.putArchiveEntry(new ZipArchiveEntry("storage/" + name));
                Files.copy(p, zipOut);
                zipOut.closeArchiveEntry();
            }
        }
        zipOut.finish();
    }

    public static void importBackup(DSLContext dsl, Path storagePath, InputStream input) throws Exception {
        final ZipArchiveInputStream zipIn = new ZipArchiveInputStream(input);
        ZipArchiveEntry entry = zipIn.getNextZipEntry();
        if (!entry.getName().equals("database/")) {
            throw new RuntimeException("format error");
        }
        MIGRATIONS.importBackup(dsl, new ArchiveReader(){

            @Override
            public <T> T nextValue(String name, FailableFunction<InputStream, T, Exception> fn) throws Exception {
                ZipArchiveEntry entry = zipIn.getNextZipEntry();
                if (!entry.getName().equals("database/" + name)) {
                    throw new RuntimeException("format error");
                }
                return fn.apply(zipIn);
            }
        });
        while ((entry = zipIn.getNextZipEntry()) != null) {
            if (!entry.getName().startsWith("storage/")) continue;
            String name = entry.getName().substring("storage/".length());
            Path dest = storagePath.resolve(name);
            if (entry.isDirectory()) {
                Files.createDirectories(dest, new FileAttribute[0]);
                continue;
            }
            Files.copy(zipIn, dest, new CopyOption[0]);
        }
    }
}

