/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Locale;

public class Notice
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.NOTICE.ID, ColumnFlag.PRIMARY);
    public static final SQLConvertColumn<OrderState, String> COL_STATE = new SQLConvertColumn(OrderState.class, Tables.NOTICE.STATE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_DOCUMENT_ID = new SQLColumn(Tables.NOTICE.DOCUMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_DOCUMENT_NUMBER = new SQLColumn(Tables.NOTICE.DOCUMENT_NUMBER, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_DATE = new SQLColumn(Tables.NOTICE.DATE, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_PAYMENT_DATE = new SQLColumn(Tables.NOTICE.PAYMENT_DATE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_COUNT = new SQLColumn(Tables.NOTICE.COUNT, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_REMAINING_PRICE = new SQLColumn(Tables.DOCUMENT.REMAINING_PRICE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_CUSTOMER_ID = new SQLColumn(Tables.NOTICE.CUSTOMER_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COMPANY = new SQLColumn(Tables.DOCUMENT.COMPANY, new ColumnFlag[0]);
    public static final SQLConvertColumn<Salutation, String> COL_SALUTATION = new SQLConvertColumn(Salutation.class, Tables.DOCUMENT.SALUTATION, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_PREFIX = new SQLColumn(Tables.DOCUMENT.PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_FIRST_NAME = new SQLColumn(Tables.DOCUMENT.FIRST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_LAST_NAME = new SQLColumn(Tables.DOCUMENT.LAST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS1 = new SQLColumn(Tables.DOCUMENT.ADDRESS1, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS2 = new SQLColumn(Tables.DOCUMENT.ADDRESS2, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COUNTRY = new SQLColumn(Tables.DOCUMENT.COUNTRY, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ATTACHMENT_ID = new SQLColumn(Tables.DOCUMENT.ATTACHMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_HEADLESS_ATTACHMENT_ID = new SQLColumn(Tables.DOCUMENT.HEADLESS_ATTACHMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_PRINTED = new SQLColumn(Tables.DOCUMENT.PRINTED, new ColumnFlag[0]);
    public static final DataModel<Notice> MODEL = new DataModel<Notice>(Notice.class).with(COL_ID, Notice::getId, Notice::setId).with(COL_STATE, Notice::getState, Notice::setState).with(COL_DOCUMENT_ID, Notice::getDocumentId, Notice::setDocumentId).with(COL_DOCUMENT_NUMBER, Notice::getDocumentNumber, Notice::setDocumentNumber).with(COL_DATE, Notice::getDate, Notice::setDate).with(COL_PAYMENT_DATE, Notice::getPaymentDate, Notice::setPaymentDate).with(COL_COUNT, Notice::getCount, Notice::setCount).with(COL_REMAINING_PRICE, Notice::getRemainingPrice, Notice::setRemainingPrice).with(COL_CUSTOMER_ID, Notice::getCustomerId, Notice::setCustomerId).with(COL_COMPANY, Notice::getCompany, Notice::setCompany).with(COL_SALUTATION, Notice::getSalutation, Notice::setSalutation).with(COL_PREFIX, Notice::getPrefix, Notice::setPrefix).with(COL_FIRST_NAME, Notice::getFirstName, Notice::setFirstName).with(COL_LAST_NAME, Notice::getLastName, Notice::setLastName).with(COL_ADDRESS1, Notice::getAddress1, Notice::setAddress1).with(COL_ADDRESS2, Notice::getAddress2, Notice::setAddress2).with(COL_COUNTRY, Notice::getCountry, Notice::setCountry).with(COL_ATTACHMENT_ID, Notice::getAttachmentId, Notice::setAttachmentId).with(COL_HEADLESS_ATTACHMENT_ID, Notice::getHeadlessAttachmentId, Notice::setHeadlessAttachmentId).with(COL_PRINTED, Notice::getPrinted, Notice::setPrinted);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_DOCUMENT_ID, COL_DOCUMENT_NUMBER, COL_DATE, COL_PAYMENT_DATE, COL_COUNT, COL_REMAINING_PRICE, COL_CUSTOMER_ID, COL_COMPANY, COL_SALUTATION, COL_PREFIX, COL_FIRST_NAME, COL_LAST_NAME, COL_ADDRESS1, COL_ADDRESS2, COL_COUNTRY);
    private Long id;
    private OrderState state = OrderState.DRAFT;
    private Long documentId;
    private String documentNumber;
    private LocalDate date = LocalDate.now();
    private LocalDate paymentDate;
    private Long count;
    private BigDecimal remainingPrice;
    private Long customerId;
    private String company;
    private Salutation salutation;
    private String prefix;
    private String firstName;
    private String lastName;
    private String address1;
    private String address2;
    private String country = Locale.getDefault().getCountry();
    private Long attachmentId;
    private Long headlessAttachmentId;
    private Long printed = 0L;

    public Notice() {
    }

    public Notice(Notice obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public OrderState getState() {
        return this.state;
    }

    public void setState(OrderState state) {
        this.state = state;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public BigDecimal getRemainingPrice() {
        return this.remainingPrice;
    }

    public void setRemainingPrice(BigDecimal remainingPrice) {
        this.remainingPrice = remainingPrice;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Salutation getSalutation() {
        return this.salutation;
    }

    public void setSalutation(Salutation salutation) {
        this.salutation = salutation;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public Long getHeadlessAttachmentId() {
        return this.headlessAttachmentId;
    }

    public void setHeadlessAttachmentId(Long headlessAttachmentId) {
        this.headlessAttachmentId = headlessAttachmentId;
    }

    public Long getPrinted() {
        return this.printed;
    }

    public void setPrinted(Long printed) {
        this.printed = printed;
    }

    public void validate() throws Exception {
        if (this.documentNumber == null) {
            throw new ValidationException();
        }
        if (this.date == null) {
            throw new ValidationException("Notice.errors.missing_date");
        }
        if (this.paymentDate == null) {
            throw new ValidationException("Notice.errors.missing_payment_date");
        }
        if (!(this.getSalutation() != null || this.getPrefix().isEmpty() && this.getFirstName().isEmpty() && this.getLastName().isEmpty())) {
            throw new ValidationException();
        }
        if (this.getSalutation() != null && (this.getFirstName().isEmpty() || this.getLastName().isEmpty())) {
            throw new ValidationException("Address.errors.name_empty");
        }
        if (this.getCompany().isEmpty() && this.getSalutation() == null) {
            throw new ValidationException("Address.errors.salutation_or_company_required");
        }
    }
}

