/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.types.OrderState;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.time.LocalDate;
import java.util.Locale;

public class Order
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.ORDER.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<String> COL_NUMBER = new SQLColumn(Tables.ORDER.NUMBER, new ColumnFlag[0]);
    public static final SQLConvertColumn<OrderState, String> COL_STATE = new SQLConvertColumn(OrderState.class, Tables.ORDER.STATE, new ColumnFlag[0]);
    public static final SQLColumn<LocalDate> COL_DATE = new SQLColumn(Tables.ORDER.DATE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_USER_ID = new SQLColumn(Tables.ORDER.USER_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_TITLE = new SQLColumn(Tables.ORDER.TITLE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_CUSTOMER_ID = new SQLColumn(Tables.ORDER.CUSTOMER_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_VENDOR_ID = new SQLColumn(Tables.ORDER.VENDOR_ID, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_REFERENCE_NUMBER = new SQLColumn(Tables.ORDER.REFERENCE_NUMBER, new ColumnFlag[0]);
    public static final SQLConvertColumn<Salutation, String> COL_SALUTATION = new SQLConvertColumn(Salutation.class, Tables.ORDER.SALUTATION, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_PREFIX = new SQLColumn(Tables.ORDER.PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_FIRST_NAME = new SQLColumn(Tables.ORDER.FIRST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_LAST_NAME = new SQLColumn(Tables.ORDER.LAST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COMPANY = new SQLColumn(Tables.ORDER.COMPANY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COUNTRY = new SQLColumn(Tables.ORDER.COUNTRY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS1 = new SQLColumn(Tables.ORDER.ADDRESS1, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_ADDRESS2 = new SQLColumn(Tables.ORDER.ADDRESS2, new ColumnFlag[0]);
    public static final SQLConvertColumn<Salutation, String> COL_SHIPPING_SALUTATION = new SQLConvertColumn(Salutation.class, Tables.ORDER.SHIPPING_SALUTATION, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_PREFIX = new SQLColumn(Tables.ORDER.SHIPPING_PREFIX, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_FIRST_NAME = new SQLColumn(Tables.ORDER.SHIPPING_FIRST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_LAST_NAME = new SQLColumn(Tables.ORDER.SHIPPING_LAST_NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_COMPANY = new SQLColumn(Tables.ORDER.SHIPPING_COMPANY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_COUNTRY = new SQLColumn(Tables.ORDER.SHIPPING_COUNTRY, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_ADDRESS1 = new SQLColumn(Tables.ORDER.SHIPPING_ADDRESS1, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_SHIPPING_ADDRESS2 = new SQLColumn(Tables.ORDER.SHIPPING_ADDRESS2, new ColumnFlag[0]);
    public static final DataModel<Order> MODEL = new DataModel<Order>(Order.class).with(COL_ID, Order::getId, Order::setId).with(COL_NUMBER, Order::getNumber, Order::setNumber).with(COL_STATE, Order::getState, Order::setState).with(COL_DATE, Order::getDate, Order::setDate).with(COL_USER_ID, Order::getUserId, Order::setUserId).with(COL_TITLE, Order::getTitle, Order::setTitle).with(COL_CUSTOMER_ID, Order::getCustomerId, Order::setCustomerId).with(COL_VENDOR_ID, Order::getVendorId, Order::setVendorId).with(COL_REFERENCE_NUMBER, Order::getReferenceNumber, Order::setReferenceNumber).with(COL_SALUTATION, Order::getSalutation, Order::setSalutation).with(COL_PREFIX, Order::getPrefix, Order::setPrefix).with(COL_FIRST_NAME, Order::getFirstName, Order::setFirstName).with(COL_LAST_NAME, Order::getLastName, Order::setLastName).with(COL_COMPANY, Order::getCompany, Order::setCompany).with(COL_COUNTRY, Order::getCountry, Order::setCountry).with(COL_ADDRESS1, Order::getAddress1, Order::setAddress1).with(COL_ADDRESS2, Order::getAddress2, Order::setAddress2).with(COL_SHIPPING_SALUTATION, Order::getShippingSalutation, Order::setShippingSalutation).with(COL_SHIPPING_PREFIX, Order::getShippingPrefix, Order::setShippingPrefix).with(COL_SHIPPING_FIRST_NAME, Order::getShippingFirstName, Order::setShippingFirstName).with(COL_SHIPPING_LAST_NAME, Order::getShippingLastName, Order::setShippingLastName).with(COL_SHIPPING_COMPANY, Order::getShippingCompany, Order::setShippingCompany).with(COL_SHIPPING_COUNTRY, Order::getShippingCountry, Order::setShippingCountry).with(COL_SHIPPING_ADDRESS1, Order::getShippingAddress1, Order::setShippingAddress1).with(COL_SHIPPING_ADDRESS2, Order::getShippingAddress2, Order::setShippingAddress2);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withScope(MODEL.getName()).withUpdatableColumns(COL_STATE, COL_DATE, COL_USER_ID, COL_TITLE, COL_CUSTOMER_ID, COL_VENDOR_ID, COL_REFERENCE_NUMBER, COL_SALUTATION, COL_PREFIX, COL_FIRST_NAME, COL_LAST_NAME, COL_COMPANY, COL_COUNTRY, COL_ADDRESS1, COL_ADDRESS2, COL_SHIPPING_SALUTATION, COL_SHIPPING_PREFIX, COL_SHIPPING_FIRST_NAME, COL_SHIPPING_LAST_NAME, COL_SHIPPING_COMPANY, COL_SHIPPING_COUNTRY, COL_SHIPPING_ADDRESS1, COL_SHIPPING_ADDRESS2);
    private Long id;
    private String number;
    private OrderState state = OrderState.ONGOING;
    private LocalDate date = LocalDate.now();
    private Long userId;
    private String title;
    private Long customerId;
    private Long vendorId;
    private String referenceNumber = "";
    private Salutation salutation;
    private String prefix;
    private String firstName;
    private String lastName;
    private String company;
    private String country = Locale.getDefault().getCountry();
    private String address1;
    private String address2;
    private Salutation shippingSalutation;
    private String shippingPrefix;
    private String shippingFirstName;
    private String shippingLastName;
    private String shippingCompany;
    private String shippingCountry = Locale.getDefault().getCountry();
    private String shippingAddress1;
    private String shippingAddress2;

    public Order() {
    }

    public Order(Order obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public OrderState getState() {
        return this.state;
    }

    public void setState(OrderState state) {
        this.state = state;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(Long vendorId) {
        this.vendorId = vendorId;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Salutation getSalutation() {
        return this.salutation;
    }

    public void setSalutation(Salutation salutation) {
        this.salutation = salutation;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public Salutation getShippingSalutation() {
        return this.shippingSalutation;
    }

    public void setShippingSalutation(Salutation shippingSalutation) {
        this.shippingSalutation = shippingSalutation;
    }

    public String getShippingPrefix() {
        return this.shippingPrefix;
    }

    public void setShippingPrefix(String prefix) {
        this.shippingPrefix = prefix;
    }

    public String getShippingFirstName() {
        return this.shippingFirstName;
    }

    public void setShippingFirstName(String firstName) {
        this.shippingFirstName = firstName;
    }

    public String getShippingLastName() {
        return this.shippingLastName;
    }

    public void setShippingLastName(String lastName) {
        this.shippingLastName = lastName;
    }

    public String getShippingCompany() {
        return this.shippingCompany;
    }

    public void setShippingCompany(String company) {
        this.shippingCompany = company;
    }

    public String getShippingCountry() {
        return this.shippingCountry;
    }

    public void setShippingCountry(String country) {
        this.shippingCountry = country;
    }

    public String getShippingAddress1() {
        return this.shippingAddress1;
    }

    public void setShippingAddress1(String address1) {
        this.shippingAddress1 = address1;
    }

    public String getShippingAddress2() {
        return this.shippingAddress2;
    }

    public void setShippingAddress2(String address2) {
        this.shippingAddress2 = address2;
    }

    public void validate() throws Exception {
        if (!(this.getSalutation() != null || this.getPrefix().isEmpty() && this.getFirstName().isEmpty() && this.getLastName().isEmpty())) {
            throw new ValidationException();
        }
        if (this.getSalutation() != null && (this.getFirstName().isEmpty() || this.getLastName().isEmpty())) {
            throw new ValidationException("Address.errors.name_empty");
        }
        if (this.getSalutation() == null && this.getCompany().isEmpty()) {
            throw new ValidationException("Address.errors.salutation_or_company_required");
        }
        if (!(this.getShippingSalutation() != null || this.getShippingPrefix().isEmpty() && this.getShippingFirstName().isEmpty() && this.getShippingLastName().isEmpty())) {
            throw new ValidationException();
        }
        if (this.getShippingSalutation() != null && (this.getShippingFirstName().isEmpty() || this.getShippingLastName().isEmpty())) {
            throw new ValidationException("Address.errors.name_empty");
        }
        if (this.getShippingSalutation() == null && this.getShippingCompany().isEmpty()) {
            throw new ValidationException("Address.errors.salutation_or_company_required");
        }
    }
}

