/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.models.Models;
import de.inahware.dav.models.types.Contact;
import de.inahware.dav.models.types.Salutation;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Person
extends DataObject {
    private Long id;
    private String number;
    private Salutation salutation;
    private String prefix = "";
    private String firstName = "";
    private String lastName = "";
    private String company = "";
    private String contact = "[]";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Salutation getSalutation() {
        return this.salutation;
    }

    public void setSalutation(Salutation salutation) {
        this.salutation = salutation;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    protected String getContact() {
        return this.contact;
    }

    protected void setContact(String contact) {
        this.contact = contact;
    }

    public ArrayList<Contact> getContactList() {
        try {
            return Models.MAPPER.readValue(this.contact, new TypeReference<ArrayList<Contact>>(){});
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setContactList(List<Contact> contact) {
        try {
            this.contact = Models.MAPPER.writeValueAsString(contact);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.contact = null;
        }
    }

    public void validate() throws Exception {
        if (!(this.getSalutation() != null || this.getPrefix().isEmpty() && this.getFirstName().isEmpty() && this.getLastName().isEmpty())) {
            throw new ValidationException();
        }
        if (this.getSalutation() != null && (this.getFirstName().isEmpty() || this.getLastName().isEmpty())) {
            throw new ValidationException("Address.errors.name_empty");
        }
        if (this.getSalutation() == null && this.getCompany().isEmpty()) {
            throw new ValidationException("Address.errors.salutation_or_company_required");
        }
    }

    public String getDisplayName(ResourceBundle bundle) {
        return Person.getDisplayName(bundle, this.getSalutation(), this.getPrefix(), this.getFirstName(), this.getLastName(), this.getCompany());
    }

    public static String getDisplayName(ResourceBundle bundle, Salutation salutation, String prefix, String firstName, String lastName, String company) {
        String sal = salutation == null ? "" : salutation.getDisplayName(bundle);
        String name = Stream.of(sal, prefix, firstName, lastName).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
        return Stream.of(company, name).filter(s -> !s.isEmpty()).collect(Collectors.joining(" / "));
    }
}

