/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import de.inahware.dav.jooq.Tables;
import de.inahware.dav.models.Models;
import de.inahware.dav.models.types.RecordTaxEntry;
import de.inahware.edvj.I18N;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.jooq.JSON;

public class Record
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.RECORD.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<LocalDate> COL_DATE = new SQLColumn(Tables.RECORD.DATE, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_CATEGORY_ID = new SQLColumn(Tables.RECORD.CATEGORY_ID, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_NET_AMOUNT = new SQLColumn(Tables.RECORD.NET_AMOUNT, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_TOTAL_AMOUNT = new SQLColumn(Tables.RECORD.TOTAL_AMOUNT, new ColumnFlag[0]);
    public static final SQLConvertColumn<String, JSON> COL_TAXES = new SQLConvertColumn(String.class, Tables.RECORD.TAXES, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_DESCRIPTION = new SQLColumn(Tables.RECORD.DESCRIPTION, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_DOCUMENT_ID = new SQLColumn(Tables.RECORD.DOCUMENT_ID, new ColumnFlag[0]);
    public static final SQLColumn<Long> COL_ATTACHMENT_ID = new SQLColumn(Tables.RECORD.ATTACHMENT_ID, new ColumnFlag[0]);
    public static final DataModel<Record> MODEL = new DataModel<Record>(Record.class).with(COL_ID, Record::getId, Record::setId).with(COL_DATE, Record::getDate, Record::setDate).with(COL_CATEGORY_ID, Record::getCategoryId, Record::setCategoryId).with(COL_NET_AMOUNT, Record::getNetAmount, Record::setNetAmount).with(COL_TOTAL_AMOUNT, Record::getTotalAmount, Record::setTotalAmount).with(COL_TAXES, Record::getTaxes, Record::setTaxes).with(COL_DESCRIPTION, Record::getDescription, Record::setDescription).with(COL_DOCUMENT_ID, Record::getDocumentId, Record::setDocumentId).with(COL_ATTACHMENT_ID, Record::getAttachmentId, Record::setAttachmentId);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_DATE, COL_CATEGORY_ID, COL_NET_AMOUNT, COL_TOTAL_AMOUNT, COL_TAXES, COL_DESCRIPTION, COL_DOCUMENT_ID, COL_ATTACHMENT_ID);
    private Long id;
    private LocalDate date;
    private Long categoryId;
    private BigDecimal netAmount;
    private BigDecimal totalAmount;
    private String taxes = "[]";
    private String description;
    private Long documentId;
    private Long attachmentId;

    public Record() {
    }

    public Record(Record obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(BigDecimal netAmount) {
        this.netAmount = netAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    protected String getTaxes() {
        return this.taxes;
    }

    protected void setTaxes(String taxes) {
        this.taxes = taxes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long documentId) {
        this.documentId = documentId;
    }

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public void validate() throws Exception {
    }

    public ArrayList<RecordTaxEntry> getTaxEntries() {
        try {
            return Models.MAPPER.readValue(this.taxes, new TypeReference<ArrayList<RecordTaxEntry>>(){});
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTaxEntries(List<RecordTaxEntry> taxes) {
        try {
            this.taxes = Models.MAPPER.writeValueAsString(taxes);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.taxes = null;
        }
    }

    public String getDisplayName() {
        return "#" + this.getId() + ": [" + I18N.formatDate(this.getDate()) + "] " + I18N.formatDecimal(this.getTotalAmount()) + "; " + this.getDescription();
    }
}

