/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.edvj.I18N;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.math.BigDecimal;
import org.apache.commons.lang3.compare.ComparableUtils;

public class TaxRate
extends DataObject {
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.TAX_RATE.ID, ColumnFlag.PRIMARY);
    public static final SQLColumn<Long> COL_PREV_TAX_RATE_ID = new SQLColumn(Tables.TAX_RATE.PREV_TAX_RATE_ID, new ColumnFlag[0]);
    public static final SQLConvertColumn<Boolean, Byte> COL_ENABLED = new SQLConvertColumn(Boolean.class, Tables.TAX_RATE.ENABLED, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_NAME = new SQLColumn(Tables.TAX_RATE.NAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_COMMENT = new SQLColumn(Tables.TAX_RATE.COMMENT, new ColumnFlag[0]);
    public static final SQLColumn<BigDecimal> COL_RATE = new SQLColumn(Tables.TAX_RATE.RATE, new ColumnFlag[0]);
    public static final DataModel<TaxRate> MODEL = new DataModel<TaxRate>(TaxRate.class).with(COL_ID, TaxRate::getId, TaxRate::setId).with(COL_PREV_TAX_RATE_ID, TaxRate::getPrevTaxRateId, TaxRate::setPrevTaxRateId).with(COL_ENABLED, TaxRate::isEnabled, TaxRate::setEnabled).with(COL_NAME, TaxRate::getName, TaxRate::setName).with(COL_COMMENT, TaxRate::getComment, TaxRate::setComment).with(COL_RATE, TaxRate::getRate, TaxRate::setRate);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_NAME, COL_COMMENT);
    private Long id;
    private Long prevTaxRateId;
    private Boolean enabled;
    private String name;
    private String comment;
    private BigDecimal rate;

    public TaxRate() {
    }

    public TaxRate(TaxRate obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPrevTaxRateId() {
        return this.prevTaxRateId;
    }

    public void setPrevTaxRateId(Long prevTaxRateId) {
        this.prevTaxRateId = prevTaxRateId;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public void validate() throws Exception {
        if (!ComparableUtils.between(BigDecimal.ZERO, new BigDecimal(100)).test(this.rate)) {
            throw new ValidationException("TaxRate.errors.invalid_tax");
        }
    }

    public String getDisplayName() {
        return this.name + " (" + this.comment + ") (" + I18N.formatDecimal(this.rate) + "%)";
    }
}

