/*
 * Decompiled with CFR 0.152.
 */
package de.inahware.dav.models;

import de.inahware.dav.jooq.Tables;
import de.inahware.edvj.data.ColumnFlag;
import de.inahware.edvj.data.model.DataModel;
import de.inahware.edvj.data.model.DataObject;
import de.inahware.edvj.data.model.DataQueryGuard;
import de.inahware.edvj.data.model.ValidationException;
import de.inahware.edvj.sql.SQLColumn;
import de.inahware.edvj.sql.SQLConvertColumn;
import java.util.regex.Pattern;

public class User
extends DataObject {
    public static final Pattern REGEX_USERNAME = Pattern.compile("[a-zA-Z0-9.-_]*");
    public static final SQLColumn<Long> COL_ID = new SQLColumn(Tables.USER.ID, ColumnFlag.PRIMARY);
    public static final SQLConvertColumn<Boolean, Byte> COL_LOCKED = new SQLConvertColumn(Boolean.class, Tables.USER.LOCKED, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_USERNAME = new SQLColumn(Tables.USER.USERNAME, new ColumnFlag[0]);
    public static final SQLColumn<String> COL_NAME = new SQLColumn(Tables.USER.NAME, new ColumnFlag[0]);
    public static final DataModel<User> MODEL = new DataModel<User>(User.class).with(COL_ID, User::getId, User::setId).with(COL_LOCKED, User::isLocked, User::setLocked).with(COL_USERNAME, User::getUsername, User::setUsername).with(COL_NAME, User::getName, User::setName);
    public static final DataQueryGuard GUARD = new DataQueryGuard(MODEL).withUpdatableColumns(COL_LOCKED, COL_USERNAME, COL_NAME);
    private Long id;
    private Boolean locked = false;
    private String username = "";
    private String name = "";

    public User() {
    }

    public User(User obj) {
        this.copyFrom(obj);
    }

    @Override
    protected DataModel<?> getModel() {
        return MODEL;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void validate() throws Exception {
        if (this.username.isEmpty()) {
            throw new ValidationException("User.errors.username_empty");
        }
        if (!REGEX_USERNAME.matcher(this.username).matches()) {
            throw new ValidationException("User.errors.invalid_username");
        }
        if (this.name.isEmpty()) {
            throw new ValidationException("User.errors.name_empty");
        }
    }
}

